/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.form.ColMapUtil;
import kd.bplat.scmc.report.core.ColAlias;
import kd.bplat.scmc.report.core.EntityInfo;
import org.apache.commons.lang3.StringUtils;

public class RptSqlParser {
    private String sqlInfo;
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String AND = " and ";
    private static final String ON = " on ";
    private static final String JOIN = " join ";
    private static final String INNER = " inner ";
    private static final String LEFT = " left ";
    private static final String RIGHT = " right ";
    private static final String FULL = " full ";
    private List<EntityInfo> entityInfos;
    private String reBuildSql;

    public void parseSqlInfo(String sqlInfo) {
        if (StringUtils.isEmpty((CharSequence)sqlInfo)) {
            return;
        }
        this.sqlInfo = sqlInfo.replaceAll("\r|\n|\t", " ");
        this.parse();
    }

    public String getReBuildSql() {
        if (this.reBuildSql == null) {
            this.buildSql();
        }
        return this.reBuildSql;
    }

    private void buildSql() {
        StringBuilder selectPart = new StringBuilder(SELECT);
        StringBuilder fromPart = new StringBuilder();
        int i = 0;
        for (EntityInfo info : this.entityInfos) {
            for (ColAlias col : info.getSelectCols()) {
                if (i++ != 0) {
                    selectPart.append(',');
                    if (i % 8 == 0) {
                        selectPart.append(" \r\n");
                    }
                }
                selectPart.append(info.getAlias()).append('.').append(col.getCol()).append(' ').append(col.getAlias());
            }
            fromPart.append((CharSequence)info.buildSqlPart()).append("\r\n");
        }
        this.reBuildSql = selectPart.append("\r\n").append((CharSequence)fromPart).toString();
    }

    private void parse() {
        int selectIdx = this.sqlInfo.indexOf(SELECT);
        if (selectIdx < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11select\u5173\u952e\u5b57\u3002", (String)"RptSqlParser_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        int fromIdx = this.sqlInfo.indexOf(FROM);
        if (fromIdx < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11from\u5173\u952e\u5b57\u3002", (String)"RptSqlParser_1", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        String selectPart = this.sqlInfo.substring(selectIdx + SELECT.length(), fromIdx);
        List<String[]> selectCols = this.parseSelectPart(selectPart);
        if (selectCols.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u7684\u67e5\u8be2\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5select\u7684\u5b57\u6bb5\u3002", (String)"RptSqlParser_2", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        String joinPart = this.sqlInfo.substring(fromIdx + FROM.length());
        HashMap<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>(8);
        ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>(8);
        this.parseEntityInfo(joinPart, entityInfos, entityInfoMap);
        if (entityInfos.size() == 1) {
            EntityInfo entityInfo = (EntityInfo)entityInfos.get(0);
            String tbPrefix = StringUtils.isBlank((CharSequence)entityInfo.getAlias()) ? null : entityInfo.getAlias() + ".";
            for (String[] selectCol : selectCols) {
                String col = selectCol[0];
                if (tbPrefix != null && selectCol[0].startsWith(tbPrefix)) {
                    col = selectCol[0].substring(tbPrefix.length());
                }
                entityInfo.getSelectCols().add(new ColAlias(entityInfo, col, selectCol[1]));
            }
        } else {
            for (String[] selectCol : selectCols) {
                int idx = selectCol[0].indexOf(".");
                if (idx <= 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"select\u5b57\u6bb5\u4e2d\u201c{0}\u201d\u65e0\u6cd5\u786e\u5b9a\u5b57\u6bb5\u7684\u8868\u540d\u3002", (String)"RptSqlParser_3", (String)"mpscmm-mscommon-report", (Object[])new Object[]{selectCol[0]}));
                }
                String tbAlias = selectCol[0].substring(0, idx);
                EntityInfo entityInfo = (EntityInfo)entityInfoMap.get(tbAlias);
                if (entityInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"select\u5b57\u6bb5\u4e2d\u201c{0}\u201d\u65e0\u6cd5\u786e\u5b9a\u5b57\u6bb5\u7684\u8868\u540d\u3002", (String)"RptSqlParser_3", (String)"mpscmm-mscommon-report", (Object[])new Object[]{selectCol[0]}));
                }
                entityInfo.getSelectCols().add(new ColAlias(entityInfo, selectCol[0].substring(idx + 1), selectCol[1]));
            }
        }
        this.reSetTbAlias(entityInfos);
        this.entityInfos = Collections.unmodifiableList(entityInfos);
    }

    public List<EntityInfo> getEntityInfos() {
        return this.entityInfos;
    }

    private void reSetTbAlias(List<EntityInfo> entityInfos) {
        int i = 1;
        for (EntityInfo info : entityInfos) {
            info.setAlias("t" + i++);
        }
    }

    private EntityInfo buildEntity(String strPart, boolean isMainEntity) {
        String[] mainEntity = this.parseAlias(strPart);
        String msg = null;
        if (mainEntity == null) {
            msg = isMainEntity ? ResManager.loadKDString((String)"SQL\u7247\u6bb5\u201c{0}\u201d\u4e2d\u672a\u89e3\u6790\u5230\u67e5\u8be2\u7684\u4e3b\u5b9e\u4f53\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5from\u8bed\u53e5\u3002", (String)"RptSqlParser_4", (String)"mpscmm-mscommon-report", (Object[])new Object[]{strPart}) : ResManager.loadKDString((String)"SQL\u7247\u6bb5\u201c{0}\u201d\u4e2d\u672a\u89e3\u6790\u5230\u67e5\u8be2\u5b9e\u4f53\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5join\u8bed\u53e5\u3002", (String)"RptSqlParser_5", (String)"mpscmm-mscommon-report", (Object[])new Object[]{strPart});
            throw new KDBizException(msg);
        }
        if (!isMainEntity && StringUtils.isBlank((CharSequence)mainEntity[1])) {
            msg = ResManager.loadKDString((String)"SQL\u7247\u6bb5\u201c{0}\u201d\u4e2d\uff0c\u5b9e\u4f53\u672a\u6307\u5b9a\u522b\u540d\uff0c\u8bf7\u68c0\u67e5join\u8bed\u53e5\u3002", (String)"RptSqlParser_6", (String)"mpscmm-mscommon-report", (Object[])new Object[]{strPart});
            throw new KDBizException(msg);
        }
        EntityInfo info = new EntityInfo();
        info.setMainEntity(isMainEntity);
        info.setName(mainEntity[0]);
        info.setAlias(mainEntity[1]);
        return info;
    }

    private void parseEntityInfo(String joinPart, List<EntityInfo> entityInfos, Map<String, EntityInfo> entityInfoMap) {
        if (joinPart.indexOf(JOIN) < 0) {
            EntityInfo info = this.buildEntity(joinPart, true);
            entityInfos.add(info);
        } else {
            String[] joinParts = joinPart.split(JOIN);
            String joinType = null;
            for (int i = 0; i < joinParts.length; ++i) {
                joinType = this.parseJoinType(joinParts[i]);
                String tempStr = this.removeJoinTypeFlag(joinType, joinParts[i]);
                EntityInfo info = null;
                if (i == 0) {
                    info = this.buildEntity(tempStr, true);
                    if (StringUtils.isBlank((CharSequence)info.getAlias())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u5bf9\u8c61{0}\u7f3a\u5c11\u522b\u540d\uff0c\u65e0\u6cd5\u89e3\u6790\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"RptSqlParser_7", (String)"mpscmm-mscommon-report", (Object[])new Object[]{info.getName()}));
                    }
                } else {
                    int onIdx = tempStr.indexOf(ON);
                    if (onIdx > 0) {
                        String entityInfoStr = tempStr.substring(0, onIdx);
                        info = this.buildEntity(entityInfoStr, false);
                        String fsInfo = tempStr.substring(onIdx + ON.length());
                        String[] joinCols = fsInfo.split(AND);
                        this.parseAlljoinCols(entityInfoMap, info, joinCols);
                    } else {
                        throw new KDBizException(ResManager.loadKDString((String)"SQL\u7247\u6bb5\u201c{0}\u201d\uff0c\u7f3a\u5c11on\u6761\u4ef6\u3002", (String)"RptSqlParser_8", (String)"mpscmm-mscommon-report", (Object[])new Object[]{tempStr}));
                    }
                }
                entityInfoMap.put(info.getAlias(), info);
                info.setJoinType(joinType);
                entityInfos.add(info);
            }
            this.moveJoinType(entityInfos);
        }
    }

    private String addOnRightCols(String col, String rightTb, EntityInfo info, Map<String, EntityInfo> entityInfoMap) {
        int idx = col.indexOf(".");
        if (idx <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u89e3\u6790\u4e0d\u5230\u8868\u524d\u7f00\uff0c\u8bf7\u68c0\u67e5on\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"RptSqlParser_9", (String)"mpscmm-mscommon-report", (Object[])new Object[]{col}));
        }
        String currentTb = col.substring(0, idx);
        if (rightTb == null) {
            rightTb = currentTb;
            if (!entityInfoMap.containsKey(currentTb)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u524d\u7f00\u8868\u201c{1}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5on\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"RptSqlParser_10", (String)"mpscmm-mscommon-report", (Object[])new Object[]{col, currentTb}));
            }
        } else if (!currentTb.equals(rightTb)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u524d\u7f00\u5fc5\u987b\u662f\u201c{1}\u201d\uff0c\u8bf7\u68c0\u67e5on\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"RptSqlParser_11", (String)"mpscmm-mscommon-report", (Object[])new Object[]{col, rightTb}));
        }
        info.getOtherEntityOnCols().add(col.substring(rightTb.length() + 1));
        return rightTb;
    }

    private void addOnLeftCols(String col, String tbPrefix, EntityInfo info) {
        info.getEntityOnCols().add(col.substring(tbPrefix.length()));
    }

    private void parseAlljoinCols(Map<String, EntityInfo> entityInfoMap, EntityInfo info, String[] joinCols) {
        String leftColPrefix = info.getAlias() + ".";
        String rightTb = null;
        for (String joinCol : joinCols) {
            String[] joinColStr = joinCol.split("=");
            if (joinColStr.length == 2) {
                joinColStr[0] = joinColStr[0].replaceAll(" ", "");
                joinColStr[1] = joinColStr[1].replaceAll(" ", "");
                if (joinColStr[0].startsWith(leftColPrefix)) {
                    this.addOnLeftCols(joinColStr[0], leftColPrefix, info);
                    rightTb = this.addOnRightCols(joinColStr[1], rightTb, info, entityInfoMap);
                    continue;
                }
                if (joinColStr[1].startsWith(leftColPrefix)) {
                    this.addOnLeftCols(joinColStr[1], leftColPrefix, info);
                    rightTb = this.addOnRightCols(joinColStr[0], rightTb, info, entityInfoMap);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u201c{0}\u201d\uff0con\u6761\u4ef6\u201c{1}\u201d\u89e3\u6790\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8868\u540d\u3002", (String)"RptSqlParser_12", (String)"mpscmm-mscommon-report", (Object[])new Object[]{info.getName(), joinCol}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u201c{0}\u201d\uff0con\u6761\u4ef6\u201c{1}\u201d\u89e3\u6790\u5931\u8d25\uff0c\u672a\u627e\u5230\u201c=\u201d\u3002", (String)"RptSqlParser_13", (String)"mpscmm-mscommon-report", (Object[])new Object[]{info.getName(), joinCol}));
        }
        info.getOnCols().addAll(info.getEntityOnCols());
        EntityInfo joinEntity = entityInfoMap.get(rightTb);
        info.setJoinEntity(joinEntity);
        joinEntity.getOnCols().addAll(info.getOtherEntityOnCols());
    }

    private void moveJoinType(List<EntityInfo> entityInfos) {
        for (int i = entityInfos.size() - 1; i >= 0; --i) {
            entityInfos.get(i).setJoinType(i == 0 ? null : entityInfos.get(i - 1).getJoinType());
        }
    }

    public Map<String, String> buildColEntityMap(Map<String, String> colMap) {
        HashMap<String, String> result = new HashMap<String, String>(colMap.size());
        Map<String, ColAlias> colIdxs = this.buildColIdxMap();
        String key = null;
        for (Map.Entry<String, String> entry : colMap.entrySet()) {
            key = entry.getKey();
            result.put(key, colIdxs.get(colMap.get(key)).getEntity().getAlias());
        }
        return result;
    }

    public Set<String> getAllSelectCols() {
        HashSet<String> cols = new HashSet<String>(32);
        for (EntityInfo entityInfo : this.entityInfos) {
            for (ColAlias colAlias : entityInfo.getSelectCols()) {
                cols.add(colAlias.getFinalCol());
            }
        }
        return cols;
    }

    public Map<String, String> buildRepoColFullSrcColMap(Map<String, String> colMap) {
        HashMap<String, String> result = new HashMap<String, String>(colMap.size());
        Map<String, ColAlias> colIdxs = this.buildColIdxMap();
        String key = null;
        for (Map.Entry<String, String> entry : colMap.entrySet()) {
            key = entry.getKey();
            result.put(key, colIdxs.get(colMap.get(key)).getCol());
        }
        return result;
    }

    private Map<String, ColAlias> buildColIdxMap() {
        HashMap<String, ColAlias> cols = new HashMap<String, ColAlias>(32);
        for (EntityInfo entityInfo : this.entityInfos) {
            for (ColAlias colAlias : entityInfo.getSelectCols()) {
                cols.put(colAlias.getFinalCol(), colAlias);
            }
        }
        return cols;
    }

    private String removeJoinTypeFlag(String joinType, String srcStr) {
        return joinType == null ? srcStr : srcStr.replace(joinType, "");
    }

    private String parseJoinType(String joinPart) {
        joinPart = " " + joinPart + " ";
        if (joinPart.indexOf(INNER) >= 0) {
            return "inner";
        }
        if (joinPart.indexOf(LEFT) >= 0) {
            return "left";
        }
        if (joinPart.indexOf(FULL) >= 0 || joinPart.indexOf(RIGHT) >= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u201cfull join\u201d\u548c\u201cright join\u201d\u3002", (String)"RptSqlParser_14", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        return "inner";
    }

    private List<String[]> parseSelectPart(String selectPart) {
        String[] selectCols = selectPart.split(",");
        ArrayList<String[]> selectColList = new ArrayList<String[]>(selectCols.length);
        String[] result = null;
        for (String selectCol : selectCols) {
            result = this.parseAlias(selectCol);
            if (result == null) continue;
            selectColList.add(result);
        }
        return selectColList;
    }

    public TreeNode buildColTree() {
        TreeNode root = new TreeNode("", "selectcols", ResManager.loadKDString((String)"\u5b9e\u4f53\u67e5\u8be2\u5b9a\u4e49\u5b57\u6bb5", (String)"RptSqlParser_15", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        ArrayList<TreeNode> colNodes = new ArrayList<TreeNode>(16);
        MainEntityType entityType = null;
        String text = null;
        String id = null;
        String entityName = null;
        for (EntityInfo entity : this.entityInfos) {
            entityType = MetadataServiceHelper.getDataEntityType((String)entity.getName());
            entityName = entityType.getDisplayName().getLocaleValue() + ".";
            for (ColAlias colInfo : entity.getSelectCols()) {
                id = colInfo.getFinalCol();
                text = entityName + ColMapUtil.getColFullName(entityType, colInfo.getCol()) + "(" + id + ")";
                colNodes.add(new TreeNode("", id, text));
            }
        }
        for (TreeNode node : colNodes) {
            node.setParentid(root.getId());
            root.addChild(node);
        }
        root.setIsOpened(true);
        return root;
    }

    private String[] parseAlias(String partStr) {
        partStr = partStr.trim();
        int idx = partStr.lastIndexOf(" ");
        String[] cols = new String[2];
        if (idx < 0) {
            cols[0] = partStr.replaceAll(" ", "");
            cols[1] = "";
        } else {
            cols[0] = partStr.substring(0, idx).replaceAll(" ", "");
            cols[1] = partStr.substring(idx).replaceAll(" ", "");
        }
        return StringUtils.isBlank((CharSequence)cols[0]) ? null : cols;
    }

    private void checkColLegal() {
        HashSet<String> allCols = new HashSet<String>(16);
        for (EntityInfo info : this.entityInfos) {
            this.checkColRepeat(allCols, info);
            this.checkColExist(info);
        }
    }

    private void checkColRepeat(Set<String> allCols, EntityInfo info) {
        for (ColAlias colAlias : info.getSelectCols()) {
            if (allCols.add(colAlias.getFinalCol())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c{0}\u201d\uff0c\u4e0d\u80fd\u91cd\u590d\u52a0\u8f7d\u5b57\u6bb5\u201c{1}\u201d\uff0c\u8bf7\u66f4\u6362\u5b57\u6bb5\u6216\u522b\u540d\u3002", (String)"RptSqlParser_16", (String)"mpscmm-mscommon-report", (Object[])new Object[]{info.getAlias(), colAlias.getFinalCol()}));
        }
    }

    private MainEntityType tryGetMainEntityType(String entity) {
        try {
            return MetadataServiceHelper.getDataEntityType((String)entity);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5b9e\u4f53\u201c{0}\u201d\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u3002", (String)"RptSqlParser_17", (String)"mpscmm-mscommon-report", (Object[])new Object[]{entity});
            throw new KDBizException(msg);
        }
    }

    private void checkColExist(EntityInfo info) {
        MainEntityType type = this.tryGetMainEntityType(info.getName());
        for (ColAlias colAlias : info.getSelectCols()) {
            ColMapUtil.checkExist(type, colAlias.getCol());
        }
        for (String col : info.getOnCols()) {
            ColMapUtil.checkExist(type, col);
        }
    }

    public void checkQuery(QFilter fs) {
        this.checkColLegal();
        QFilter queryFs = new QFilter("1", "=", (Object)2);
        if (fs != null) {
            queryFs.and(fs);
        }
        for (EntityInfo info : this.entityInfos) {
            info.testQuery(queryFs);
        }
    }
}

