/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.report.ReportList;
import kd.bos.report.events.SummaryEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportTplForm
extends AbstractReportFormPlugin {
    private ReportConf confCache;

    public void afterCreateNewData(EventObject e) {
        this.initFilterAp();
        this.initShowKeyCols();
        this.initShowQtyCols();
        this.initSumKeyCols();
    }

    private void initSumKeyCols() {
        IDataModel model = this.getModel();
        Set<String> sumKeyCols = ReportUtil.parseCombColVal(model, "sumkeycols");
        Set<String> showKeyCols = ReportUtil.parseCombColVal(model, "showkeycols");
        this.fillComboItem("sumkeycols", colConf -> showKeyCols.contains(colConf.getCol()));
        boolean result = sumKeyCols.retainAll(showKeyCols);
        if (result) {
            model.setValue("sumkeycols", sumKeyCols.isEmpty() ? null : "," + StringUtils.join(sumKeyCols, (String)",") + ",");
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String reoprtEntity = this.getReoprtEntity();
        queryParam.getCustomParam().put("report", reoprtEntity);
        String asynQueryKey = this.reSetQueryKey();
        queryParam.getCustomParam().put("asynQueryKey", asynQueryKey);
        this.getPageCache().put(asynQueryKey, asynQueryKey);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.setAsynQuery(true);
    }

    private String reSetQueryKey() {
        String queryKey = this.getPageCache().get("asynQueryKey");
        if (queryKey == null) {
            queryKey = "asynQueryKey" + DB.genGlobalLongId();
            this.getPageCache().put("asynQueryKey", queryKey);
        } else {
            AppCache.get((String)"bos").remove(queryKey);
        }
        return queryKey;
    }

    public void setFloatButtomData(List<SummaryEvent> summaryEvents) {
        super.setFloatButtomData(summaryEvents);
        String asynQueryKey = this.getPageCache().get("asynQueryKey");
        if (asynQueryKey == null) {
            return;
        }
        String sumInfoStr = (String)AppCache.get((String)"bos").get(asynQueryKey, String.class);
        if (sumInfoStr == null) {
            return;
        }
        JSONObject sumInfo = JSON.parseObject((String)sumInfoStr);
        String col = null;
        BigDecimal sumVal = null;
        for (SummaryEvent event : summaryEvents) {
            col = event.getColumnName();
            sumVal = sumInfo.getBigDecimal(col);
            if (sumVal == null) continue;
            event.setFormatSummaryValue((Object)sumVal.stripTrailingZeros());
        }
    }

    protected final ReportConf getReportConf() {
        if (this.confCache == null) {
            this.confCache = ReportDataHandle.loadReportConf(this.getReoprtEntity());
        }
        return this.confCache;
    }

    private void initShowQtyCols() {
        this.fillComboItem("showqtycols", colConf -> "B".equals(colConf.getCalType()));
        this.fillDefVals("showqtycols", colConf -> "B".equals(colConf.getCalType()));
    }

    private void fillDefVals(String comboCol, ColFilter filter) {
        ReportConf conf = this.getReportConf();
        List<BigTableColConf> bigTableColConfs = conf.getBigTableColConf();
        StringBuilder selectedCols = new StringBuilder();
        int i = 0;
        for (BigTableColConf colConf : bigTableColConfs) {
            if (!filter.filter(colConf) || !colConf.isDefShow()) continue;
            if (i > 0) {
                selectedCols.append(',');
            }
            selectedCols.append(colConf.getCol());
            ++i;
        }
        this.getModel().setValue(comboCol, (Object)selectedCols.toString());
    }

    private void fillComboItem(String comboCol, ColFilter filter) {
        ReportConf conf = this.getReportConf();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        List<BigTableColConf> bigTableColConfs = conf.getBigTableColConf();
        for (BigTableColConf colConf : bigTableColConfs) {
            if (!filter.filter(colConf)) continue;
            combos.add(new ComboItem(new LocaleString(colConf.getColName()), colConf.getCol()));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl(comboCol);
        item.setComboItems(combos);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List headFilters;
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("reset".equals(key) && !(headFilters = this.getQueryParam().getFilter().getHeadFilters()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u91cd\u7f6e\u6f0f\u6597\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReportTplForm_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "showqtycols": 
            case "showkeycols": {
                List headFilters = this.getQueryParam().getFilter().getHeadFilters();
                if (headFilters.isEmpty()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u91cd\u7f6e\u6f0f\u6597\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReportTplForm_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
                this.getView().updateView(key);
                e.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "showkeycols": {
                this.changedShowKeyCols(e);
                break;
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.initSumKeyCols();
    }

    private void changedShowKeyCols(PropertyChangedArgs e) {
        this.initSumKeyCols();
    }

    private void initShowKeyCols() {
        this.fillComboItem("showkeycols", colConf -> "A".equals(colConf.getCalType()));
        this.fillDefVals("showkeycols", colConf -> "A".equals(colConf.getCalType()));
    }

    protected String getReoprtEntity() {
        return this.getModel().getDataEntityType().getName();
    }

    private void initFilterAp() {
        ReportConf conf = this.getReportConf();
        final HashMap renames = new HashMap(32);
        final Set<String> fsCol = ReportUtil.filterBigtableCols(conf, colConf -> {
            boolean result;
            String calType = colConf.getCalType();
            boolean bl = result = !"D".equals(calType) && !"B".equals(calType);
            if (result) {
                renames.put(colConf.getCol(), colConf.getColName());
            }
            return result;
        });
        String repoEntity = conf.getRepoEntity();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        Map allFields = type.getAllFields();
        final HashSet unitCols = new HashSet(8);
        IDataEntityProperty pro = null;
        for (Map.Entry field : allFields.entrySet()) {
            pro = (IDataEntityProperty)field.getValue();
            if (!(pro instanceof UnitProp)) continue;
            unitCols.add(field.getKey());
        }
        fsCol.removeAll(unitCols);
        this.setCols4FilterGrid(conf.getRepoEntity(), "commonfs", new Predicate<Map<String, Object>>(){

            @Override
            public boolean test(Map<String, Object> info) {
                boolean result = false;
                String fieldName = (String)info.get("fieldName");
                if (fieldName != null) {
                    String fieldCaption;
                    String[] splitName = fieldName.split("\\.");
                    if (fsCol.contains(splitName[0])) {
                        result = true;
                    } else if (unitCols.contains(splitName[0])) {
                        result = splitName.length > 1 && ("name".equals(splitName[1]) || "number".equals(splitName[1]));
                    }
                    String rename = (String)renames.get(splitName[0]);
                    if (result && rename != null && (fieldCaption = (String)info.get("fieldCaption")) != null) {
                        CharSequence[] splitCaption = fieldCaption.split("\\.");
                        splitCaption[0] = rename;
                        info.put("fieldCaption", String.join((CharSequence)".", splitCaption));
                    }
                }
                return result;
            }
        });
    }

    private void setCols4FilterGrid(String entityName, String grid, Predicate<Map<String, Object>> predicate) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(grid);
        filterGrid.SetValue(new FilterCondition());
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(new ArrayList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            GetFilterFieldsParameter filterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
            filterFieldsParameter.setNeedAliasEmptyFieldProp(true);
            filterFieldsParameter.setNeedFieldCompareType(false);
            List cols = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)filterFieldsParameter).stream().filter(predicate).collect(Collectors.toList());
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(grid);
    }

    private static interface ColFilter {
        public boolean filter(BigTableColConf var1);
    }
}

