/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.transform;

import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.transform.func.AddSumRowFunc;
import kd.bplat.scmc.report.core.transform.plan.RowSumPlan;

public class RowSumTransform
implements IDataXTransform {
    private List<RowSumPlan> rowSumPlans;

    public RowSumTransform(List<RowSumPlan> rowSumPlans) {
        this.rowSumPlans = rowSumPlans;
    }

    @Override
    public DataSetX doTransform(DataSetX srcData) {
        if (this.rowSumPlans == null || this.rowSumPlans.isEmpty()) {
            return srcData;
        }
        srcData = srcData.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType)}, new Object[]{"0"});
        RowMeta rowMeta = srcData.getRowMeta();
        Collection<String> sumKeyCols = null;
        AddSumRowFunc sumFunc = null;
        for (RowSumPlan rowSumPlan : this.rowSumPlans) {
            sumKeyCols = rowSumPlan.getSumKeyCols();
            sumFunc = new AddSumRowFunc(rowMeta, rowSumPlan);
            if (sumKeyCols != null && sumKeyCols.size() > 0) {
                srcData = srcData.groupBy(sumKeyCols.toArray(new String[0])).reduceGroup((GroupReduceFunction)sumFunc);
                continue;
            }
            srcData = srcData.reduceGroup((GroupReduceFunction)sumFunc);
        }
        return srcData;
    }

    public String toString() {
        return "RowSumTransform [rowSumPlans=" + this.rowSumPlans + "]";
    }
}

