/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.transform.func;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.entity.cache.AppCache;
import kd.bplat.scmc.report.core.transform.plan.RowSumPlan;
import kd.bplat.scmc.report.util.TransformUtil;

public class AddSumRowFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Collection<String> keyCols;
    private Collection<String> qtyCols;
    private RowMeta rowMeta;
    private final Map<String, Integer> indexs;
    private final String countType;
    private final String countName;
    private int countTypeColIndex;
    private String asynQueryKey;

    public AddSumRowFunc(RowMeta rowMeta, RowSumPlan rowSumPlan) {
        this.rowMeta = rowMeta;
        this.keyCols = rowSumPlan.getSumKeyCols() == null ? Collections.emptySet() : rowSumPlan.getSumKeyCols();
        this.qtyCols = rowSumPlan.getSumQtyCols() == null ? Collections.emptySet() : rowSumPlan.getSumQtyCols();
        ArrayList<String> cols = new ArrayList<String>(this.keyCols.size() + this.qtyCols.size() + 1);
        cols.add("linetype");
        cols.addAll(this.keyCols);
        cols.addAll(this.qtyCols);
        this.indexs = TransformUtil.buildIndexs(rowMeta, cols);
        this.countTypeColIndex = this.indexs.get("linetype");
        this.countType = rowSumPlan.getCountType() == null ? "0" : rowSumPlan.getCountType();
        this.countName = rowSumPlan.getCountName();
        this.asynQueryKey = rowSumPlan.getAsynQueryKey();
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal[] qtys = null;
        Object[] rowVals = null;
        int index = -1;
        for (RowX row : rows) {
            if (this.countType.equals(row.get(this.countTypeColIndex))) {
                if (rowVals == null || qtys == null) {
                    rowVals = new Object[row.size()];
                    qtys = new BigDecimal[row.size()];
                    for (String keyCol : this.keyCols) {
                        index = this.indexs.get(keyCol);
                        rowVals[index] = row.get(index);
                    }
                    for (String qtyCol : this.qtyCols) {
                        index = this.indexs.get(qtyCol);
                        qtys[index] = row.getBigDecimal(index);
                    }
                } else {
                    BigDecimal val = null;
                    for (String qtyCol : this.qtyCols) {
                        index = this.indexs.get(qtyCol);
                        val = row.getBigDecimal(index);
                        if (val == null) continue;
                        qtys[index] = qtys[index].add(val);
                    }
                }
            }
            collector.collect(row);
        }
        if (rowVals != null && qtys != null) {
            int len = qtys.length;
            for (int i = 0; i < len; ++i) {
                if (qtys[i] == null) continue;
                rowVals[i] = qtys[i];
            }
            this.sentSumInfo2Cache(qtys);
            rowVals[this.countTypeColIndex] = this.countName;
            collector.collect(new RowX(rowVals));
        }
    }

    private void sentSumInfo2Cache(BigDecimal[] qtys) {
        if (this.asynQueryKey == null) {
            return;
        }
        JSONObject sumInfo = new JSONObject();
        int len = qtys.length;
        for (int i = 0; i < len; ++i) {
            if (qtys[i] == null) continue;
            sumInfo.put(this.rowMeta.getFieldName(i), (Object)qtys[i]);
        }
        AppCache.get((String)"bos").put(this.asynQueryKey, (Object)sumInfo.toJSONString());
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

