/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FlexReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.entity.report.TimeReportColumn;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.tpl.IFilter;
import org.apache.commons.lang3.StringUtils;

public class ReportUtil {
    public static boolean isMatchCol(String fullColName, Set<String> matchCols) {
        if (fullColName == null) {
            return false;
        }
        String[] split = fullColName.split("\\.");
        return matchCols.contains(split[0]);
    }

    public static Set<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List<BigTableColConf> bigTableColConf = conf.getBigTableColConf();
        HashSet<String> fsCol = new HashSet<String>();
        for (BigTableColConf colConf : bigTableColConf) {
            if (!filter.filter(colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    public static Set<String> getDataCols(RowMeta rowMeta) {
        String[] fieldNames = rowMeta.getFieldNames();
        HashSet<String> cols = new HashSet<String>(fieldNames.length);
        for (String fieldName : fieldNames) {
            cols.add(fieldName);
        }
        return cols;
    }

    public static final Set<String> splitCombColVal(String combColVal) {
        return new HashSet<String>(ReportUtil.splitCombColToList(combColVal));
    }

    public static final List<String> splitCombColToList(String combColVal) {
        ArrayList<String> tempSet = new ArrayList<String>();
        if (combColVal != null) {
            String[] keys;
            for (String key : keys = combColVal.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                tempSet.add(key);
            }
        }
        return tempSet;
    }

    private static String getDisplayProp(String type) {
        switch (type = type == null ? "1" : type) {
            case "1": {
                return "name";
            }
            case "2": {
                return "number";
            }
            case "3": {
                return "name,number";
            }
            case "4": {
                return "number,name";
            }
        }
        return "name";
    }

    public static AbstractReportColumn createProLike(MainEntityType repoEntityType, BigTableColConf colConf) {
        String col = colConf.getCol();
        IDataEntityProperty likePro = repoEntityType.findProperty(col);
        LocaleString localColName = new LocaleString(colConf.getColName());
        Object resultCol = null;
        if (likePro instanceof FlexProp) {
            resultCol = ReportUtil.buildFlexCol(colConf, (FlexProp)likePro);
        } else if (likePro instanceof ItemClassProp) {
            ReportUtil.notSupport(likePro, col);
        } else if (likePro instanceof BasedataProp) {
            resultCol = ReportUtil.buildBasedataCol(colConf, (BasedataProp)likePro);
        } else if (likePro instanceof PriceProp) {
            resultCol = ReportUtil.buildPriceCol(col, localColName, (PriceProp)likePro, colConf.isSummary());
        } else if (likePro instanceof AmountProp) {
            resultCol = ReportUtil.buildAmountCol(col, localColName, (AmountProp)likePro, colConf.isSummary());
        } else if (likePro instanceof QtyProp) {
            resultCol = ReportUtil.buildQtyCol(col, localColName, (QtyProp)likePro, colConf.isSummary());
        } else if (likePro instanceof IntegerProp) {
            resultCol = ReportUtil.buildIntCol(col, localColName, (IntegerProp)likePro);
        } else if (likePro instanceof DecimalProp) {
            resultCol = ReportUtil.buildDecimalCol(col, localColName, (DecimalProp)likePro, colConf.isSummary());
        } else if (likePro instanceof ItemClassTypeProp) {
            ReportUtil.notSupport(likePro, col);
        } else {
            resultCol = likePro instanceof ComboProp ? ReportUtil.buildComboCol(col, localColName, (ComboProp)likePro) : (likePro instanceof DateTimeProp ? ReportUtil.buildTimeCol(col, localColName) : ReportUtil.buildTextCol(col, localColName, likePro));
        }
        if (likePro instanceof FieldProp && resultCol != null) {
            resultCol.setZeroShow(((FieldProp)likePro).isZeroShow());
        }
        return resultCol;
    }

    private static FlexReportColumn buildFlexCol(BigTableColConf colConf, FlexProp likePro) {
        FlexReportColumn column = new FlexReportColumn();
        column.setCaption(new LocaleString(colConf.getColName()));
        column.setFieldKey(colConf.getCol());
        column.setEntityId(likePro.getBaseEntityId());
        column.setDisplayProp(ReportUtil.getDisplayProp(colConf.getShowProp()));
        column.setFieldType("flex");
        return null;
    }

    private static ReportColumn buildBasedataCol(BigTableColConf colConf, BasedataProp likePro) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(colConf.getColName()));
        column.setFieldKey(colConf.getCol());
        column.setEntityId(likePro.getBaseEntityId());
        column.setDisplayProp(ReportUtil.getDisplayProp(colConf.getShowProp()));
        column.setFieldType("basedata");
        return column;
    }

    public static ReportColumn buildTextCol(String col, LocaleString localColName, IDataEntityProperty likePro) {
        TextReportColumn column = new TextReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setFieldType("text");
        return column;
    }

    private static ReportColumn buildIntCol(String col, LocaleString localColName, IntegerProp likePro) {
        ReportColumn column = new ReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setFieldType("integer");
        return column;
    }

    public static TimeReportColumn buildTimeCol(String col, LocaleString localColName) {
        TimeReportColumn column = new TimeReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setFieldType("time");
        return column;
    }

    public static ReportColumn buildPriceCol(String col, LocaleString localColName, PriceProp likePro, boolean summary) {
        return ReportUtil.buildPriceCol(col, localColName, likePro.getControlPropName(), summary);
    }

    public static ReportColumn buildPriceCol(String col, LocaleString localColName, String currencyCol, boolean summary) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setCurrencyField(currencyCol);
        column.setFieldType("price");
        column.setNoDisplayScaleZero(false);
        column.setSummary(summary ? 1 : 0);
        return column;
    }

    public static ReportColumn buildAmountCol(String col, LocaleString localColName, AmountProp likePro, boolean summary) {
        return ReportUtil.buildAmountCol(col, localColName, likePro.getControlPropName(), summary);
    }

    public static ReportColumn buildAmountCol(String col, LocaleString localColName, String currencyCol, boolean summary) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setCurrencyField(currencyCol);
        column.setFieldType("amount");
        column.setNoDisplayScaleZero(false);
        column.setSummary(summary ? 1 : 0);
        return column;
    }

    public static DecimalReportColumn buildQtyCol(String col, LocaleString localColName, String unitCol, boolean summary) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setMeasureUnitField(unitCol);
        column.setFieldType("qty");
        column.setNoDisplayScaleZero(true);
        column.setSummary(summary ? 1 : 0);
        return column;
    }

    public static DecimalReportColumn buildQtyCol(String col, LocaleString localColName, QtyProp likePro, boolean summary) {
        return ReportUtil.buildQtyCol(col, localColName, likePro.getControlPropName(), summary);
    }

    public static DecimalReportColumn buildDecimalCol(String col, LocaleString localColName, DecimalProp likePro, boolean summary) {
        return ReportUtil.buildDecimalCol(col, localColName, likePro.getPrecision(), summary);
    }

    public static DecimalReportColumn buildDecimalCol(String col, LocaleString localColName, int precision, boolean summary) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setScale(precision);
        column.setFieldType("decimal");
        column.setNoDisplayScaleZero(true);
        column.setSummary(summary ? 1 : 0);
        return column;
    }

    public static ComboReportColumn buildComboCol(String col, LocaleString localColName, int style, List<ValueMapItem> items) {
        ComboReportColumn column = new ComboReportColumn();
        column.setCaption(localColName);
        column.setFieldKey(col);
        column.setComboShowStyle(style);
        column.setComboItems(items);
        column.setFieldType("combofield");
        return column;
    }

    public static ComboReportColumn buildComboCol(String col, LocaleString localColName, ComboProp likePro) {
        return ReportUtil.buildComboCol(col, localColName, likePro.getShowStyle(), likePro.getComboItems());
    }

    private static void notSupport(IDataEntityProperty likePro, String col) {
        String type = likePro.getClass().getSimpleName();
        throw new KDBizException(ResManager.loadKDString((String)"{0}\u7c7b\u578b\u5b57\u6bb5\uff0c\u6682\u4e0d\u652f\u6301\u52a8\u6001\u521b\u5efa\uff0c\u53ef\u5728\u62a5\u8868\u9875\u9762\u6dfb\u52a0{1}\u5b57\u6bb5", (String)"ReportUtil_0", (String)"mpscmm-mscommon-report", (Object[])new Object[]{type, col}));
    }

    public static Set<String> parseCombColVal(IDataModel model, String combColName) {
        String combColVal = model.getDataEntity().getString(combColName);
        return ReportUtil.splitCombColVal(combColVal);
    }

    public static TreeNode buildRefColTree(MainEntityType repoType, String repoCol) {
        IDataEntityProperty pro = repoType.findProperty(repoCol);
        if (pro instanceof BasedataProp && !(pro instanceof FlexProp)) {
            String entity = ((BasedataProp)pro).getBaseEntityId();
            PropTreeBuildOption ops = new PropTreeBuildOption();
            ops.setIncludePKField(true);
            ops.setIncludeChildEntity(false);
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
            TreeNode treeData = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)ops);
            return treeData;
        }
        return null;
    }
}

