/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import org.apache.commons.lang3.StringUtils;

public class TransformUtil {
    private static final Map<DataType, Object> DEF_VAL_MAP;

    public static Map<String, Integer> buildIndexs(RowMeta rowMeta, Collection<String> cols) {
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(cols.size());
        for (String col : cols) {
            indexs.put(col, rowMeta.getFieldIndex(col));
        }
        return indexs;
    }

    public static Object getDefVal(DataType type) {
        return DEF_VAL_MAP.get(type);
    }

    public static Object getDefVal(DataType type, String valStr) {
        return StringUtils.isNotBlank((CharSequence)valStr) ? type.convertValue((Object)valStr) : DEF_VAL_MAP.get(type);
    }

    static {
        HashMap<Object, Object> vals = new HashMap<Object, Object>();
        vals.put(DataType.StringType, "");
        vals.put(DataType.IntegerType, 0);
        vals.put(DataType.LongType, 0L);
        vals.put(DataType.DoubleType, 0.0);
        vals.put(DataType.BigDecimalType, BigDecimal.ZERO);
        DEF_VAL_MAP = Collections.unmodifiableMap(vals);
    }
}

