/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.WriteOffActionFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.action.WriteOffActionProcessor;

public class ReactWriteOffTask
extends AbstractTask {
    private static final String[] FAIL_STATUS = new String[]{"A"};
    private static final Log logger = LogFactory.getLog(ReactWriteOffTask.class);
    private static AtomicInteger atomInteger = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        int parallelCount = this.getParallelCount();
        if (atomInteger.get() >= parallelCount) {
            logger.info("ReactWriteOffTask\uff1a\u8d85\u8fc7\u6700\u5927\u5e76\u884c\u6570\u3002");
            return;
        }
        atomInteger.addAndGet(1);
        try {
            Long taskId = 0L;
            Long id = null;
            String op = null;
            String entity = null;
            Long billId = null;
            String traceId = RequestContext.get().getTraceId();
            try (DLock dlock = DLock.create((String)"ReactWriteOffTask");){
                if (dlock.tryLock(20000L)) {
                    DataSet taskInfoDS = QueryServiceHelper.queryDataSet((String)"ReactWriteOffTask.queryTask", (String)"msmod_wf_backwftask", (String)"id,billentity,billid,billop", (QFilter[])new QFilter("excuetetype", "in", (Object)FAIL_STATUS).toArray(), (String)"", (int)1);
                    Iterator iterator = taskInfoDS.iterator();
                    if (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        taskId = id = row.getLong("id");
                        this.updateExecuting(traceId, taskId);
                        entity = row.getString("billentity");
                        billId = row.getLong("billid");
                        op = row.getString("billop");
                    }
                    taskInfoDS.close();
                }
            }
            if (taskId == 0L) {
                return;
            }
            try {
                this.startWriteOff(Collections.singletonList(billId), entity, op);
                this.updateSucess(traceId, id);
            }
            catch (Exception e) {
                this.updateFail(traceId, id);
                throw e;
            }
        }
        finally {
            atomInteger.addAndGet(-1);
        }
    }

    private void updateSucess(String traceId, Long id) {
        try (TXHandle tx = TX.requiresNew();){
            SqlBuilder update = new SqlBuilder();
            update.append("update t_msmod_wf_backwftask set fexcuetetype = ? , ftraceid = ? where fid = ?", new Object[]{"C", traceId, id});
            DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)update);
        }
    }

    private void updateExecuting(String traceId, Long id) {
        try (TXHandle tx = TX.requiresNew();){
            SqlBuilder update = new SqlBuilder();
            update.append("update t_msmod_wf_backwftask set fexcuetetype = ? , ftraceid = ? where fid = ?", new Object[]{"B", traceId, id});
            DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)update);
        }
    }

    private void updateFail(String traceId, Long id) {
        try (TXHandle tx = TX.requiresNew();){
            SqlBuilder update = new SqlBuilder();
            update.append("update t_msmod_wf_backwftask set fexcuetetype = ? , ftraceid = ? where fid = ?", new Object[]{"F", traceId, id});
            DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)update);
        }
    }

    public void startWriteOff(List<Object> ids, String entityTypeName, String operationKey) {
        logger.info("\u5f00\u59cb\u4e86\u6d41\u7a0b\u6838\u9500info\uff0c\u53c2\u6570\u4e3a:ids:" + ids + ",entityTypeName:" + entityTypeName + ",operationKey:" + operationKey);
        try (TraceSpan span = Tracer.create((String)"WriteOffServiceImpl", (String)"startWriteOff");
             TXHandle tx = TX.requiresNew();){
            WriteOffActionProcessor processor = WriteOffActionProcessor.build(WriteOffActionFactory.getFlowConfigLoadActions());
            processor.doProcess(WriteOffExecuteContext.createFlow(entityTypeName, ids, operationKey));
        }
    }

    private int getParallelCount() {
        DBRoute route = new DBRoute("scm");
        try (DataSet paramSet = DB.queryDataSet((String)"getParallelCount", (DBRoute)route, (String)"select fvalue from t_im_invdbparam where fkey = 'wf_parallel_count'");){
            Iterator iterator = paramSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int n = Integer.parseInt(row.getString("fvalue"));
                return n;
            }
            int n = 1;
            return n;
        }
    }
}

