/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordGroupConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowSchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class WriteOffConfigManager {
    private Map<Long, WriteOffTypeConfig> writeOffTypeConfigMap = new HashMap<Long, WriteOffTypeConfig>(16);
    private Map<Long, SchemeConfig> schemeConfigMap = new HashMap<Long, SchemeConfig>(16);
    private Map<Long, MatchRuleConfig> matchRuleConfigMap = new HashMap<Long, MatchRuleConfig>(16);
    private Map<Long, WorkflowSchemeConfig> wflowSchemeConfigMap = new HashMap<Long, WorkflowSchemeConfig>(16);
    private Map<Long, RecordGroupConfig> recordGroupConfigMap = new HashMap<Long, RecordGroupConfig>(16);
    private Map<Long, WriteBackConfig> writeBackConfigMap = new HashMap<Long, WriteBackConfig>(16);
    private Map<Long, RecordMappingConfig> recordMappingConfigMap = new HashMap<Long, RecordMappingConfig>(16);
    private WriteOffExecuteContext wfExecuteContext;

    public WriteOffConfigManager(WriteOffExecuteContext wfExecuteContext) {
        this.wfExecuteContext = wfExecuteContext;
    }

    public WriteOffTypeConfig getWfTypeConfigById(Long wfTypeId) {
        WriteOffTypeConfig writeOffTypeConfig = this.writeOffTypeConfigMap.get(wfTypeId);
        if (writeOffTypeConfig == null) {
            throw new KDBizException(EngineLang.wfTypeValidateFail());
        }
        return writeOffTypeConfig;
    }

    public void addWriteOffTypeConfig(WriteOffTypeConfig wftypeConfig) {
        this.writeOffTypeConfigMap.put(wftypeConfig.getId(), wftypeConfig);
    }

    public List<WriteOffTypeConfig> getAllWriteOffTypeConfigs() {
        return new ArrayList<WriteOffTypeConfig>(this.writeOffTypeConfigMap.values());
    }

    public void addMatchRuleConfig(MatchRuleConfig config) {
        if (config != null) {
            this.matchRuleConfigMap.put((Long)config.getObjId(), config);
        }
    }

    public MatchRuleConfig getMatchRuleConfigById(Long matchRuleId, Long typeId) {
        MatchRuleConfig config = this.matchRuleConfigMap.get(matchRuleId);
        if (config == null) {
            WriteOffNLogInfo logInfo = this.wfExecuteContext.getWriteOffLogByTypeId(typeId);
            logInfo.setErrorType("E");
            DynamicObject matchRuleObj = BusinessDataServiceHelper.loadSingle((Object)matchRuleId, (String)"msmod_matchrule");
            if (matchRuleObj != null) {
                throw new KDBizException(EngineLang.matchValidateFailBan(matchRuleObj.getString("number")));
            }
            throw new KDBizException(EngineLang.matchValidateFailDelete(matchRuleId));
        }
        return config;
    }

    public MatchRuleConfig getMatchRuleConfigBySchemeId(Long schemeId, Long typeId) {
        SchemeConfig schemeConfig = this.getSchemeConfigById(schemeId, typeId);
        if (schemeConfig.isNoCondition()) {
            return null;
        }
        MatchRuleConfig config = this.getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeId);
        return config;
    }

    public void addSchemeContextConfig(SchemeConfig config) {
        if (config != null) {
            this.schemeConfigMap.put(config.getId(), config);
        }
    }

    public SchemeConfig getSchemeConfigById(Long schemeId, Long typeId) {
        SchemeConfig schemeConfig = this.schemeConfigMap.get(schemeId);
        if (schemeConfig == null) {
            WriteOffNLogInfo logInfo = this.wfExecuteContext.getWriteOffLogByTypeId(typeId);
            logInfo.setErrorType("E");
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"msmod_scheme");
            if (schemeObj != null) {
                throw new KDBizException(EngineLang.schemeValidateFailBan(schemeObj.getString("number")));
            }
            throw new KDBizException(EngineLang.schemeValidateFailDelete(schemeId));
        }
        return schemeConfig;
    }

    public RecordMappingConfig getMappingConfigById(long mappingId) {
        RecordMappingConfig recordMappingConfig = this.recordMappingConfigMap.get(mappingId);
        if (recordMappingConfig == null) {
            throw new KDBizException(EngineLang.recordMappingValidateFail());
        }
        return recordMappingConfig;
    }

    public Collection<RecordMappingConfig> getAllConfig() {
        return this.recordMappingConfigMap.values();
    }

    public List<SchemeConfig> getAllSchemeConfigs() {
        return new ArrayList<SchemeConfig>(this.schemeConfigMap.values());
    }

    public Map<Long, RecordGroupConfig> getRecordGroupConfigMap() {
        return this.recordGroupConfigMap;
    }

    public RecordGroupConfig getRecordGroupConfigById(Long matchGroupId) {
        return this.recordGroupConfigMap.get(matchGroupId);
    }

    public WriteBackConfig getWriteBackConfigById(Long backConfId) {
        WriteBackConfig writeBackConfig = this.writeBackConfigMap.get(backConfId);
        return writeBackConfig;
    }

    public void addRecordMappingConfig(RecordMappingConfig rmConfig) {
        if (rmConfig != null) {
            this.recordMappingConfigMap.put((Long)rmConfig.getObjId(), rmConfig);
        }
    }

    public void addWorkflowSchemeConfig(WorkflowSchemeConfig schemeConfig) {
        if (schemeConfig != null) {
            this.wflowSchemeConfigMap.put(schemeConfig.getWriteOffTypeId(), schemeConfig);
        }
    }

    public WorkflowSchemeConfig getWorkflowSchemeByWriteOffTypeId(Long wrtieOffTypeId) {
        return this.wflowSchemeConfigMap.get(wrtieOffTypeId);
    }

    public List<WorkflowSchemeConfig> getAllWorkflowScheme() {
        return new ArrayList<WorkflowSchemeConfig>(this.wflowSchemeConfigMap.values());
    }

    public void addRecordGroupConfig(RecordGroupConfig groupConfig) {
        if (groupConfig != null) {
            this.recordGroupConfigMap.put(groupConfig.getWriteOffTypeId(), groupConfig);
        }
    }

    public void addWriteBackConfg(WriteBackConfig writeBackConfig) {
        if (writeBackConfig != null) {
            this.writeBackConfigMap.put(writeBackConfig.getWriteOffTypeId(), writeBackConfig);
        }
    }
}

