/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.OpBizRuleSetReader;
import kd.bos.entity.OpBizRuleSetWriter;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffPluginRegisterService {
    private static final String WRITE_OFF_OP = "WriteoffOp";
    private static final String BACK_WRITE_OFF_OP = "BackWriteoffOp";

    public static Map<String, Map<String, Set<String>>> refreshRegister() {
        String billEntity;
        HashSet<String> registerBill = new HashSet<String>(16);
        List registerServices = OpBizRuleSetReader.load((QFilter[])new QFilter("opbizrule", "in", (Object)new String[]{WRITE_OFF_OP, BACK_WRITE_OFF_OP}).toArray());
        for (DynamicObject opbizRule : registerServices) {
            DynamicObject objType = opbizRule.getDynamicObject("objecttype");
            if (objType == null) continue;
            Iterator objNum = objType.getString("number");
            registerBill.add((String)((Object)objNum));
        }
        for (String bill : registerBill) {
            OpBizRuleSetWriter.deleteOpBizRuleSet((String)bill, (String)WRITE_OFF_OP);
            OpBizRuleSetWriter.deleteOpBizRuleSet((String)bill, (String)BACK_WRITE_OFF_OP);
        }
        HashMap wfOps = new HashMap(16);
        HashMap unwfOps = new HashMap(16);
        DynamicObjectCollection schemesets = QueryServiceHelper.query((String)"msmod_schemeset", (String)"number,name, msmod_scheme_bill.writeoffbill.wfbill as wfbill, msmod_scheme_bill.writeoffop as writeoffop,msmod_scheme_bill.rewriteoffop as rewriteoffop", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).and("writeofftype.writeofftype", "=", (Object)"A").toArray());
        for (DynamicObject schemeset : schemesets) {
            List<String> unwfOp;
            String wfBill = schemeset.getString("wfbill");
            List<String> wfOp = WriteOffPluginRegisterService.getSplitResult(schemeset.getString("writeoffop"));
            if (wfOp != null && !wfOp.isEmpty()) {
                MapUtils.mapGetSetValue(wfOps, wfBill).addAll(wfOp);
            }
            if ((unwfOp = WriteOffPluginRegisterService.getSplitResult(schemeset.getString("rewriteoffop"))) == null || unwfOp.isEmpty()) continue;
            MapUtils.mapGetSetValue(unwfOps, wfBill).addAll(unwfOp);
        }
        for (Map.Entry mapEntry : wfOps.entrySet()) {
            billEntity = (String)mapEntry.getKey();
            OpBizRuleSetWriter.saveOpBizRuleSet((String)billEntity, (String)WRITE_OFF_OP, new ArrayList((Collection)mapEntry.getValue()));
        }
        for (Map.Entry mapEntry : unwfOps.entrySet()) {
            billEntity = (String)mapEntry.getKey();
            OpBizRuleSetWriter.saveOpBizRuleSet((String)billEntity, (String)BACK_WRITE_OFF_OP, new ArrayList((Collection)mapEntry.getValue()));
        }
        HashMap<String, Map<String, Set<String>>> registerMap = new HashMap<String, Map<String, Set<String>>>(16);
        registerMap.put(WRITE_OFF_OP, wfOps);
        registerMap.put(BACK_WRITE_OFF_OP, unwfOps);
        return registerMap;
    }

    public static void register(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection schemeBills = bill.getDynamicObjectCollection("msmod_scheme_bill");
            List<String> diffBillList = WriteOffPluginRegisterService.getDiffBill(bill, schemeBills);
            WriteOffPluginRegisterService.dealBillRegister(schemeBills);
            for (String diffBill : diffBillList) {
                WriteOffPluginRegisterService.wfOpRegister(diffBill, new ArrayList<String>(10), new ArrayList<String>(10));
            }
        }
    }

    private static List<String> getDiffBill(DynamicObject bill, DynamicObjectCollection schemeBills) {
        DynamicObject wfType = bill.getDynamicObject("writeofftype");
        QFilter qFilter = new QFilter("id", "=", wfType.getPkValue());
        DynamicObjectCollection wfTypeBills = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"writeoffbillentry.writeoffbilltype as wfBill", (QFilter[])qFilter.toArray());
        ArrayList<String> wfTypeBillList = new ArrayList<String>(10);
        for (DynamicObject wfBill : wfTypeBills) {
            wfTypeBillList.add(wfBill.getString("wfBill"));
        }
        ArrayList<String> schemeBillList = new ArrayList<String>(10);
        for (DynamicObject schemeBill : schemeBills) {
            DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
            String number = writeOffBill.getDynamicObject("wfbill").getString("number");
            schemeBillList.add(number);
        }
        return wfTypeBillList.stream().filter(n -> !schemeBillList.contains(n)).collect(Collectors.toList());
    }

    public static void deleteBillRegister(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection schemeBills = bill.getDynamicObjectCollection("msmod_scheme_bill");
            WriteOffPluginRegisterService.dealDeleteBillRegister(schemeBills);
        }
    }

    private static void dealDeleteBillRegister(DynamicObjectCollection schemeBills) {
        for (DynamicObject schemeBill : schemeBills) {
            DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
            String number = writeOffBill.getDynamicObject("wfbill").getString("number");
            WriteOffPluginRegisterService.wfOpRegister(number, new ArrayList<String>(10), new ArrayList<String>(10));
        }
    }

    private static void dealBillRegister(DynamicObjectCollection schemeBills) {
        for (DynamicObject schemeBill : schemeBills) {
            DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
            String number = writeOffBill.getDynamicObject("wfbill").getString("number");
            String writeOffOp = schemeBill.getString("writeoffop");
            String rewriteOffOp = schemeBill.getString("rewriteoffop");
            List<String> writeOffOps = WriteOffPluginRegisterService.getSplitResult(writeOffOp);
            List<String> reWriteOffOp = WriteOffPluginRegisterService.getSplitResult(rewriteOffOp);
            WriteOffPluginRegisterService.wfOpRegister(number, writeOffOps, reWriteOffOp);
        }
    }

    private static void wfOpRegister(String number, List<String> writeOffOps, List<String> reWriteOffOp) {
        OpBizRuleSetWriter.deleteOpBizRuleSet((String)number, (String)WRITE_OFF_OP);
        OpBizRuleSetWriter.deleteOpBizRuleSet((String)number, (String)BACK_WRITE_OFF_OP);
        QFilter filter1 = new QFilter("msmod_scheme_bill.writeoffbill.wfbill", "=", (Object)number);
        DynamicObjectCollection opList = QueryServiceHelper.query((String)"msmod_schemeset", (String)"msmod_scheme_bill.writeoffop,msmod_scheme_bill.rewriteoffop", (QFilter[])filter1.toArray());
        for (DynamicObject op : opList) {
            String opString = op.getString("msmod_scheme_bill.writeoffop");
            String reWfOpString = op.getString("msmod_scheme_bill.rewriteoffop");
            writeOffOps.addAll(WriteOffPluginRegisterService.getSplitResult(opString));
            reWriteOffOp.addAll(WriteOffPluginRegisterService.getSplitResult(reWfOpString));
        }
        if (CollectionUtils.isNotEmpty(writeOffOps)) {
            OpBizRuleSetWriter.saveOpBizRuleSet((String)number, (String)WRITE_OFF_OP, new ArrayList<String>(writeOffOps));
        }
        if (CollectionUtils.isNotEmpty(reWriteOffOp)) {
            OpBizRuleSetWriter.saveOpBizRuleSet((String)number, (String)BACK_WRITE_OFF_OP, new ArrayList<String>(reWriteOffOp));
        }
    }

    private static List<String> getSplitResult(String writeOffOp) {
        if (StringUtils.isEmpty((CharSequence)writeOffOp)) {
            return new ArrayList<String>();
        }
        String[] split = writeOffOp.split(",");
        List<String> strings = Arrays.asList(split);
        List<String> writeOffOpNotEmptyList = strings.stream().filter(n -> StringUtils.isNotEmpty((CharSequence)n)).collect(Collectors.toList());
        return writeOffOpNotEmptyList;
    }
}

