/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class MatchConditionConfig
implements Cloneable {
    private String srcBillFieldName;
    private String srcBillFieldKey;
    private String srcBillType;
    private String comparison;
    private String targetBillFieldName;
    private String targetBillFieldKey;
    private Boolean hint;
    private String targetBillType;
    private Boolean emptyEqual;
    private IDataEntityProperty srcPropType;
    private IDataEntityProperty tgtPropType;

    public static MatchConditionConfig build(String srcFieldKey, String targetFieldKey) {
        MatchConditionConfig conditionConfig = new MatchConditionConfig();
        conditionConfig.setSrcBillFieldKey(srcFieldKey);
        conditionConfig.setComparison("=");
        conditionConfig.setTargetBillFieldKey(targetFieldKey);
        conditionConfig.setEmptyEqual(false);
        conditionConfig.setHint(true);
        return conditionConfig;
    }

    public static MatchConditionConfig build(DynamicObject matchCondition) {
        MatchConditionConfig conditionConfig = new MatchConditionConfig();
        String srcFieldKey = matchCondition.getString("srcbillfieldkey");
        String targetFieldKey = matchCondition.getString("targetbillfieldkey");
        if ("id,entryid".equals(targetFieldKey) || "id,entryid".equals(srcFieldKey)) {
            throw new KDBizException(EngineLang.NotSupportDoLargetTextMatch());
        }
        conditionConfig.setSrcBillFieldName(matchCondition.getString("srcbillfieldname"));
        conditionConfig.setSrcBillFieldKey(srcFieldKey);
        conditionConfig.setComparison(matchCondition.getString("comparison"));
        conditionConfig.setTargetBillFieldName(matchCondition.getString("targetbillfieldname"));
        conditionConfig.setTargetBillFieldKey(targetFieldKey);
        conditionConfig.setEmptyEqual(matchCondition.getBoolean("emptyequal"));
        conditionConfig.setHint(matchCondition.getBoolean("hint"));
        DynamicObject parent = (DynamicObject)matchCondition.getParent();
        conditionConfig.setSrcBillType(parent.getDynamicObject("srcbilltype").getString("wfbill.number"));
        conditionConfig.setSrcBillType(parent.getDynamicObject("targetbilltype").getString("wfbill.number"));
        return conditionConfig;
    }

    private MatchConditionConfig() {
    }

    protected MatchConditionConfig clone() {
        try {
            return (MatchConditionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void fieldExchange() {
        String srcBillFieldKey = this.getSrcBillFieldKey();
        String srcBillFieldName = this.getSrcBillFieldName();
        String targetBillFieldKey = this.getTargetBillFieldKey();
        String targetBillFieldName = this.getTargetBillFieldName();
        String srcBillType = this.getSrcBillType();
        String targetBillType = this.getTargetBillType();
        this.setSrcBillFieldKey(targetBillFieldKey);
        this.setSrcBillFieldName(targetBillFieldName);
        this.setTargetBillFieldKey(srcBillFieldKey);
        this.setTargetBillFieldName(srcBillFieldName);
        this.setSrcBillType(targetBillType);
        this.setTargetBillType(srcBillType);
        IDataEntityProperty srcPropType = this.getSrcPropType();
        this.srcPropType = this.tgtPropType;
        this.tgtPropType = srcPropType;
        this.setComparison(this.comparisonResver());
    }

    public String comparisonResver() {
        if (">=".equals(this.comparison)) {
            return "<=";
        }
        if ("<=".equals(this.comparison)) {
            return ">=";
        }
        if (">".equals(this.comparison)) {
            return "<";
        }
        if ("<".equals(this.comparison)) {
            return ">";
        }
        if ("C".equals(this.comparison)) {
            return "D";
        }
        if ("D".equals(this.comparison)) {
            return "C";
        }
        return this.comparison;
    }

    public String getSrcBillFieldName() {
        return this.srcBillFieldName;
    }

    void setSrcBillFieldName(String srcBillFieldName) {
        this.srcBillFieldName = srcBillFieldName;
    }

    public String getSrcBillFieldKey() {
        return this.srcBillFieldKey;
    }

    void setSrcBillFieldKey(String srcBillFieldKey) {
        this.srcBillFieldKey = srcBillFieldKey;
    }

    public String getComparison() {
        return this.comparison;
    }

    void setComparison(String comparison) {
        this.comparison = comparison;
    }

    public String getTargetBillFieldName() {
        return this.targetBillFieldName;
    }

    void setTargetBillFieldName(String targetBillFieldName) {
        this.targetBillFieldName = targetBillFieldName;
    }

    public String getTargetBillFieldKey() {
        return this.targetBillFieldKey;
    }

    void setTargetBillFieldKey(String targetBillFieldKey) {
        this.targetBillFieldKey = targetBillFieldKey;
    }

    public Boolean getEmptyEqual() {
        return this.emptyEqual;
    }

    void setEmptyEqual(Boolean emptyEqual) {
        this.emptyEqual = emptyEqual;
    }

    public String getSrcBillType() {
        return this.srcBillType;
    }

    void setSrcBillType(String srcBillType) {
        this.srcBillType = srcBillType;
    }

    public String getTargetBillType() {
        return this.targetBillType;
    }

    void setTargetBillType(String targetBillType) {
        this.targetBillType = targetBillType;
    }

    public Boolean getHint() {
        return this.hint;
    }

    void setHint(Boolean hint) {
        this.hint = hint;
    }

    public String toString() {
        return String.format("%s[%s] %s %s[%s]", this.srcBillFieldName, this.srcBillFieldKey, this.comparison, this.targetBillFieldName, this.targetBillFieldKey);
    }

    public IDataEntityProperty getSrcPropType() {
        if (this.srcPropType == null) {
            this.srcPropType = this.getProp(this.srcBillType, this.srcBillFieldKey);
        }
        return this.srcPropType;
    }

    public IDataEntityProperty getTgtPropType() {
        if (this.tgtPropType == null) {
            this.tgtPropType = this.getProp(this.targetBillType, this.targetBillFieldKey);
        }
        return this.tgtPropType;
    }

    private IDataEntityProperty getProp(String entity, String key) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        String[] splitSrcField = key.split("\\.");
        return dataEntityType.findProperty(splitSrcField[splitSrcField.length - 1]);
    }

    public boolean checkAllEmptyValues(Collection<Object> values) {
        for (Object value : values) {
            if (this.checkEmptyValue(value)) continue;
            return false;
        }
        return true;
    }

    public boolean checkEmptyValues(Collection<Object> values) {
        for (Object value : values) {
            if (!this.checkEmptyValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean checkEmptyValue(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return StringUtils.isEmpty((CharSequence)((String)value));
            }
            if (value instanceof BigDecimal) {
                return BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
            }
            if (value instanceof Long) {
                return Long.compare(0L, (Long)value) == 0;
            }
            if (value instanceof Integer) {
                return Integer.compare(0, (Integer)value) == 0;
            }
            return false;
        }
        return true;
    }

    public Set<Object> getEmptyValue() {
        HashSet<Object> emptValueSet = new HashSet<Object>(16);
        IDataEntityProperty srcProp = this.getSrcPropType();
        if (srcProp instanceof BasedataProp) {
            emptValueSet.add(0L);
        } else if (srcProp instanceof TextProp) {
            emptValueSet.add("");
            emptValueSet.add(" ");
            emptValueSet.add(null);
        } else {
            emptValueSet.add(null);
        }
        return emptValueSet;
    }

    public String getSrcValueKey() {
        String srcKey = this.getSrcBillFieldKey();
        if (MatcherUtil.isUseMasterid(this.srcPropType)) {
            srcKey = srcKey + ".masterid";
        }
        return srcKey;
    }

    public String getTgtValueKey() {
        String tgtKey = this.getTargetBillFieldKey();
        if (MatcherUtil.isUseMasterid(this.srcPropType)) {
            tgtKey = tgtKey + ".masterid";
        }
        return tgtKey;
    }
}

