/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import org.apache.commons.collections.CollectionUtils;

public class MatchRuleConfig
extends AbstractObjMappingConfig {
    private List<MatchRelationConfig> relationConfigs = new ArrayList<MatchRelationConfig>(16);

    public static MatchRuleConfig build(DynamicObject matchRuleObj) {
        MatchRuleConfig config = new MatchRuleConfig(matchRuleObj);
        config.initRelationConfigs();
        return config;
    }

    private void initRelationConfigs() {
        DynamicObjectCollection matchCollection = this.getObj().getDynamicObjectCollection("matchrelateentry");
        for (DynamicObject matchRelation : matchCollection) {
            MatchRelationConfig matchRelationConfig = MatchRelationConfig.build(this, matchRelation);
            this.relationConfigs.add(matchRelationConfig);
        }
    }

    public List<MatchRelationConfig> getByPromoter(WriteOffBillConfig billTypeConfig) {
        String name = billTypeConfig.getBillAlias();
        return this.getByPromoter(name);
    }

    public MatchRelationConfig getFristByPromoter(String billAlias) {
        List<MatchRelationConfig> cloneList = this.getByPromoter(billAlias);
        if (CollectionUtils.isNotEmpty(cloneList)) {
            return cloneList.get(0);
        }
        return null;
    }

    public List<MatchRelationConfig> getByPromoter(String billAlias) {
        ArrayList<MatchRelationConfig> cloneList = new ArrayList<MatchRelationConfig>(10);
        for (MatchRelationConfig config : this.getRelationConfigs()) {
            cloneList.add(config.clone());
        }
        ArrayList<MatchRelationConfig> list = new ArrayList<MatchRelationConfig>(10);
        this.sortMatchRelationByPromoter(billAlias, list, cloneList);
        return list;
    }

    private void sortMatchRelationByPromoter(String billTypeKey, List<MatchRelationConfig> list, List<MatchRelationConfig> cloneList) {
        List collect = cloneList.stream().filter(n -> n.getSrcBillTypeKey().equals(billTypeKey) || n.getTargetBillTypeKey().equals(billTypeKey)).collect(Collectors.toList());
        while (cloneList.size() > 0 && CollectionUtils.isNotEmpty(collect)) {
            for (MatchRelationConfig matchRelationConfig : collect) {
                if (matchRelationConfig.getSrcBillTypeKey().equals(billTypeKey)) {
                    if (!list.contains(matchRelationConfig)) {
                        list.add(matchRelationConfig);
                    }
                    cloneList.remove(matchRelationConfig);
                    this.sortMatchRelationByPromoter(matchRelationConfig.getTargetBillTypeKey(), list, cloneList);
                    continue;
                }
                if (!matchRelationConfig.getTargetBillTypeKey().equals(billTypeKey)) continue;
                String srcBillTypeKey = matchRelationConfig.getSrcBillTypeKey();
                String srcBillType = matchRelationConfig.getSrcBillType();
                String tagBillType = matchRelationConfig.getTargetBillType();
                matchRelationConfig.setSrcBillTypeKey(billTypeKey);
                matchRelationConfig.setSrcBillType(tagBillType);
                matchRelationConfig.setTargetBillTypeKey(srcBillTypeKey);
                matchRelationConfig.setTargetBillType(srcBillType);
                List<MatchConditionConfig> matchConditionConfigs = matchRelationConfig.getMatchConditionConfigs();
                for (MatchConditionConfig config : matchConditionConfigs) {
                    config.fieldExchange();
                }
                if (!list.contains(matchRelationConfig)) {
                    list.add(matchRelationConfig);
                }
                cloneList.remove(matchRelationConfig);
                this.sortMatchRelationByPromoter(matchRelationConfig.getTargetBillTypeKey(), list, cloneList);
            }
        }
    }

    private MatchRuleConfig(DynamicObject obj) {
        super(obj);
    }

    public List<MatchRelationConfig> getRelationConfigs() {
        return this.relationConfigs;
    }

    public void setRelationConfigs(List<MatchRelationConfig> relationConfigs) {
        this.relationConfigs = relationConfigs;
    }

    public MatchRelationConfig getRelationByBillType(String billType) {
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return null;
        }
        return this.relationConfigs.stream().filter(n -> billType.equals(n.getSrcBillType()) || billType.equals(n.getTargetBillType())).findFirst().orElse(null);
    }
}

