/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffConfigManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjToWFTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordGroupColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class RecordGroupConfig
extends AbstractObjToWFTypeConfig {
    private List<RecordGroupColumnConfig> recordGroupColumnConfigs = new ArrayList<RecordGroupColumnConfig>(16);

    public static RecordGroupConfig build(DynamicObject obj) {
        RecordGroupConfig config = new RecordGroupConfig(obj);
        config.initColumnField();
        return config;
    }

    private RecordGroupConfig(DynamicObject obj) {
        super(obj);
    }

    private void initColumnField() {
        String[] groupFields;
        String groupField = this.getObj().getString("groupfield");
        DynamicObject wfType = this.getObj().getDynamicObject("wftype");
        DynamicObject record = wfType.getDynamicObject("writeoffrecordbill");
        String number = record.getString("number");
        MainEntityType entryType = EntityMetadataCache.getDataEntityType((String)number);
        for (String field : groupFields = groupField.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)field)) continue;
            IDataEntityProperty property = entryType.findProperty(field);
            RecordGroupColumnConfig columnConfig = new RecordGroupColumnConfig();
            columnConfig.setName(field);
            columnConfig.setRecordFieldName(property.getDisplayName().getLocaleValue());
            this.recordGroupColumnConfigs.add(columnConfig);
        }
    }

    public String getGroupBillType() {
        DynamicObject billType = this.getObj().getDynamicObject("billtype");
        return String.valueOf(billType.getPkValue());
    }

    public void bindRecordSrcFiedConfigs(WriteOffConfigManager wfManager, Long typeConfigId) {
        WriteOffTypeConfig wfTypeConfigById = wfManager.getWfTypeConfigById(typeConfigId);
        WriteOffBillConfig writeOffBillConfig = wfTypeConfigById.getBillConf(this.getGroupBillType());
        RecordMappingConfig configById = wfManager.getMappingConfigById(writeOffBillConfig.getWfMappingId());
        if (configById == null) {
            throw new KDBizException(EngineLang.wfMappingFail(writeOffBillConfig.getWfMappingNumber()));
        }
        for (RecordGroupColumnConfig columnConfig : this.recordGroupColumnConfigs) {
            String srcField;
            String name = columnConfig.getName();
            RecordColumnConfig columnsByTargetCol = configById.getColumnsByTargetCol(name);
            String string = srcField = columnsByTargetCol == null ? null : columnsByTargetCol.getSourceColumn();
            if (srcField != null) {
                columnConfig.setSrcField(srcField);
                continue;
            }
            if ("billid".equals(name) || "assbillid".equals(name)) {
                columnConfig.setSrcField("id");
                continue;
            }
            if ("billentryid".equals(name) || "assbillentryid".equals(name)) {
                String mainFieldEntry = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass().mainFieldEntry();
                columnConfig.setSrcField(mainFieldEntry + ".id");
                continue;
            }
            if ("billtype".equals(name) || "assbilltype".equals(name)) {
                columnConfig.setSrcField("wf$$billType");
                continue;
            }
            if ("billno".equals(name) || "assbillno".equals(name)) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)writeOffBillConfig.getBillType());
                String billNo = ((BillEntityType)dataEntityType).getBillNo();
                columnConfig.setSrcField(billNo);
                continue;
            }
            if (!"qty".equals(name) && !"assqty".equals(name) && !"asscurwfamount".equals(name)) continue;
            columnConfig.setSrcField("wf$$qty");
        }
    }

    public List<RecordGroupColumnConfig> getRecordGroupColumnConfigs() {
        return this.recordGroupColumnConfigs;
    }

    public void setRecordGroupColumnConfigs(List<RecordGroupColumnConfig> recordGroupColumnConfigs) {
        this.recordGroupColumnConfigs = recordGroupColumnConfigs;
    }

    public Long getWfMappingId() {
        DynamicObject writeOffObj = this.getObj().getDynamicObject("wftype");
        return (Long)writeOffObj.getDynamicObject("writeoffrecordbill").getPkValue();
    }

    @Override
    protected String writeOffTypeKey() {
        return "wftype";
    }
}

