/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnConfig;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;

public class RecordMappingConfig
extends AbstractObjMappingConfig {
    private String srcEntity = null;
    private MainEntityType srcEntityType = null;
    private String tgtEntity = null;
    private MainEntityType tgtEntityType = null;
    private WriteoffTemplateTypeEnum tgtRecordTypeEnum = null;
    private Map<String, RecordColumnConfig> columns = new HashMap<String, RecordColumnConfig>(16);
    private static Set<String> filterResultFields = new HashSet<String>();
    private static Set<String> filterMainAssistFields = new HashSet<String>();

    public static RecordMappingConfig build(DynamicObject billFieldMappingObj) {
        RecordMappingConfig config = new RecordMappingConfig(billFieldMappingObj);
        config.initColumns();
        return config;
    }

    private RecordMappingConfig(DynamicObject obj) {
        super(obj);
    }

    private void initColumns() {
        DynamicObject obj = this.getObj();
        DynamicObject srcObj = obj.getDynamicObject("sourcebill");
        this.srcEntity = srcObj.getString("number");
        this.srcEntityType = MetadataServiceHelper.getDataEntityType((String)this.srcEntity);
        DynamicObject tgtObj = obj.getDynamicObject("targetobj");
        this.tgtEntity = tgtObj.getString("number");
        this.tgtEntityType = MetadataServiceHelper.getDataEntityType((String)this.tgtEntity);
        this.tgtRecordTypeEnum = WriteOffRecordHelper.getWfTemplateTypeByChildEntity(this.tgtEntity);
        DynamicObjectCollection colsMapEntries = obj.getDynamicObjectCollection("colsmap");
        for (DynamicObject colsMapEntry : colsMapEntries) {
            String targetCol = colsMapEntry.getString("targetobjcol");
            RecordColumnConfig columnConfig = RecordColumnConfig.build(colsMapEntry);
            columnConfig.setSrcBillType(this.srcEntity);
            columnConfig.setSrcProp((IDataEntityProperty)this.srcEntityType.getAllFields().get(columnConfig.getSimpleSourceColumn()));
            columnConfig.setTgtProp((IDataEntityProperty)this.tgtEntityType.getAllFields().get(columnConfig.getSimpleTargetColumn()));
            this.columns.put(targetCol, columnConfig);
            this.columns.put(columnConfig.getSimpleTargetColumn(), columnConfig);
        }
    }

    public Map<String, RecordColumnConfig> getRecordColumnConfigsMap() {
        return this.columns;
    }

    @Deprecated
    public Map<String, String> getRecordColumnConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (RecordColumnConfig columnEntry : this.columns.values()) {
            map.put(columnEntry.getTargetColumn(), columnEntry.getSourceColumn());
        }
        return map;
    }

    public RecordColumnConfig getColumnsByTargetCol(String tgtCol) {
        return this.columns.get(tgtCol);
    }

    public String getSrcEntity() {
        return this.srcEntity;
    }

    public String getTgtEntity() {
        return this.tgtEntity;
    }

    public WriteoffTemplateTypeEnum getTgtRecordTypeEnum() {
        return this.tgtRecordTypeEnum;
    }

    public List<RecordColumnConfig> getRecordColumnConfigs() {
        ArrayList<RecordColumnConfig> configs = new ArrayList<RecordColumnConfig>(16);
        configs.addAll(this.columns.values());
        return configs;
    }

    public List<RecordColumnConfig> getRecordHeadColumnConfigs() {
        ArrayList<RecordColumnConfig> list = new ArrayList<RecordColumnConfig>(16);
        for (RecordColumnConfig config : this.columns.values()) {
            if (!config.tgtFieldIsHead() || this.getFilterResultFields().contains(config.getSimpleTargetColumn())) continue;
            if (config.getTgtProp() instanceof UnitProp || config.getTgtProp() instanceof CurrencyProp) {
                list.add(0, config);
                continue;
            }
            list.add(config);
        }
        return list;
    }

    public List<RecordColumnConfig> getRecordEntryColumnConfigs() {
        ArrayList<RecordColumnConfig> list = new ArrayList<RecordColumnConfig>(16);
        for (RecordColumnConfig config : this.columns.values()) {
            if (!config.tgtFieldIsEntry() || this.getFilterResultFields().contains(config.getSimpleTargetColumn())) continue;
            if (config.getTgtProp() instanceof UnitProp || config.getTgtProp() instanceof CurrencyProp) {
                list.add(0, config);
                continue;
            }
            list.add(config);
        }
        return list;
    }

    private Set<String> getFilterResultFields() {
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == this.tgtRecordTypeEnum) {
            return filterMainAssistFields;
        }
        return filterResultFields;
    }

    static {
        filterResultFields.add("wfseq");
        filterResultFields.add("wfnumber");
        filterResultFields.add("createtime");
        filterResultFields.add("creator");
        filterResultFields.add("headwfinfo_tag");
        filterResultFields.add("wfinfo_tag");
        filterResultFields.add("billtype");
        filterResultFields.add("billno");
        filterResultFields.add("billid");
        filterResultFields.add("billentryid");
        filterResultFields.add("qty");
        filterMainAssistFields.add("verifyseq");
        filterMainAssistFields.add("createtime");
        filterMainAssistFields.add("creator");
        filterMainAssistFields.add("headwfinfo_tag");
        filterMainAssistFields.add("billtype");
        filterMainAssistFields.add("billno");
        filterMainAssistFields.add("billid");
        filterMainAssistFields.add("billentryid");
        filterMainAssistFields.add("verifybaseqty");
        filterMainAssistFields.add("writeofftypeid");
        filterMainAssistFields.add("e_billtype");
        filterMainAssistFields.add("e_billid");
        filterMainAssistFields.add("e_billentryid");
        filterMainAssistFields.add("e_billno");
        filterMainAssistFields.add("e_verifybaseqty");
        filterMainAssistFields.add("wfinfo_tag");
    }
}

