/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjToWFTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;

public class SchemeConfig
extends AbstractObjToWFTypeConfig {
    private List<BillSortConfig> billSortConfigs = new ArrayList<BillSortConfig>(16);

    public static SchemeConfig build(DynamicObject obj) {
        SchemeConfig config = new SchemeConfig(obj);
        config.initBillSort();
        return config;
    }

    private void initBillSort() {
        DynamicObjectCollection sortEntities = this.getObj().getDynamicObjectCollection("msmod_smsort");
        for (DynamicObject sortEntity : sortEntities) {
            BillSortConfig sortConfig = new BillSortConfig(sortEntity);
            this.billSortConfigs.add(sortConfig);
        }
    }

    private SchemeConfig(DynamicObject obj) {
        super(obj);
    }

    public String getName() {
        return this.getObj().getString("name");
    }

    public boolean isNoCondition() {
        return this.getObj().getBoolean("isunconditionmatch");
    }

    public Long getId() {
        return (Long)this.getObjId();
    }

    public Long getMatchRuleId() {
        DynamicObject matchrule = this.getObj().getDynamicObject("matchrule");
        if (matchrule != null) {
            return (Long)matchrule.getPkValue();
        }
        return null;
    }

    public Long getShareRuleId() {
        DynamicObject matchrule = this.getObj().getDynamicObject("sharerule");
        if (matchrule != null) {
            return (Long)matchrule.getPkValue();
        }
        return null;
    }

    public List<BillSortConfig> getBillSortConfigs() {
        return this.billSortConfigs;
    }

    public List<BillSortConfig> getBillSortConfigsByBillTypeKey(String billTypeKey) {
        ArrayList<BillSortConfig> billSortConfigs = new ArrayList<BillSortConfig>();
        for (BillSortConfig sortConfig : this.getBillSortConfigs()) {
            if (!sortConfig.getSortBillTypeKey().equals(billTypeKey)) continue;
            billSortConfigs.add(sortConfig);
        }
        return billSortConfigs;
    }

    @Override
    protected String writeOffTypeKey() {
        return "writeofftype";
    }
}

