/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractCondtionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeContextFlowConfig;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public class WorkflowBillOperateConfig
extends AbstractCondtionConfig {
    private Set<String> wfOpList = new HashSet<String>(16);
    private List<SchemeContextFlowConfig> schemeContextConfigs = new ArrayList<SchemeContextFlowConfig>(8);

    public static WorkflowBillOperateConfig build(DynamicObject billOperate) {
        WorkflowBillOperateConfig config = new WorkflowBillOperateConfig(billOperate);
        config.initOps();
        config.initSchemeList();
        return config;
    }

    private void initOps() {
        String[] opsArrays;
        for (String opStr : opsArrays = new String[]{this.getObj().getString("writeoffop"), this.getObj().getString("rewriteoffop")}) {
            String[] ops;
            for (String op : ops = opStr.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)op)) continue;
                this.wfOpList.add(op);
            }
        }
    }

    private void initSchemeList() {
        DynamicObjectCollection sortBills = this.getObj().getDynamicObjectCollection("msmod_sch_subentry");
        for (DynamicObject sortBill : sortBills) {
            SchemeContextFlowConfig schemeContextConfig = new SchemeContextFlowConfig(sortBill);
            this.schemeContextConfigs.add(schemeContextConfig);
        }
        this.schemeContextConfigs.sort(Comparator.comparing(SchemeContextConfig::getSort));
    }

    private WorkflowBillOperateConfig(DynamicObject obj) {
        super(obj);
    }

    public String getCondition() {
        return this.getObj().getString("filterconditiondesc_tag");
    }

    public String getCCondition() {
        return this.getObj().getString("cfilterconditiondesc_tag");
    }

    @Override
    public String getBillType() {
        DynamicObject wfBillObj = this.getObj().getDynamicObject("writeoffbill");
        return wfBillObj.getDynamicObject("wfbill").getString("number");
    }

    public String getBillTypeAlias() {
        DynamicObject wfBillObj = this.getObj().getDynamicObject("writeoffbill");
        return CommonHelper.getWfBillKey(wfBillObj);
    }

    public boolean isSync() {
        return this.getObj().getBoolean("issync");
    }

    public Set<String> getWfOpList() {
        return this.wfOpList;
    }

    public List<SchemeContextFlowConfig> getSchemeContextConfigs() {
        return this.schemeContextConfigs;
    }

    @Override
    protected String[] getExpressions() {
        return new String[]{this.getCondition(), this.getCCondition()};
    }
}

