/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjToWFTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackRuleConfig;

public class WriteBackConfig
extends AbstractObjToWFTypeConfig {
    private Map<String, List<WriteBackRuleConfig>> backRuleConfigs = new HashMap<String, List<WriteBackRuleConfig>>(16);

    private WriteBackConfig(DynamicObject obj) {
        super(obj);
    }

    public static WriteBackConfig build(DynamicObject writeBackEntity) {
        WriteBackConfig config = new WriteBackConfig(writeBackEntity);
        config.initWriteBackRuleConfigs();
        return config;
    }

    private void initWriteBackRuleConfigs() {
        DynamicObjectCollection entries = this.getObj().getDynamicObjectCollection("rewritebillentity");
        for (DynamicObject entry : entries) {
            String pluginName = this.getObj().getString("rewriteplugin");
            DynamicObject billAlias = entry.getDynamicObject("alias");
            if (billAlias == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219\u6838\u9500\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteBackConfigManager_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            String srcBillAlias = String.valueOf(billAlias.getPkValue());
            String billType = billAlias.getDynamicObject("wfbill").getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            DynamicObjectCollection reWtFormuls = entry.getDynamicObjectCollection("rewtformulentity");
            ArrayList<WriteBackRuleConfig> WBRConfigs = new ArrayList<WriteBackRuleConfig>(16);
            for (DynamicObject reWtFormul : reWtFormuls) {
                WriteBackRuleConfig writeBackRuleConfig = WriteBackRuleConfig.build(reWtFormul);
                writeBackRuleConfig.setPluginName(pluginName);
                writeBackRuleConfig.setSourceBillType(billType);
                writeBackRuleConfig.setSourceBillAlias(srcBillAlias);
                String[] columnSegments = writeBackRuleConfig.getSourceColumn().split("\\.");
                String field = columnSegments[columnSegments.length - 1];
                IDataEntityProperty property = dataEntityType.findProperty(field);
                if (property == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53:{0}\u5b57\u6bb5:{1}\u4e0d\u5b58\u5728\u3002", (String)"WfManualUtil_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{dataEntityType.getDisplayName() + " ", field}));
                }
                writeBackRuleConfig.setWbBillProperty(property);
                WBRConfigs.add(writeBackRuleConfig);
            }
            this.backRuleConfigs.put(srcBillAlias, WBRConfigs);
        }
    }

    public List<WriteBackRuleConfig> getBackRuleConfigs() {
        ArrayList<WriteBackRuleConfig> backRules = new ArrayList<WriteBackRuleConfig>(16);
        for (List<WriteBackRuleConfig> writeBackRuleConfig : this.backRuleConfigs.values()) {
            backRules.addAll(writeBackRuleConfig);
        }
        return backRules;
    }

    public List<WriteBackRuleConfig> getBackRuleConfigsByAlias(String billAlias) {
        return this.backRuleConfigs.get(billAlias);
    }

    @Override
    protected String writeOffTypeKey() {
        return "writeofftype";
    }
}

