/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffConfigManager;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.param.IWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.AbstractManualReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.FlowWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualAutoWfReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;

public class WriteOffExecuteContext {
    private final IWriteOffReqParam reqParam;
    private WriteOffConfigManager configManager;
    private BillFieldInfoManager billFieldInfoManager = null;
    private WriteOffParamManager wfParamManager = null;
    private PluginFactory pluginFactory = null;
    private BillDataSource billDataSource = null;
    private WriteOffExeucteInfo executeInfo = new WriteOffExeucteInfo();
    private String seq;
    private Map<String, Integer> seqMap = new HashMap<String, Integer>(16);
    private List<WriteOffMatchGroup> matchGroupMap = new ArrayList<WriteOffMatchGroup>(16);
    private List<WriteOffManualGroup> writeOffManualGroups = new ArrayList<WriteOffManualGroup>(16);
    private Map<Long, WriteOffTypeContext> typeContexts = new HashMap<Long, WriteOffTypeContext>(16);
    private Map<Long, WriteOffNLogInfo> logs = new HashMap<Long, WriteOffNLogInfo>(16);
    private Map<String, Object> custParams = new HashMap<String, Object>(16);

    public static WriteOffExecuteContext createFlow(String reqbillEntity, List<Object> billIds, String operationKey) {
        FlowWriteOffReqParam param = new FlowWriteOffReqParam(reqbillEntity, billIds, operationKey);
        WriteOffExecuteContext context = new WriteOffExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public static WriteOffExecuteContext createAuto(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, Map<String, Object> params, Map<String, Map<String, String>> conditionsMap) {
        ManualAutoWfReqParam param = new ManualAutoWfReqParam(wfTypeId, schemaMap, wfDate, params, conditionsMap);
        WriteOffExecuteContext context = new WriteOffExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public static WriteOffExecuteContext createManual(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, List<Map<Object, BigDecimal>> curMainFieldValueMaps, Map<String, Object> params) {
        ManualWriteOffReqParam param = new ManualWriteOffReqParam(wfTypeId, schemaMap, wfDate, curMainFieldValueMaps, params);
        WriteOffExecuteContext context = new WriteOffExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public void addParam(String key, Object value) {
        this.custParams.put(key, value);
    }

    public Object getParam(String key) {
        return this.custParams.get(key);
    }

    public WriteOffExecuteContext(IWriteOffReqParam reqParam) {
        this.reqParam = reqParam;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public boolean isFlowWriteOff() {
        return this.reqParam instanceof FlowWriteOffReqParam;
    }

    public boolean isSingle() {
        return this.reqParam instanceof AbstractManualReqParam && ((AbstractManualReqParam)this.reqParam).getSchemeContextConfig().isSingle();
    }

    public List<WriteOffManualGroup> getWriteOffManualGroups() {
        return this.writeOffManualGroups;
    }

    public void addWriteOffManualGroups(Collection<WriteOffManualGroup> groups) {
        this.writeOffManualGroups.addAll(groups);
    }

    public List<WriteOffMatchGroup> getMatchGroupMap() {
        return this.matchGroupMap;
    }

    public void addWriteOffGroups(Collection<WriteOffMatchGroup> groups) {
        this.matchGroupMap.addAll(groups);
    }

    public IWriteOffReqParam getReqParam() {
        return this.reqParam;
    }

    public WriteOffConfigManager getConfigManager() {
        if (this.configManager == null) {
            this.configManager = new WriteOffConfigManager(this);
        }
        return this.configManager;
    }

    public void setConfigManager(WriteOffConfigManager configManager) {
        this.configManager = configManager;
    }

    public WriteOffExeucteInfo getExecuteInfo() {
        return this.executeInfo;
    }

    public WriteOffNLogInfo getWriteOffLogByTypeId(Long typeId) {
        WriteOffNLogInfo logInfo = this.logs.get(typeId);
        if (logInfo == null) {
            WriteOffTypeConfig typeConfig = this.getConfigManager().getWfTypeConfigById(typeId);
            logInfo = WriteOffNLogInfo.createLog(this.getSeq(), typeConfig);
            if (this.reqParam instanceof FlowWriteOffReqParam) {
                logInfo.getWfLogObj().set("srcbillentity", (Object)((FlowWriteOffReqParam)this.reqParam).getReqbillEntity());
                logInfo.getWfLogObj().set("wfmode", (Object)"F");
                logInfo.getWfLogObj().set("operate", (Object)((FlowWriteOffReqParam)this.reqParam).getOperationKey());
            } else if (this.reqParam instanceof ManualWriteOffReqParam) {
                logInfo.getWfLogObj().set("wfmode", (Object)"M");
            } else if (this.reqParam instanceof ManualAutoWfReqParam) {
                logInfo.getWfLogObj().set("wfmode", (Object)"A");
            }
            this.logs.put(typeId, logInfo);
        }
        return logInfo;
    }

    public List<WriteOffNLogInfo> getLogs() {
        ArrayList<WriteOffNLogInfo> doLogs = new ArrayList<WriteOffNLogInfo>(8);
        Collection<WriteOffNLogInfo> values = this.logs.values();
        for (WriteOffNLogInfo value : values) {
            DynamicObject wfType = value.getWfLogObj().getDynamicObject("wftype");
            WriteOffTypeContext writeOffTypeContext = this.typeContexts.get(wfType.getPkValue());
            if (!writeOffTypeContext.isWriteOff()) continue;
            doLogs.add(value);
        }
        return doLogs;
    }

    public List<WriteOffNLogInfo> getErrorLogs() {
        ArrayList<WriteOffNLogInfo> doLogs = new ArrayList<WriteOffNLogInfo>(8);
        Collection<WriteOffNLogInfo> values = this.logs.values();
        for (WriteOffNLogInfo value : values) {
            doLogs.add(value);
        }
        return doLogs;
    }

    public WriteOffTypeContext getTypeContext(long writeOffTypeId) {
        WriteOffTypeContext typeContext = this.typeContexts.get(writeOffTypeId);
        if (typeContext == null) {
            typeContext = new WriteOffTypeContext(this, this.getConfigManager().getWfTypeConfigById(writeOffTypeId));
            typeContext.setManualWriteOff(!this.isFlowWriteOff());
            this.typeContexts.put(writeOffTypeId, typeContext);
            WriteOffNLogInfo writeOffLog = this.getWriteOffLogByTypeId(writeOffTypeId);
            typeContext.setWriteOffLog(writeOffLog);
        }
        return typeContext;
    }

    public BillFieldInfoManager getBillFieldInfo() {
        if (this.billFieldInfoManager == null) {
            this.billFieldInfoManager = BillFieldInfoManager.create();
        }
        return this.billFieldInfoManager;
    }

    public BillDataSource getBillDataSource() {
        if (this.billDataSource == null) {
            this.billDataSource = new BillDataSource(this.getBillFieldInfo());
        }
        return this.billDataSource;
    }

    public Map<String, Integer> getSeqMap() {
        return this.seqMap;
    }

    public WriteOffParamManager getWfParam() {
        if (this.wfParamManager == null) {
            this.wfParamManager = WriteOffParamManager.create();
        }
        return this.wfParamManager;
    }

    public String getWfMode() {
        if (this.reqParam instanceof FlowWriteOffReqParam) {
            return "1";
        }
        if (this.reqParam instanceof ManualWriteOffReqParam) {
            return "2";
        }
        if (this.reqParam instanceof ManualAutoWfReqParam) {
            return "3";
        }
        return "";
    }

    public PluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = new PluginFactory(this);
        }
        return this.pluginFactory;
    }
}

