/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffStepAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.ActionProcessor;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step.HintQueryBillSetpAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step.UpdateWriteOffNumberSetpAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step.WriteBackBillSetpAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step.WriteOffCoreSetpAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.AbstractWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public abstract class AbstractBillWfExecuteAction
extends AbstractWriteOffAction {
    private static final Log logger = LogFactory.getLog(AbstractBillWfExecuteAction.class);

    @Override
    protected void doAction() {
        Map<Long, List<WriteOffMatchGroup>> typeToScheme = this.getTypeToScheme();
        List<Long> writeOffType = this.sortWriteOffType(typeToScheme.keySet());
        this.doGoupeWriteOff(typeToScheme, writeOffType);
        Boolean param = (Boolean)((WriteOffExecuteContext)this.getExecuteContext()).getParam("isWriteLog");
        if (param != null && param.booleanValue()) {
            return;
        }
        List<WriteOffNLogInfo> logs = ((WriteOffExecuteContext)this.getExecuteContext()).getLogs();
        WriteOffLogHelper.saveLogs(logs);
        try {
            for (WriteOffNLogInfo log : logs) {
                WriteOffPluginProxy pluginProxy = ((WriteOffExecuteContext)this.getExecuteContext()).getPluginFactory().createWriteOffPluginProxy(log.getTypeConfig());
                pluginProxy.viewWfLog(Collections.singletonList(log.getWfLogObj()));
            }
        }
        catch (Exception e) {
            logger.error("\u6838\u9500\u65e5\u5fd7\u6269\u5c55\u63d2\u6267\u884c\u62a5\u9519" + e.getMessage());
        }
    }

    private Map<Long, List<WriteOffMatchGroup>> getTypeToScheme() {
        List<WriteOffMatchGroup> groupMap = ((WriteOffExecuteContext)this.getExecuteContext()).getMatchGroupMap();
        HashMap<Long, List<WriteOffMatchGroup>> tsMatchGroup = new HashMap<Long, List<WriteOffMatchGroup>>(16);
        for (WriteOffMatchGroup group : groupMap) {
            Long typeId = group.getTypeConfig().getId();
            MapUtils.mapGetListValue(tsMatchGroup, typeId).add(group);
        }
        return tsMatchGroup;
    }

    private List<Long> sortWriteOffType(Collection<Long> wfTypeIds) {
        ArrayList<Long> sortWfTypeIds = new ArrayList<Long>(wfTypeIds);
        if (wfTypeIds.size() <= 1) {
            return sortWfTypeIds;
        }
        sortWfTypeIds.sort(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                WriteOffTypeConfig wfType1 = AbstractBillWfExecuteAction.this.getConfigManager().getWfTypeConfigById(o1);
                WriteOffTypeConfig wfType2 = AbstractBillWfExecuteAction.this.getConfigManager().getWfTypeConfigById(o2);
                return wfType1.getPriority().compareTo(wfType2.getPriority());
            }
        });
        return sortWfTypeIds;
    }

    private void doGoupeWriteOff(Map<Long, List<WriteOffMatchGroup>> typeToScheme, List<Long> writeOffType) {
        for (Long wfTypeId : writeOffType) {
            WriteOffTypeContext typeContext = ((WriteOffExecuteContext)this.getExecuteContext()).getTypeContext(wfTypeId);
            List<WriteOffMatchGroup> groups = typeToScheme.get(wfTypeId);
            typeContext.setMatchGroup(groups);
            for (WriteOffMatchGroup group : groups) {
                List<WriteOffObject> writeOffObjects = group.getWriteOffObjects();
                for (WriteOffObject writeOffObject : writeOffObjects) {
                    WriteOffNLogInfo writeOffLog = typeContext.getWriteOffLog();
                    WriteOffObjectBase writeOffObjectBase = writeOffObject.getWriteOffObjectBase();
                    writeOffLog.addSrcBillInfo(typeContext.getBillTypeKey(), writeOffObjectBase.getWfBillBillNo(), writeOffObjectBase.getWfBillPk());
                }
            }
            List<AbstractWriteOffStepAction> actions = this.getSetpActions();
            log.info("\u6838\u9500\u5e73\u53f0\u6267\u884c\u6838\u9500\u2014\u2014\u6838\u9500\u7c7b\u522b\uff1a\u3010" + typeContext.getTypeConfig().getName() + "\u3011\u5f00\u59cb");
            new ActionProcessor<WriteOffTypeContext>(actions).doProcess(typeContext);
            typeContext.getHintDataLoader().clearCachedData();
            log.info("\u6838\u9500\u5e73\u53f0\u6267\u884c\u6838\u9500\u2014\u2014\u6838\u9500\u7c7b\u522b\uff1a\u3010" + typeContext.getTypeConfig().getName() + "\u3011\u7ed3\u675f");
        }
    }

    private List<AbstractWriteOffStepAction> getSetpActions() {
        ArrayList<AbstractWriteOffStepAction> actions = new ArrayList<AbstractWriteOffStepAction>();
        actions.add(new UpdateWriteOffNumberSetpAction());
        actions.add(new HintQueryBillSetpAction());
        actions.add(new WriteOffCoreSetpAction(this.getWfGroupExecutor()));
        actions.add(new WriteBackBillSetpAction());
        return actions;
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        List<WriteOffNLogInfo> logs = ((WriteOffExecuteContext)this.getExecuteContext()).getErrorLogs();
        WriteOffLogHelper.saveLogsWithExeption(logs, e);
    }

    protected abstract AbstractWfGroupExecutor getWfGroupExecutor();
}

