/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.service.AutoVerifyParamService;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeContextFlowConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowBillOperateConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowSchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractBillGroupAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffBillGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.FlowWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeObjConst;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import org.apache.commons.collections.CollectionUtils;

public class FlowBillGroupAction
extends AbstractBillGroupAction {
    public static final Set<Long> allWFPlanTypeIdSet = new HashSet<Long>(16);
    private Map<Long, String> orgAndValueMap;
    private Map<String, DynamicObjectCollection> cacheQueryInfo = new HashMap<String, DynamicObjectCollection>(16);

    @Override
    protected List<WriteOffMatchGroup> getBillGroup() {
        WriteOffExecuteContext executeContext = (WriteOffExecuteContext)this.getExecuteContext();
        FlowWriteOffReqParam reqParam = (FlowWriteOffReqParam)executeContext.getReqParam();
        String reqbillEntity = reqParam.getReqbillEntity();
        ArrayList<WriteOffMatchGroup> groups = new ArrayList<WriteOffMatchGroup>(16);
        List<WriteOffTypeConfig> typeConfigs = this.getConfigManager().getAllWriteOffTypeConfigs();
        for (WriteOffTypeConfig typeConfig : typeConfigs) {
            log.info("\u8bfb\u53d6\u7c7b\u522b" + typeConfig.getName() + "\u5206\u7ec4\u914d\u7f6e");
            ArrayList<WriteOffBillConfig> bills = new ArrayList<WriteOffBillConfig>(8);
            for (WriteOffBillConfig billConfigs : typeConfig.getBillConfigs()) {
                if (!billConfigs.getBillType().equals(reqbillEntity) || !billConfigs.isNeedWriteOff()) continue;
                bills.add(billConfigs);
            }
            if (CollectionUtils.isEmpty(bills)) {
                log.info("\u7c7b\u522b" + typeConfig.getName() + "\u53c2\u4e0e\u6838\u9500\u7684\u5355\u636e\u4e0d\u5339\u914d\u3002");
                continue;
            }
            List<WriteOffMatchGroup> billGroup = this.doWriteOff(typeConfig, bills, reqParam);
            groups.addAll(billGroup);
        }
        return groups;
    }

    private List<WriteOffMatchGroup> doWriteOff(WriteOffTypeConfig typeConfig, List<WriteOffBillConfig> bills, FlowWriteOffReqParam reqParam) {
        DynamicObject[] wfDataEntities;
        DynamicObjectCollection datas;
        long org;
        String mainFieldEntry = bills.get(0).getMainFieldEntry();
        DynamicObjectCollection dataEntities = this.queryDataEntity(reqParam, mainFieldEntry);
        if (CollectionUtils.isEmpty((Collection)dataEntities)) {
            throw new KDBizException(EngineLang.reqBillNotExist(reqParam.getReqbillIds()));
        }
        Long wfTypeId = typeConfig.getId();
        if (allWFPlanTypeIdSet.contains(wfTypeId) && !this.isWriteOffPlan(org = ((DynamicObject)dataEntities.get(0)).getLong("org"))) {
            log.info("\u6838\u9500\u5e73\u53f0\uff1a\u5f53\u524d\u7ec4\u7ec7\u65e0\u6cd5\u8fdb\u884c\u6838\u9500\u3002");
            return Collections.emptyList();
        }
        WriteOffPluginProxy writeOffPluginProxy = ((WriteOffExecuteContext)this.getExecuteContext()).getPluginFactory().createWriteOffPluginProxy(typeConfig);
        List<QFilter> billObjFilter = writeOffPluginProxy.extendFlowBillObjFilter(reqParam.getReqbillEntity(), dataEntities);
        if (billObjFilter != null && !billObjFilter.isEmpty() && (datas = ((WriteOffExecuteContext)this.getExecuteContext()).getBillDataSource().queryBillData(reqParam.getReqbillEntity(), mainFieldEntry, billObjFilter.toArray(new QFilter[billObjFilter.size()]))) != null && !datas.isEmpty()) {
            dataEntities.addAll((Collection)datas);
        }
        if ((wfDataEntities = this.purinBillIsWriteOff((List<DynamicObject>)dataEntities, wfTypeId)) == null || wfDataEntities.length == 0) {
            return Collections.emptyList();
        }
        List<WriteOffBillGroup> writeOffBillTypeGroups = this.groupBillByWriteOffType(typeConfig, wfDataEntities, reqParam.getReqbillEntity());
        if (CollectionUtils.isEmpty(writeOffBillTypeGroups)) {
            return Collections.emptyList();
        }
        return this.splitGroup(typeConfig, reqParam, writeOffBillTypeGroups, false);
    }

    private DynamicObjectCollection queryDataEntity(FlowWriteOffReqParam reqParam, String mainFieldEntry) {
        String reqbillEntity = reqParam.getReqbillEntity();
        String key = reqbillEntity + "-" + mainFieldEntry;
        DynamicObjectCollection dataEntities = this.cacheQueryInfo.get(key);
        if (dataEntities == null) {
            QFilter queryFilter = new QFilter("id", "in", reqParam.getReqbillIds());
            dataEntities = ((WriteOffExecuteContext)this.getExecuteContext()).getBillDataSource().queryBillData(reqbillEntity, mainFieldEntry, queryFilter);
            this.cacheQueryInfo.put(key, dataEntities);
        }
        DynamicObjectCollection newDataEntities = new DynamicObjectCollection();
        newDataEntities.addAll((Collection)dataEntities);
        return newDataEntities;
    }

    private DynamicObject[] purinBillIsWriteOff(List<DynamicObject> dataEntities, Long wfTypeId) {
        if (!WriteOffTypeObjConst.WFTYPE_PURIN_REDBACK.equals(wfTypeId)) {
            return dataEntities.toArray(new DynamicObject[dataEntities.size()]);
        }
        AutoVerifyParamService autoVerifyParam = new AutoVerifyParamService();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < dataEntities.size(); ++i) {
            DynamicObject curBill = dataEntities.get(i);
            if (!autoVerifyParam.getAutoVerifyOrRedBill(curBill)) continue;
            list.add(curBill);
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    private List<WriteOffMatchGroup> splitGroup(WriteOffTypeConfig typeConfig, FlowWriteOffReqParam reqParam, List<WriteOffBillGroup> writeOffBillTypeGroups, boolean isShareAssist) {
        ArrayList<WriteOffMatchGroup> groups = new ArrayList<WriteOffMatchGroup>(16);
        WorkflowSchemeConfig workFlowShemeConfig = this.getConfigManager().getWorkflowSchemeByWriteOffTypeId(typeConfig.getId());
        for (WriteOffBillGroup writeOffBillTypeGroup : writeOffBillTypeGroups) {
            WriteOffBillConfig billTypeConfig = writeOffBillTypeGroup.getBillTypeConfig();
            List<WorkflowBillOperateConfig> operateConfigs = workFlowShemeConfig.getBillOperateConfigByOper(billTypeConfig.getBillAlias(), reqParam.getOperationKey());
            if (operateConfigs == null || operateConfigs.isEmpty()) {
                log.info("\u6838\u9500\u5e73\u53f0\u83b7\u53d6\u5355\u636e\u5206\u7ec4\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u6d41\u7a0b\u6838\u9500\u5355\u636e\u914d\u7f6e\u3002" + billTypeConfig.getBillAlias());
                continue;
            }
            List<WriteOffObject> typeWriteOffObjs = writeOffBillTypeGroup.getWriteOffObjects();
            for (WorkflowBillOperateConfig wfFlowConfig : operateConfigs) {
                if (typeWriteOffObjs.isEmpty()) {
                    ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, EngineLang.notFlowSchemeObjs(workFlowShemeConfig));
                    continue;
                }
                List<WriteOffObject> matchedObj = WriteOffGroupHelper.getMatchedObjAndRemove(wfFlowConfig, typeWriteOffObjs);
                if (matchedObj.isEmpty()) {
                    ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, EngineLang.notMatchFlowSchemeFilter(workFlowShemeConfig));
                    continue;
                }
                List<SchemeContextFlowConfig> schemeContextConfigs = wfFlowConfig.getSchemeContextConfigs();
                for (SchemeContextConfig schemeContextConfig : schemeContextConfigs) {
                    SchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(schemeContextConfig.getSchemeId(), typeConfig.getId());
                    if (schemeConfig.isNoCondition()) {
                        ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.notAllowExecuteNoCondition(schemeConfig));
                        continue;
                    }
                    MatchRuleConfig matchRuleConfig = this.getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeConfig.getId());
                    if (matchRuleConfig == null) {
                        ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.matchRuleNotEnable(schemeConfig));
                        continue;
                    }
                    List<WriteOffMatchGroup> writeOffMatchGroups = WriteOffGroupHelper.groupByMatchRule(typeConfig, billTypeConfig, schemeContextConfig, schemeConfig, matchRuleConfig, matchedObj, ((WriteOffExecuteContext)this.getExecuteContext()).getPluginFactory());
                    for (WriteOffMatchGroup writeOffMatchGroup : writeOffMatchGroups) {
                        writeOffMatchGroup.setWfFlowConfig(wfFlowConfig);
                    }
                    groups.addAll(writeOffMatchGroups);
                }
            }
        }
        return groups;
    }

    private List<WriteOffBillGroup> groupBillByWriteOffType(WriteOffTypeConfig typeConfig, DynamicObject[] dataEntities, String billEntity) {
        HashSet<Object> groupedObjIds = new HashSet<Object>(16);
        ArrayList<WriteOffBillGroup> writeOffBillGroups = new ArrayList<WriteOffBillGroup>();
        List<WriteOffBillConfig> billConfigs = typeConfig.getBillConfigs();
        for (WriteOffBillConfig billConfig : billConfigs) {
            if (billConfig.isNeedGenerate()) {
                log.info("\u6838\u9500\u5e73\u53f0\uff1a\u81ea\u52a8\u751f\u6210\u5355\u636e\u4e0d\u80fd\u4f5c\u4e3a\u4e3b\u65b9\u8fdb\u884c\u6838\u9500\u2014\u2014" + typeConfig.getName());
                continue;
            }
            if (!billEntity.equals(billConfig.getBillType())) continue;
            ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>();
            for (DynamicObject dataEntity : dataEntities) {
                List<WriteOffObject> loadObjects = WriteOffGroupHelper.buildWriteOffObjects(typeConfig, billConfig, dataEntity);
                for (WriteOffObject writeOffObject : loadObjects) {
                    WriteOffExeucteInfo executeInfo;
                    if (groupedObjIds.contains(writeOffObject.getWriteOffObjectPk())) continue;
                    if (writeOffObject.isCurWriteOffZero() || writeOffObject.isWfComplete()) {
                        executeInfo = ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo();
                        executeInfo.addInfo(dataEntity.get("id"), typeConfig.getId(), writeOffObject.getWriteOffObjectPk(), 0L, EngineLang.curWriteOffIsZero(typeConfig, billConfig));
                        continue;
                    }
                    if (!this.checkCondtionWithOutStatus(billConfig, writeOffObject) || !billConfig.checkHighCondtion(writeOffObject)) {
                        executeInfo = ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo();
                        executeInfo.addInfo(dataEntity.get("id"), typeConfig.getId(), writeOffObject.getWriteOffObjectPk(), 0L, EngineLang.writeOffTypeNotFilter(typeConfig, billConfig));
                        continue;
                    }
                    writeOffObjects.add(writeOffObject);
                    groupedObjIds.add(writeOffObject.getWriteOffObjectPk());
                }
            }
            if (!CollectionUtils.isNotEmpty(writeOffObjects)) continue;
            WriteOffBillGroup writeOffGroup = new WriteOffBillGroup(typeConfig, billConfig);
            writeOffGroup.addWriteOffObjects(writeOffObjects);
            writeOffBillGroups.add(writeOffGroup);
        }
        return writeOffBillGroups;
    }

    private boolean checkCondtionWithOutStatus(WriteOffBillConfig billConfig, WriteOffObject writeOffObject) {
        String operationKey;
        Map<String, Object> map = billConfig.getCondtionValueMap(writeOffObject);
        switch (operationKey = ((FlowWriteOffReqParam)((WriteOffExecuteContext)this.getExecuteContext()).getReqParam()).getOperationKey()) {
            case "submit": {
                map.put("billstatus", "B");
                break;
            }
            case "audit": {
                map.put("billstatus", "C");
                break;
            }
            case "unsubmit": {
                map.put("billstatus", "A");
                break;
            }
            case "unaudit": {
                map.put("billstatus", "A");
                break;
            }
        }
        return billConfig.checCondtionByParamMap(map);
    }

    public boolean isWriteOffPlan(Long orgId) {
        String value;
        if (this.orgAndValueMap == null) {
            this.orgAndValueMap = new HashMap<Long, String>(16);
            DBRoute route = new DBRoute("scm");
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select forgid,fkey,fvalue from t_im_invdbparam where fkey = 'iswriteoffplan'", new Object[0]);
            DataSet paramSet = DB.queryDataSet((String)"WriteOffServerHelper", (DBRoute)route, (SqlBuilder)sqlBuilder);
            for (Row param : paramSet) {
                this.orgAndValueMap.put(param.getLong("forgid"), param.getString("fvalue"));
            }
        }
        if ((value = this.orgAndValueMap.get(0L)) != null && "1".equals(value)) {
            return true;
        }
        value = this.orgAndValueMap.get(orgId);
        return value != null && "1".equals(value);
    }

    static {
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_PURIN);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_PURIN_REDBACK);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_PURRECIVE_REDBACK);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_AP_REDBACK);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_PURRECIVE);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_SALOUT);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_SALOUT_REDBACK);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_REVCFM_REDBACK);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_OMCMPLIN);
        allWFPlanTypeIdSet.add(WriteOffTypeObjConst.WFTYPE_OMCMPLIN_REDVACK);
    }
}

