/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowBillOperateConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowSchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractLoadConfigParamAction;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.FlowWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public class FlowWriteOffLoadAction
extends AbstractLoadConfigParamAction<FlowWriteOffReqParam> {
    @Override
    protected void loadConfig() {
        String reqBillEntity;
        String operationKey = ((FlowWriteOffReqParam)this.getReqParam()).getOperationKey();
        List<DynamicObject> schemeSetObjList = this.getSchemeSetList(operationKey, reqBillEntity = ((FlowWriteOffReqParam)this.getReqParam()).getReqbillEntity());
        if (schemeSetObjList.isEmpty()) {
            ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(((FlowWriteOffReqParam)this.getReqParam()).getReqbillIds(), EngineLang.noMatchedWriteOffScheme());
            return;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashSet<Long> writeOffTypeIds = new HashSet<Long>(16);
        for (DynamicObject schemeSets : schemeSetObjList) {
            WorkflowSchemeConfig workFlowConfigs = WorkflowSchemeConfig.build(schemeSets, ((FlowWriteOffReqParam)this.getReqParam()).getOperationKey(), ((FlowWriteOffReqParam)this.getReqParam()).getReqbillEntity());
            this.getConfigManager().addWorkflowSchemeConfig(workFlowConfigs);
            writeOffTypeIds.add(workFlowConfigs.getWriteOffTypeId());
            for (WorkflowBillOperateConfig wfBillOperConfig : workFlowConfigs.getOperateConfigs()) {
                for (SchemeContextConfig schemeContextConfig : wfBillOperConfig.getSchemeContextConfigs()) {
                    schemeIds.add(schemeContextConfig.getSchemeId());
                }
            }
        }
        QFilter schemeFilter = new QFilter("id", "in", schemeIds).and("enable", "=", (Object)Boolean.TRUE);
        Map schemeEntities = BusinessDataServiceHelper.loadFromCache((String)"msmod_scheme", (QFilter[])schemeFilter.toArray());
        for (DynamicObject schemeEntity : schemeEntities.values()) {
            SchemeConfig schemeConfig = SchemeConfig.build(schemeEntity);
            this.getConfigManager().addSchemeContextConfig(schemeConfig);
        }
        if (schemeEntities.isEmpty()) {
            ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(((FlowWriteOffReqParam)this.getReqParam()).getReqbillIds(), EngineLang.writeOffSchemeNoEnable());
        }
        QFilter typeFilter = new QFilter("id", "in", writeOffTypeIds).and("enable", "=", (Object)Boolean.TRUE).and("writeofftype", "=", (Object)"A");
        Map writeOffObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])typeFilter.toArray());
        Map<Long, Integer> wfTypeSortMap = this.getWfTypeSortMap();
        HashSet<Long> recordMappingIds = new HashSet<Long>(16);
        for (DynamicObject writeOffObj : writeOffObjs.values()) {
            Long wrtieOffId = DynamicObjectUtil.getPkValue(writeOffObj);
            WriteOffTypeConfig wftypeConfig = WriteOffTypeConfig.build(writeOffObj);
            recordMappingIds.addAll(wftypeConfig.getRecordMappingIdByWfType());
            wftypeConfig.setPriority(wfTypeSortMap.get(wrtieOffId));
            this.getConfigManager().addWriteOffTypeConfig(wftypeConfig);
        }
        QFilter qFilter = new QFilter("id", "in", recordMappingIds);
        Map allRecordMappingObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])qFilter.toArray());
        for (DynamicObject mapping : allRecordMappingObjs.values()) {
            RecordMappingConfig rmConfig = RecordMappingConfig.build(mapping);
            this.getConfigManager().addRecordMappingConfig(rmConfig);
        }
        if (writeOffObjs.isEmpty()) {
            ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(((FlowWriteOffReqParam)this.getReqParam()).getReqbillIds(), EngineLang.writeOffTypeNoEnable());
        }
    }

    private List<DynamicObject> getSchemeSetList(String operationKey, String reqbillEntity) {
        QFilter billFilter = new QFilter("msmod_scheme_bill.writeoffbill.wfbill", "=", (Object)reqbillEntity).and("enable", "=", (Object)Boolean.TRUE).and("writeofftype.writeofftype", "=", (Object)"A");
        Map schemeSetObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_schemeset", (QFilter[])billFilter.toArray());
        ArrayList<DynamicObject> schemeSetObjList = new ArrayList<DynamicObject>(8);
        block0: for (DynamicObject schemeObj : schemeSetObjs.values()) {
            DynamicObjectCollection schemeBills = schemeObj.getDynamicObjectCollection("msmod_scheme_bill");
            for (DynamicObject schemeBill : schemeBills) {
                String op = schemeBill.getString("writeoffop");
                DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
                String billEntity = writeOffBill.getDynamicObject("wfbill").getString("number");
                String[] ops = op.split(",");
                HashSet<String> opSet = new HashSet<String>(Arrays.asList(ops));
                if (!reqbillEntity.equals(billEntity) || !opSet.contains(operationKey)) continue;
                schemeSetObjList.add(schemeObj);
                continue block0;
            }
        }
        return schemeSetObjList;
    }

    private Map<Long, Integer> getWfTypeSortMap() {
        FlowWriteOffReqParam param = (FlowWriteOffReqParam)this.getReqParam();
        HashMap<Long, Integer> wfTypeSortMap = new HashMap<Long, Integer>(16);
        QFilter qFilter = new QFilter("writeoffop", "=", (Object)param.getOperationKey());
        qFilter.and("writeoffbill", "=", (Object)param.getReqbillEntity());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"msmod_writeofftype_sort", (String)"entryentity.writeofftype,entryentity.seq", (QFilter[])qFilter.toArray());
        for (DynamicObject ob : query) {
            wfTypeSortMap.put(ob.getLong("entryentity.writeofftype"), ob.getInt("entryentity.seq"));
        }
        return wfTypeSortMap;
    }
}

