/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffAction;

public class LoadMatchRuleAction
extends AbstractWriteOffAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || this.getConfigManager().getAllSchemeConfigs().isEmpty();
    }

    @Override
    protected void doAction() {
        List<SchemeConfig> schemeConfigMap = this.getConfigManager().getAllSchemeConfigs();
        HashSet<Long> ruleIds = new HashSet<Long>(16);
        for (SchemeConfig schemeConfig : schemeConfigMap) {
            DynamicObject matchRule = schemeConfig.getObj().getDynamicObject("matchrule");
            if (matchRule == null) continue;
            ruleIds.add(matchRule.getLong("id"));
        }
        if (ruleIds.isEmpty()) {
            return;
        }
        QFilter matchRuleFilter = new QFilter("id", "in", ruleIds).and("enable", "=", (Object)Boolean.TRUE);
        Map matchRuleEntities = BusinessDataServiceHelper.loadFromCache((String)"msmod_matchrule", (QFilter[])matchRuleFilter.toArray());
        for (DynamicObject matchRuleEntity : matchRuleEntities.values()) {
            MatchRuleConfig matchRuleConfig = MatchRuleConfig.build(matchRuleEntity);
            this.getConfigManager().addMatchRuleConfig(matchRuleConfig);
        }
    }
}

