/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeContextManualConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractManualBillGroupAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffAutoManualEntiy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualAutoWfReqParam;

public class ManualAutoBillGroupAction
extends AbstractManualBillGroupAction {
    @Override
    protected List<WriteOffManualGroup> getManuBillGroup() {
        WriteOffExecuteContext executeContext = (WriteOffExecuteContext)this.getExecuteContext();
        Integer maxHandleBillSize = ((WriteOffExecuteContext)this.getExecuteContext()).getWfParam().getMaxHandleBillSize();
        ManualAutoWfReqParam reqParam = (ManualAutoWfReqParam)executeContext.getReqParam();
        WriteOffTypeConfig writeOffTypeConfig = this.getConfigManager().getWfTypeConfigById(reqParam.getWfTypeId());
        SchemeContextManualConfig schemeContextConfig = reqParam.getSchemeContextConfig();
        List<WriteOffAutoManualEntiy> autoManualEntitys = this.buildAutoManualEntity(reqParam, writeOffTypeConfig);
        ArrayList<WriteOffManualGroup> writeOffManualGroups = new ArrayList<WriteOffManualGroup>(autoManualEntitys.size());
        int i = 0;
        for (WriteOffAutoManualEntiy wfAutoManualEntity : autoManualEntitys) {
            WriteOffBillConfig writeOffBillConfig = wfAutoManualEntity.getBillConfig();
            List<IWFFilter> billFilter = wfAutoManualEntity.getQFilter();
            long schemeId = schemeContextConfig.getSchemeId();
            SchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(schemeId, writeOffTypeConfig.getId());
            WriteOffManualGroup writeOffManualGroup = WriteOffManualGroup.build(writeOffTypeConfig, writeOffBillConfig, schemeConfig, executeContext.getBillDataSource());
            writeOffManualGroup.setFilter(billFilter, maxHandleBillSize);
            if (i == 0) {
                writeOffManualGroup.initWriteOffObject(schemeContextConfig.isSingle());
            }
            writeOffManualGroups.add(writeOffManualGroup);
            ++i;
        }
        return writeOffManualGroups;
    }

    private List<WriteOffAutoManualEntiy> buildAutoManualEntity(ManualAutoWfReqParam reqParam, WriteOffTypeConfig writeOffTypeConfig) {
        Map<String, Map<String, String>> conditionsMap = reqParam.getConditionsMap();
        ArrayList<WriteOffAutoManualEntiy> autoManualList = new ArrayList<WriteOffAutoManualEntiy>(16);
        for (WriteOffBillConfig billConfig : writeOffTypeConfig.getNoAutoBillConfigs()) {
            Map<String, String> conditionMap = conditionsMap.get(String.valueOf(billConfig.getObjId()));
            autoManualList.add(new WriteOffAutoManualEntiy(billConfig, conditionMap));
        }
        return autoManualList;
    }
}

