/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffStepAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.kdtx.KdtxWriteOffService;
import kd.mpscmm.mscommon.writeoff.business.engine.core.listener.WfRollbackListener;
import kd.mpscmm.mscommon.writeoff.business.engine.core.listener.WfSnapListener;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WFRecordManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.AbstractManualReqParam;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;

public class WriteBackBillSetpAction
extends AbstractWriteOffStepAction {
    @Override
    protected boolean isSkipAction() {
        return !((WriteOffTypeContext)this.getExecuteContext()).isWriteOff();
    }

    @Override
    protected void doAction() {
        WriteOffTypeContext writeOffTypeContext = (WriteOffTypeContext)this.getExecuteContext();
        WFRecordManager recordManager = writeOffTypeContext.getRecordManager();
        if (recordManager.isEmpty()) {
            if (writeOffTypeContext.isManualWriteOff()) {
                this.manualHandleNoneRecord();
            } else {
                WriteOffNLogInfo logInfo = this.getWFExecuteContext().getWriteOffLogByTypeId(((WriteOffTypeContext)this.getExecuteContext()).getTypeConfig().getId());
                logInfo.setErrorType("B");
            }
            return;
        }
        WFSnapshotContext snapshotContext = writeOffTypeContext.getSnapshotContext();
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)new WfSnapListener(snapshotContext));
        }
        snapshotContext.saveWfSnapShoot();
        List<Object> checkResults = Collections.emptyList();
        try (AlgoContext context = Algo.newContext();){
            checkResults = snapshotContext.checkPass();
        }
        if (checkResults.isEmpty()) {
            var6_7 = null;
            try (TraceSpan trace = Tracer.create((String)"WriteOff-callKDTXService", (String)"callKDTXService");){
                this.callKDTXService();
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        } else {
            WriteOffNLogInfo logInfo = this.getWFExecuteContext().getWriteOffLogByTypeId(((WriteOffTypeContext)this.getExecuteContext()).getTypeConfig().getId());
            logInfo.setErrorType("C");
            snapshotContext.deleteSnapShoots();
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u53cd\u5199\u8d85\u989d\u6821\u9a8c\u5931\u8d25\u3002{0}", (String)"WfSnapShootHolder_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{checkResults.toString()}));
        }
    }

    private void callKDTXService() {
        WriteOffTypeContext writeOffTypeContext = (WriteOffTypeContext)this.getExecuteContext();
        WriteOffExecuteContext wfExecuteContext = this.getWFExecuteContext();
        WFRecordManager recordManager = writeOffTypeContext.getRecordManager();
        List<DynamicObject> writeoffRecords = recordManager.getRecordObjs();
        boolean isManualWriteOff = writeOffTypeContext.isManualWriteOff();
        WFSnapshotContext snapshotContext = writeOffTypeContext.getSnapshotContext();
        WriteOffTypeConfig typeConfig = writeOffTypeContext.getTypeConfig();
        recordManager.updateRecordsRelation(typeConfig, wfExecuteContext.getSeqMap());
        HashMap<String, List<Object>> billSaveSuccess = new HashMap<String, List<Object>>(16);
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)new WfRollbackListener(billSaveSuccess));
            TX.addCommitListener((CommitListener)new WfRollbackListener(writeoffRecords));
        }
        HashSet<String> businessInfos = new HashSet<String>(16);
        for (DynamicObject wfRecord : writeoffRecords) {
            Set<String> buildBusinessKeys = CommonUtils.buildBusinessKeys(wfRecord, typeConfig);
            businessInfos.addAll(buildBusinessKeys);
        }
        KdtxWriteOffService service = new KdtxWriteOffService(businessInfos, typeConfig, isManualWriteOff, billSaveSuccess, wfExecuteContext);
        service.setWriteOffLog(writeOffTypeContext.getWriteOffLog());
        service.kdtxWriteOffRecord(typeConfig, writeoffRecords);
        HashMap<String, Map<String, List<Object[]>>> writeBackSQLs = new HashMap<String, Map<String, List<Object[]>>>(16);
        MapUtils.add(writeBackSQLs, recordManager.getGenerateWriteBackSql());
        WriteOffPluginProxy writeOffPluginProxy = ((WriteOffTypeContext)this.getExecuteContext()).getPluginFactory().createWriteOffPluginProxy(typeConfig);
        MapUtils.add(writeBackSQLs, writeOffPluginProxy.buildBackSql(recordManager.getRecordObjs()));
        HashMap<Long, List<DynamicObject>> writeoffRecordMap = new HashMap<Long, List<DynamicObject>>(4);
        writeoffRecordMap.put(typeConfig.getId(), writeoffRecords);
        service.kdtxBackWriteBill(writeBackSQLs, snapshotContext.getSnapShootIdMap(), writeoffRecordMap);
        List<Map<String, Object>> recordKdtxParams = recordManager.getRecordKdtxParams(isManualWriteOff);
        service.kdtxWfPlugin(writeoffRecords, recordKdtxParams);
        Map<String, List<DynamicObject>> mergedAutoBill = writeOffTypeContext.getAutoBillContext().mergeAutoBill();
        service.autoGenerateBillService(mergedAutoBill);
    }

    private void manualHandleNoneRecord() {
        WriteOffTypeContext writeOffTypeContext = (WriteOffTypeContext)this.getExecuteContext();
        WriteOffExecuteContext wfExecuteContext = this.getWFExecuteContext();
        AbstractManualReqParam reqParam = (AbstractManualReqParam)wfExecuteContext.getReqParam();
        if (!writeOffTypeContext.isMatch()) {
            SchemeConfig schemeConfigById = wfExecuteContext.getConfigManager().getSchemeConfigById(reqParam.getSchemeContextConfig().getSchemeId(), writeOffTypeContext.getTypeConfig().getId());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u9500\u65b9\u6848\u201c%s\u201d\u4e0b\u65e0\u5339\u914d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6838\u9500\u65b9\u6848\u6216\u91cd\u65b0\u9009\u62e9\u6570\u636e\u6838\u9500\u3002", (String)"ManualWfGroupExecutor_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), schemeConfigById.getName()));
        }
        if (reqParam.getSchemeContextConfig().isOnlyEquals()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf/\u91d1\u989d\u76f8\u7b49\u4e3a\u662f\uff0c\u4e3b\u65b9\u5355\u636e\u5206\u5f55\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u548c\u8f85\u65b9\u5355\u636e\u5206\u5f55\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u5fc5\u987b\u76f8\u7b49\u624d\u80fd\u6838\u9500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u6838\u9500\u3002", (String)"WriteOffBillDispatcher_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6838\u9500\u8bb0\u5f55\u4ea7\u751f\u3002", (String)"WfSnapShootHolder_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
    }
}

