/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractCondtionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.HintData;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.WriteOffStrategyExecutor;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public abstract class AbstractWfGroupExecutor {
    private static final Log logger = LogFactory.getLog(AbstractWfGroupExecutor.class);
    private Boolean isMatchObj = Boolean.TRUE;
    private WriteOffTypeContext typeContext;

    public void init(WriteOffTypeContext typeContext) {
        this.typeContext = typeContext;
    }

    public abstract void doExecute(List<WriteOffMatchGroup> var1);

    protected boolean checkHintMatch(WriteOffNLogInfo logInfo, WriteOffMatchGroup wfMatchGroup, List<MatchRelationConfig> relationConfigs) {
        for (MatchRelationConfig config : relationConfigs) {
            Long matchId = config.getMatchId();
            WriteOffBillConfig targetConfig = this.getTypeConfig().getBillConf(config.getTargetBillTypeKey());
            HintData hintData = this.getHolder().getHintDataLoader().getHintData(matchId, targetConfig.getBillAlias());
            if (targetConfig != null && hintData != null) {
                if (hintData.isNoMatchData()) {
                    logInfo.setMatchLogsInfo(wfMatchGroup, Collections.emptyList(), config.getTargetBillType(), hintData.getConditionInfos(), "B");
                    logger.info(String.format("\u3010%s\u3011\u6838\u9500\u5e73\u53f0\u67e5\u8be2Hint\u5339\u914d\u5355\u636e\u3010%s\u3011\u7ed3\u679c\u4e3a\u7a7a\u3002", this.getTypeConfig().getName(), targetConfig.getBillName()));
                    continue;
                }
                config.setTrackRelation(hintData.getTackInfo());
                return true;
            }
            return true;
        }
        return false;
    }

    protected MatchRuleConfig getMatchRule(WriteOffMatchGroup matchGroup) {
        SchemeConfig schemeConfig = matchGroup.getSchemeConfig();
        MatchRuleConfig matchRuleConfigById = this.getExecuteContext().getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), schemeConfig.getWriteOffTypeId());
        if (matchRuleConfigById == null) {
            throw new KDBizException(EngineLang.matchRuleValidateFail());
        }
        return matchRuleConfigById;
    }

    protected List<WriteOffObject> filterWriteOffObject(AbstractCondtionConfig condtionConfig, List<WriteOffObject> matchObjects) {
        ArrayList<WriteOffObject> filterObjects = new ArrayList<WriteOffObject>(16);
        for (WriteOffObject matchObject : matchObjects) {
            boolean check = condtionConfig.checkCondtion(matchObject) && condtionConfig.checkHighCondtion(matchObject);
            if (!check) continue;
            filterObjects.add(matchObject);
        }
        return filterObjects;
    }

    protected WriteOffTypeContext getHolder() {
        return this.typeContext;
    }

    public WriteOffTypeConfig getTypeConfig() {
        return this.typeContext.getTypeConfig();
    }

    protected WriteOffExecuteContext getExecuteContext() {
        return this.getHolder().getExecuteContext();
    }

    public Boolean getMatchObj() {
        return this.isMatchObj;
    }

    protected void setMatchObj(Boolean matchObj) {
        this.isMatchObj = matchObj;
    }

    public void doWriteOff(List<WriteOffQueueGroup> queueGroups) {
        if (queueGroups.isEmpty()) {
            return;
        }
        WriteOffMatchGroup group = queueGroups.get(0).getGroup();
        try (TraceSpan trace = Tracer.create((String)"WriteOff-StrategyExecutor", (String)"writeOff");){
            WriteOffStrategyExecutor executor = new WriteOffStrategyExecutor(this.typeContext);
            executor.setSchemeContextConfig(group.getSchemeContextConfig());
            executor.writeOff(queueGroups);
        }
    }
}

