/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.AbstractWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.WriteOffBillMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.SchemeMatchReqParam;
import org.apache.commons.collections.CollectionUtils;

public class SchemeMatchWfGroupExecutor
extends AbstractWfGroupExecutor {
    @Override
    public void doExecute(List<WriteOffMatchGroup> matchGroups) {
        SchemeMatchReqParam reqParam = (SchemeMatchReqParam)this.getExecuteContext().getReqParam();
        WriteOffNLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(this.getTypeConfig().getId());
        WriteOffMatchGroup wfMatchGroup = matchGroups.get(0);
        WriteOffBillConfig billTypeConfig = wfMatchGroup.getBillTypeConfig();
        List<MatchRelationConfig> relationConfigs = this.getMatchRule(wfMatchGroup).getByPromoter(billTypeConfig.getBillAlias());
        if (!this.checkHintMatch(logInfo, wfMatchGroup, relationConfigs)) {
            return;
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOff-Matcher", (String)"executeMatch");){
            for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
                List<WriteOffObject> writeOffObjects = writeOffMatchGroup.getWriteOffObjects();
                this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(writeOffObjects);
                if (CollectionUtils.isEmpty(writeOffObjects)) continue;
                for (int i = 0; i < relationConfigs.size(); ++i) {
                    MatchRelationConfig relationConfig = relationConfigs.get(i);
                    WriteOffBillMatcher writeOffBillMatcher = WriteOffBillMatcher.create(writeOffMatchGroup, relationConfig, this.getExecuteContext(), this.getHolder());
                    List<DynamicObject> matchObjects = writeOffBillMatcher.getMatchResult();
                    if (matchObjects == null || matchObjects.isEmpty()) continue;
                    reqParam.addMatchInfo(writeOffObjects, matchObjects);
                }
            }
        }
    }
}

