/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class BackWriteSql {
    private Map<BackWriteSqlKey, List<BackWriteSqlVal>> paramMap = new HashMap<BackWriteSqlKey, List<BackWriteSqlVal>>(16);

    public Map<String, Map<String, List<Object[]>>> buildRouteSqlMap() {
        if (this.paramMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, List<Object[]>>> routeSqlMap = new HashMap<String, Map<String, List<Object[]>>>(this.paramMap.size());
        for (Map.Entry<BackWriteSqlKey, List<BackWriteSqlVal>> routeSqlEntry : this.paramMap.entrySet()) {
            BackWriteSqlKey key = routeSqlEntry.getKey();
            List<BackWriteSqlVal> valList = routeSqlEntry.getValue();
            Map<String, List<Object[]>> map = this.generateSql(key, valList);
            String dbRoute = key.getDbRoute();
            Map<String, List<Object[]>> sqlMap = MapUtils.mapGetMapValue(routeSqlMap, dbRoute);
            MapUtils.mapMerge(sqlMap, map);
        }
        return routeSqlMap;
    }

    private Map<String, List<Object[]>> generateSql(BackWriteSqlKey key, List<BackWriteSqlVal> valList) {
        if (CollectionUtils.isEmpty(valList)) {
            return Collections.emptyMap();
        }
        StringBuilder sqlJoiner = new StringBuilder("update ");
        sqlJoiner.append(key.getTableName());
        sqlJoiner.append(" set ");
        Collections.sort(valList, Comparator.comparing(BackWriteSqlVal::getTableField).thenComparing(BackWriteSqlVal::getWriteBackType));
        ArrayList<String> setSqlList = new ArrayList<String>(4);
        ArrayList<Object> values = new ArrayList<Object>(valList.size() + 1);
        for (BackWriteSqlVal backWriteSqlVal : valList) {
            String setField;
            String backWriteType = backWriteSqlVal.getWriteBackType();
            String tableField = backWriteSqlVal.getTableField();
            values.add(backWriteSqlVal.getVal());
            if ("0".equals(backWriteType)) {
                setField = tableField + " = " + tableField + " - ?";
                setSqlList.add(setField);
                continue;
            }
            if ("1".equals(backWriteType)) {
                setField = tableField + " = " + tableField + " + ?";
                setSqlList.add(setField);
                continue;
            }
            if (!"2".equals(backWriteType)) continue;
            setField = tableField + " = ?";
            setSqlList.add(setField);
        }
        sqlJoiner.append(setSqlList.stream().collect(Collectors.joining(",")));
        sqlJoiner.append(" where ");
        sqlJoiner.append(key.getPkField());
        sqlJoiner.append(" = ?;");
        values.add(key.getPkId());
        return Collections.singletonMap(sqlJoiner.toString(), Collections.singletonList(values.toArray()));
    }

    public void addUpdateField(BackWriteSqlKey key, BackWriteSqlVal updateVal) {
        List<BackWriteSqlVal> updateValList = this.paramMap.get(key);
        if (null == updateValList) {
            updateValList = new ArrayList<BackWriteSqlVal>(4);
            this.paramMap.put(key, updateValList);
        }
        updateValList.add(updateVal);
    }

    public static class BackWriteSqlVal {
        private String writeBackType;
        private String tableField;
        private Object val;

        public BackWriteSqlVal() {
        }

        public BackWriteSqlVal(String writeBackType, String tableField, Object val) {
            this.writeBackType = writeBackType;
            this.tableField = tableField;
            this.val = val;
        }

        public String getWriteBackType() {
            return this.writeBackType;
        }

        public void setWriteBackType(String writeBackType) {
            this.writeBackType = writeBackType;
        }

        public String getTableField() {
            return this.tableField;
        }

        public void setTableField(String tableField) {
            this.tableField = tableField;
        }

        public Object getVal() {
            return this.val;
        }

        public void setVal(Object val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BackWriteSqlVal that = (BackWriteSqlVal)o;
            return Objects.equals(this.writeBackType, that.writeBackType) && Objects.equals(this.tableField, that.tableField) && Objects.equals(this.val, that.val);
        }

        public int hashCode() {
            return Objects.hash(this.writeBackType, this.tableField, this.val);
        }
    }

    public static class BackWriteSqlKey {
        private String dbRoute;
        private String tableName;
        private String pkField;
        private Long pkId;

        public BackWriteSqlKey() {
        }

        public BackWriteSqlKey(String dbRoute, String tableName, String pkField, Long pkId) {
            this.dbRoute = dbRoute;
            this.tableName = tableName;
            this.pkField = pkField;
            this.pkId = pkId;
        }

        public String getDbRoute() {
            return this.dbRoute;
        }

        public void setDbRoute(String dbRoute) {
            this.dbRoute = dbRoute;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getPkField() {
            return this.pkField;
        }

        public void setPkField(String pkField) {
            this.pkField = pkField;
        }

        public Long getPkId() {
            return this.pkId;
        }

        public void setPkId(Long pkId) {
            this.pkId = pkId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BackWriteSqlKey that = (BackWriteSqlKey)o;
            return Objects.equals(this.dbRoute, that.dbRoute) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.pkField, that.pkField) && Objects.equals(this.pkId, that.pkId);
        }

        public int hashCode() {
            return Objects.hash(this.dbRoute, this.tableName, this.pkField, this.pkId);
        }
    }
}

