/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.IBackWfStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfKdtxParamHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteSql;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.EntryBackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.sdk.mpscmm.mscommon.writeoff.params.DeleteAutoBill;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;

public abstract class AbstractBackWfStrategy
implements IBackWfStrategy {
    private static final Log log = LogFactory.getLog(AbstractBackWfStrategy.class);
    private boolean isCa = false;
    private BackWfKdtxParamHolder holder;
    private Map<String, MainEntityType> entityTypeCache = new HashMap<String, MainEntityType>(4);
    private MultiKeyMap<String, IDataEntityType> fieldEntityTypeCache = new MultiKeyMap();
    private MultiKeyMap<String, IDataEntityProperty> propertyCache = new MultiKeyMap();
    private MultiKeyMap<String, String> tableCache = new MultiKeyMap();

    @Override
    public final void backWriteOff(WriteOffTypeConfig typeConfig, DynamicObject record) {
        DeleteAutoBill deleteAutoBill = this.wfRecordHeadBackWf(record);
        this.holder.getUnWfPluginExtFactory().check(record, typeConfig, this.isCa);
        this.holder.getUnWfPluginExtFactory().beforeBackWriteOff(record, typeConfig);
        this.wfRecordBackWf(record, deleteAutoBill, typeConfig);
        this.holder.addAutoBill(deleteAutoBill);
        this.holder.addWfRecord(record, typeConfig);
    }

    abstract void wfRecordBackWf(DynamicObject var1, DeleteAutoBill var2, WriteOffTypeConfig var3);

    private DeleteAutoBill wfRecordHeadBackWf(DynamicObject record) {
        DeleteAutoBill deleteAutoBillList = new DeleteAutoBill();
        DynamicObject wfType = record.getDynamicObject("writeofftypeid");
        long wfTypeId = (Long)wfType.getPkValue();
        BackWriteOffDetail backWriteOffDetail = WriteOffRecordHelper.getWfInfo(record);
        if (backWriteOffDetail == null) {
            return deleteAutoBillList;
        }
        List<BackWriteOffDetail.AutoGeneration> autoGenBillList = backWriteOffDetail.getAutoList();
        if (CollectionUtils.isNotEmpty(autoGenBillList)) {
            for (BackWriteOffDetail.AutoGeneration autoGenBill : autoGenBillList) {
                deleteAutoBillList.add(autoGenBill.getBillType(), autoGenBill.getBillId(), wfTypeId, autoGenBill.getBillNo());
            }
        }
        return deleteAutoBillList;
    }

    public boolean isCa() {
        return this.isCa;
    }

    public void setCa(boolean ca) {
        this.isCa = ca;
    }

    public BackWfKdtxParamHolder getHolder() {
        return this.holder;
    }

    public void setHolder(BackWfKdtxParamHolder holder) {
        this.holder = holder;
    }

    private MainEntityType getDataEntityType(String entityKey) {
        MainEntityType mainEntityType = this.entityTypeCache.get(entityKey);
        if (null == mainEntityType) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            this.entityTypeCache.put(entityKey, mainEntityType);
        }
        return mainEntityType;
    }

    private IDataEntityType getDataEntityType(String entityKey, String field) {
        IDataEntityType entityType = (IDataEntityType)this.fieldEntityTypeCache.get((Object)entityKey, (Object)field);
        if (null == entityType) {
            entityType = this.getDataEntityType(entityKey);
            DynamicProperty entryProp = RowDataModel.findProperty((MainEntityType)((MainEntityType)entityType), (String)field);
            if (null == entryProp) {
                return null;
            }
            entityType = null == entryProp.getParent() ? entityType : entryProp.getParent();
            this.fieldEntityTypeCache.put((Object)entityKey, (Object)field, (Object)entityType);
        }
        return entityType;
    }

    private IDataEntityProperty findProperty(String entityKey, String field) {
        IDataEntityProperty property = (IDataEntityProperty)this.propertyCache.get((Object)entityKey, (Object)field);
        if (null == property) {
            MainEntityType mainEntityType = this.getDataEntityType(entityKey);
            property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)field);
            this.propertyCache.put((Object)entityKey, (Object)field, (Object)property);
        }
        return property;
    }

    private String getTableName(String entityKey, String field) {
        String tableName = (String)this.tableCache.get((Object)entityKey, (Object)field);
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            return tableName;
        }
        IDataEntityProperty property = this.findProperty(entityKey, field);
        IDataEntityType entityType = this.getDataEntityType(entityKey, field);
        if (null == entityType) {
            log.info("\u65e0\u6cd5\u627e\u5230\u5b9e\u4f53[{}]", (Object)entityKey);
            return "";
        }
        String tableGroup = property.getTableGroup();
        tableName = entityType.getAlias();
        if (StringUtils.isNotBlank((CharSequence)tableGroup)) {
            tableName = tableName + "_" + tableGroup;
        }
        this.tableCache.put((Object)entityKey, (Object)field, (Object)tableName);
        return tableName;
    }

    private Map<String, Map<String, List<Object[]>>> buildRouteSqlMap(String entityKey, Long backWriteBillId, Long backWriteEntryId, List<EntryBackWriteOffDetail.BackWriteDetail> backWriteDetailList) {
        BackWriteSql backWriteSql = new BackWriteSql();
        for (EntryBackWriteOffDetail.BackWriteDetail backWriteDetail : backWriteDetailList) {
            String field = backWriteDetail.getBillField();
            IDataEntityProperty property = this.findProperty(entityKey, field);
            if (null == property) {
                log.info("\u65e0\u6cd5\u627e\u5230\u5b9e\u4f53[{}]\u5bf9\u5e94\u5b57\u6bb5[{}],", (Object)entityKey, (Object)field);
                continue;
            }
            IDataEntityType entityType = this.getDataEntityType(entityKey, field);
            if (null == entityType) {
                log.info("\u65e0\u6cd5\u627e\u5230\u5b57\u6bb5[{}]\u5bf9\u5e94\u5b9e\u4f53[{}],", (Object)field, (Object)entityKey);
                continue;
            }
            String dbRouteKey = entityType.getDBRouteKey();
            String tableName = this.getTableName(entityKey, field);
            String pkField = entityType.getPrimaryKey().getAlias();
            String tableField = property.getAlias();
            Long bwPkId = backWriteEntryId;
            if (entityType.getName().equals(entityKey)) {
                bwPkId = backWriteBillId;
            }
            BackWriteSql.BackWriteSqlKey key = new BackWriteSql.BackWriteSqlKey(dbRouteKey, tableName, pkField, bwPkId);
            String writeBackType = backWriteDetail.getWriteBackType();
            if ("0".equals(writeBackType)) {
                backWriteSql.addUpdateField(key, new BackWriteSql.BackWriteSqlVal(writeBackType, tableField, backWriteDetail.getValue()));
                continue;
            }
            if ("1".equals(writeBackType)) {
                backWriteSql.addUpdateField(key, new BackWriteSql.BackWriteSqlVal(writeBackType, tableField, backWriteDetail.getValue()));
                continue;
            }
            if (!"2".equals(writeBackType)) continue;
            backWriteSql.addUpdateField(key, new BackWriteSql.BackWriteSqlVal(writeBackType, tableField, backWriteDetail.getCoverOldValue()));
        }
        return backWriteSql.buildRouteSqlMap();
    }

    protected void addSql(BackWfKdtxParamHolder holder, String entityKey, Long backWriteBillId, Long backWriteEntryId, List<EntryBackWriteOffDetail.BackWriteDetail> backWriteDetailList) {
        if (null == backWriteDetailList || backWriteDetailList.isEmpty()) {
            return;
        }
        Map<String, Map<String, List<Object[]>>> routeMap = this.buildRouteSqlMap(entityKey, backWriteBillId, backWriteEntryId, backWriteDetailList);
        if (routeMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, List<Object[]>>> routeEntry : routeMap.entrySet()) {
            Map<String, List<Object[]>> sqlMap = routeEntry.getValue();
            if (sqlMap.isEmpty()) continue;
            for (Map.Entry<String, List<Object[]>> sqlEntry : sqlMap.entrySet()) {
                if (sqlEntry.getValue().isEmpty()) continue;
                for (Object[] values : sqlEntry.getValue()) {
                    holder.addSql(routeEntry.getKey(), sqlEntry.getKey(), values);
                }
            }
        }
    }
}

