/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.AbstractWriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.common.util.BotpLinkHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.params.AutoBill;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;
import org.apache.commons.collections.CollectionUtils;

public class AutoBillContext
extends AbstractWriteOffTypeContext {
    private static final Log logger = LogFactory.getLog(AutoBillContext.class);
    private Map<String, List<DynamicObject>> autoBillMap = new HashMap<String, List<DynamicObject>>(8);
    @Deprecated
    private Map<String, DynamicObject> autoBill = new HashMap<String, DynamicObject>(16);
    @Deprecated
    private Map<String, DynamicObject> autoBillHeadMapping = new HashMap<String, DynamicObject>(16);

    public AutoBillContext(WriteOffTypeConfig typeConfig) {
        super(typeConfig);
    }

    public void addAutoBillObjs(List<DynamicObject> autobills) {
        for (DynamicObject autoBill : autobills) {
            String billEntity = autoBill.getDataEntityType().getName();
            MapUtils.mapGetListValue(this.autoBillMap, billEntity).add(autoBill);
        }
    }

    @Deprecated
    public void addAutoBill(List<GeneratorBillWf> generateBills) {
        for (GeneratorBillWf generateBill : generateBills) {
            List<AutoBill> autoBillList = generateBill.getAutoBillList();
            for (AutoBill autoBill : autoBillList) {
                List<DynamicObject> bills = autoBill.getAutoBill();
                if (bills == null || bills.size() == 0) continue;
                String billType = autoBill.getBillType();
                List<DynamicObject> billset = this.autoBillMap.get(billType);
                if (billset == null) {
                    billset = new ArrayList<DynamicObject>(16);
                    this.autoBillMap.put(billType, billset);
                }
                billset.addAll(bills);
                if (!this.getTypeConfig().isMergeAutoBill()) continue;
                this.buildAutoBillEntryId(autoBill);
            }
        }
    }

    private void buildAutoBillEntryId(AutoBill autoBill) {
        List<DynamicObject> autoBillObjs = autoBill.getAutoBill();
        if (CollectionUtils.isEmpty(autoBillObjs)) {
            return;
        }
        List<WriteOffBillConfig> billConfigs = this.getTypeConfig().getBillConfigs();
        WriteOffBillConfig writeOffBillConfig = billConfigs.stream().filter(n -> n.getBillAlias().equals(autoBill.getBillTypeKey())).findFirst().orElse(null);
        WriteOffColumnConfig writeOffColumnConfig = writeOffBillConfig.getWriteOffColumnConfig();
        if (writeOffColumnConfig == null) {
            throw new KDBizException(EngineLang.mergeValidateFail());
        }
        String mainFieldEntry = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass().mainFieldEntry();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)autoBill.getBillType());
        for (DynamicObject autoBillObj : autoBillObjs) {
            String srcBillKey = BotpLinkHelper.buildUpBillId(autoBillObj, mainFieldEntry);
            DynamicObject mergeAutoBill = this.autoBill.get(srcBillKey);
            String autoBillKey = CommonUtils.getWfBillKey(dataEntityType.getName(), autoBillObj.getPkValue());
            if (mergeAutoBill != null) {
                this.autoBillHeadMapping.put(autoBillKey, mergeAutoBill);
                continue;
            }
            this.autoBill.put(srcBillKey, autoBillObj);
            this.autoBillHeadMapping.put(autoBillKey, autoBillObj);
        }
    }

    public Map<String, List<DynamicObject>> mergeAutoBill() {
        if (!this.getTypeConfig().isMergeAutoBill() || this.autoBillHeadMapping.isEmpty()) {
            return this.autoBillMap;
        }
        for (Map.Entry<String, List<DynamicObject>> map : this.autoBillMap.entrySet()) {
            List<DynamicObject> value = map.getValue();
            String key = map.getKey();
            Iterator<DynamicObject> iterator = value.iterator();
            while (iterator.hasNext()) {
                DynamicObject dyna = iterator.next();
                String wfBillKey = CommonUtils.getWfBillKey(key, dyna.getPkValue());
                DynamicObject mergeAutoBill = this.autoBillHeadMapping.get(wfBillKey);
                if (dyna.getPkValue().equals(mergeAutoBill.getPkValue())) continue;
                this.dealAutoBillEntry(mergeAutoBill, dyna);
                iterator.remove();
            }
        }
        return this.autoBillMap;
    }

    private void dealAutoBillEntry(DynamicObject sourceBill, DynamicObject autoBill) {
        if (!sourceBill.getPkValue().equals(autoBill.getPkValue())) {
            DynamicObjectCollection sourceBillEntry = sourceBill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection billentry = autoBill.getDynamicObjectCollection("billentry");
            sourceBillEntry.addAll((Collection)billentry);
        }
    }

    public Map<String, DynamicObject> getAutoBill() {
        return this.autoBill;
    }

    public Map<String, DynamicObject> getAutoBillHeadMapping() {
        return this.autoBillHeadMapping;
    }

    public Map<String, List<DynamicObject>> getAutoBillMap() {
        return this.autoBillMap;
    }
}

