/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.DefaultUnWfPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReMdcOmCmpWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReMdcOminWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReRevcfRedWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.SctmUnWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.IWriteOffBasePlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IKdtxUnWfPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWfEndWriteBackPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;
import org.apache.commons.collections4.map.MultiKeyMap;

public class UnWfPluginExtFactory {
    private static final Log log = LogFactory.getLog(UnWfPluginExtFactory.class);
    private final MultiKeyMap<String, PluginProxy<? extends IWriteOffBasePlugin>> unWfPluginCache = new MultiKeyMap();
    private WriteOffParamManager writeOffParamManager;

    public UnWfPluginExtFactory setWriteOffParamManager(WriteOffParamManager writeOffParamManager) {
        this.writeOffParamManager = writeOffParamManager;
        return this;
    }

    public List<IKdtxUnWfPlugin> kdtxBackWfPlugin(Long typeConfigId) {
        String wfTypeId = typeConfigId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_KDTX", wfTypeId);
        if (null == pluginProxy) {
            pluginProxy = PluginProxy.create(IKdtxUnWfPlugin.class, (String)"SCMC_UNWRITEOFF_KDTX");
            this.cachePluginProxy("SCMC_UNWRITEOFF_KDTX", wfTypeId, pluginProxy);
        }
        List<IKdtxUnWfPlugin> plugins = CommonUtils.getPlugins(new ReWriteBackBillByPlugin(), new ReMdcOminWriteBackBillByPlugin(), new ReMdcOmCmpWriteBackBillByPlugin(), new ReRevcfRedWriteBackBillByPlugin(), new SctmUnWriteBackBillByPlugin());
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IKdtxUnWfPlugin> pluginList = new ArrayList<IKdtxUnWfPlugin>(plugins.size());
        for (IKdtxUnWfPlugin plugin : plugins) {
            if (this.isBreakPlugin(typeConfigId, plugin, "kdtxBackWfPlugin") || !CommonUtils.isContain(plugin.getWriteOffTypeIds(), typeConfigId)) continue;
            pluginList.add(plugin);
        }
        return pluginList;
    }

    public void endWriteBack(String DBRouteKey, List<DynamicObject> records, Long typeId) {
        String wfTypeId = typeId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_END_BACK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeId);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWfEndWriteBackPlugin.class, (String)"SCMC_UNWRITEOFF_END_BACK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_END_BACK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeId) && !this.isBreakPlugin(typeId, (IWriteOffBasePlugin)p, "endWriteBack")) {
                p.endWriteBack(DBRouteKey, records);
            }
            return null;
        });
    }

    public void autoBillDelete(String billType, List<Long> idList, Long typeId) {
        DefaultUnWfPlugin unWfPlugin = new DefaultUnWfPlugin(typeId);
        PluginProxy pluginProxy = PluginProxy.create((Object)unWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeId) && !this.isBreakPlugin(typeId, (IWriteOffBasePlugin)p, "autoBillDelete")) {
                p.autoBillDelete(billType, idList);
            }
            return null;
        });
    }

    public void beforeWfRecordDelete(List<DynamicObject> records, Long typeId, Boolean isCa) {
        String wfTypeId = typeId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeId, isCa);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeId) && !this.isBreakPlugin(typeId, (IWriteOffBasePlugin)p, "beforeWfRecordDelete")) {
                p.beforeWfRecordDelete(records);
            }
            return null;
        });
    }

    public void beforeBackWriteOff(DynamicObject records, WriteOffTypeConfig typeConfig) {
        String wfTypeId = typeConfig.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId());
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeConfig.getId()) && !this.isBreakPlugin(typeConfig.getId(), (IWriteOffBasePlugin)p, "beforeBackWriteOff")) {
                p.beforeBackWriteOff(records);
            }
            return null;
        });
    }

    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records, WriteOffTypeConfig typeConfig) {
        String wfTypeId = typeConfig.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId());
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        HashMap<String, Map<String, List<Object[]>>> map = new HashMap<String, Map<String, List<Object[]>>>(16);
        pluginProxy.callAfter(p -> {
            Map<String, Map<String, List<Object[]>>> sqlMap;
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeConfig.getId()) && !this.isBreakPlugin(typeConfig.getId(), (IWriteOffBasePlugin)p, "buildBackSql") && (sqlMap = p.buildBackSql(records)) != null) {
                CommonUtils.buildSqlMap(map, sqlMap);
            }
            return null;
        });
        return map;
    }

    public boolean check(DynamicObject record, WriteOffTypeConfig typeConfig, boolean isCa) {
        String wfTypeId = typeConfig.getId().toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId(), isCa);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffCheckPlugin.class, (String)"SCMC_UNWRITEOFF_CHECK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeConfig.getId()) && !this.isBreakPlugin(typeConfig.getId(), (IWriteOffBasePlugin)p, "check") && !p.check(record)) {
                throw new KDBizException(EngineLang.unWriteOffFail());
            }
            return null;
        });
        return true;
    }

    public void batchCheck(List<DynamicObject> wfRecordList, WriteOffTypeConfig typeConfig, boolean isCa) {
        String wfTypeId = typeConfig.getId().toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId(), isCa);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffCheckPlugin.class, (String)"SCMC_UNWRITEOFF_CHECK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain(p.getWriteOffTypeIds(), typeConfig.getId()) && !this.isBreakPlugin(typeConfig.getId(), (IWriteOffBasePlugin)p, "check")) {
                p.check(wfRecordList);
            }
            return null;
        });
    }

    private <T extends IWriteOffBasePlugin> PluginProxy<T> getPluginProxy(String extPointName, String wfTypeId) {
        return (PluginProxy)this.unWfPluginCache.get((Object)extPointName, (Object)wfTypeId);
    }

    private <T extends IWriteOffBasePlugin> void cachePluginProxy(String extPointName, String wfTypeId, PluginProxy<T> pluginProxy) {
        this.unWfPluginCache.put((Object)extPointName, (Object)wfTypeId, pluginProxy);
    }

    private boolean isBreakPlugin(Long wftypeId, IWriteOffBasePlugin plugin, String methodName) {
        String className;
        boolean isBreakPlugin;
        if (null == plugin) {
            return true;
        }
        if (null == this.writeOffParamManager) {
            this.writeOffParamManager = WriteOffParamManager.create();
        }
        if (isBreakPlugin = this.writeOffParamManager.isBreakPlugin(wftypeId, className = plugin.getClass().getSimpleName(), methodName)) {
            log.info("\u7194\u65ad\u6838\u9500\u7c7b\u522b\u3010{}\u3011\u7684\u53cd\u6838\u9500\u63d2\u4ef6\u65b9\u6cd5\uff1a{}#{}", new Object[]{wftypeId, className, methodName});
        }
        return isBreakPlugin;
    }
}

