/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.generate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AuotBillGenResult;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.GenerateResult;
import kd.mpscmm.mscommon.writeoff.common.helper.BotpPushHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.CollectionUtils;

public class BotpGenerator {
    private static final Log logger = LogFactory.getLog(BotpGenerator.class);
    private WriteOffTypeConfig typeConfig;
    private BillBotpConfig billBotpConfig = null;
    private WriteOffBillConfig sourceBillConfig = null;
    private WriteOffBillConfig targetBillConfig = null;
    private Map<String, String> paramMap = new HashMap<String, String>(16);

    public static BotpGenerator create(WriteOffTypeConfig typeConfig, BillBotpConfig botpConfig) {
        BotpGenerator generator = new BotpGenerator(botpConfig, typeConfig);
        generator.initInfo();
        return generator;
    }

    private BotpGenerator(BillBotpConfig billConfig, WriteOffTypeConfig typeConfig) {
        this.billBotpConfig = billConfig;
        this.typeConfig = typeConfig;
    }

    private void initInfo() {
        this.sourceBillConfig = this.typeConfig.getBillConf(this.billBotpConfig.getSrcBillAlias());
        this.targetBillConfig = this.typeConfig.getBillConf(this.billBotpConfig.getTargetBillAlias());
    }

    public AuotBillGenResult generateAutoWriteOffObjects(List<WriteOffObjectBase> wfObjs) {
        try (TraceSpan span = Tracer.create((String)"BotpGenerator", (String)"generateBill");){
            GenerateResult generateResult = this.callBotpPush(wfObjs);
            if (generateResult.isSuccess()) {
                List<DynamicObject> bills = generateResult.getBill();
                DynamicObjectUtil.setBillIdAndNumber(bills);
                AuotBillGenResult auotBillGenResult = this.createResultFromBill(bills);
                return auotBillGenResult;
            }
            String errorMessage = String.format(ResManager.loadKDString((String)"\u6838\u9500\u751f\u6210\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:%s", (String)"WriteOffBillGenerator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), generateResult.getFailReason());
            logger.info(errorMessage);
            AuotBillGenResult auotBillGenResult = AuotBillGenResult.createFail(errorMessage);
            return auotBillGenResult;
        }
    }

    private GenerateResult callBotpPush(List<WriteOffObjectBase> objs) {
        String botpRule = this.billBotpConfig.getBotpRule();
        PushArgs botp = BotpPushHelper.buildPushArgs(this.sourceBillConfig, this.targetBillConfig, botpRule, objs, this.paramMap);
        ConvertOperationResult convertResult = BotpPushHelper.push(botp);
        if (!convertResult.isSuccess()) {
            return GenerateResult.createFailResult(CommonUtils.strConnect(convertResult.getMessage(), ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219ID\uff1a", (String)"BOTPBillGenerator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), botpRule));
        }
        List<DynamicObject> purInBills = BotpPushHelper.getTargetObjectWithRefence(convertResult);
        if (CollectionUtils.isEmpty(purInBills)) {
            GenerateResult result = GenerateResult.createFailResult(CommonUtils.strConnect(this.sourceBillConfig.getBillName(), " - ", botpRule, ResManager.loadKDString((String)"BOTP\u914d\u7f6e\u9519\u8bef\u3002", (String)"BOTPBillGenerator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0])));
            result.setBotpid(botpRule);
            return result;
        }
        GenerateResult generateTargetBill = GenerateResult.createSuccessResult(purInBills);
        generateTargetBill.setBotpid(botpRule);
        return generateTargetBill;
    }

    private AuotBillGenResult createResultFromBill(List<DynamicObject> bills) {
        AuotBillGenResult success = AuotBillGenResult.createSuccess();
        success.setGenBills(bills);
        return success;
    }
}

