/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AutoGenBillObj;

public class AutoBillWriteOffGroup {
    private WriteOffQueueGroup queueGroup;
    private BillBotpConfig billBotpConfig;
    private String autoBillEntryKey = null;
    private List<AutoGenBillObj> genObjs = new ArrayList<AutoGenBillObj>(16);

    public AutoBillWriteOffGroup(WriteOffQueueGroup queueGroup, BillBotpConfig billBotpConfig, String autoBillEntryKey) {
        this.queueGroup = queueGroup;
        this.autoBillEntryKey = autoBillEntryKey;
        this.billBotpConfig = billBotpConfig;
    }

    public WriteOffQueueGroup getQueueGroup() {
        return this.queueGroup;
    }

    public List<AutoGenBillObj> getGenObjs() {
        return this.genObjs;
    }

    public void addAutoBillObj(DynamicObject genEntry) {
        this.genObjs.add(new AutoGenBillObj(genEntry));
    }

    public Map<Object, DynamicObject> getAutoBill() {
        boolean isEntryObj = StringUtils.isNotEmpty((CharSequence)this.autoBillEntryKey);
        HashMap<Object, DynamicObject> objMap = new HashMap<Object, DynamicObject>(16);
        for (AutoGenBillObj autoGenBillObj : this.genObjs) {
            DynamicObject autoObj = autoGenBillObj.getObj();
            if (isEntryObj) {
                DynamicObject billObj = (DynamicObject)autoObj.getParent();
                objMap.put(billObj.getPkValue(), billObj);
                continue;
            }
            objMap.put(autoObj.getPkValue(), autoObj);
        }
        return objMap;
    }

    public void setAutoBillWBDetail() {
        Map<Object, DynamicObject> autoBillMap = this.getAutoBill();
        for (DynamicObject bill : autoBillMap.values()) {
            BackWriteOffDetail.AutoGeneration autoGeneration = BackWriteOffDetail.AutoGeneration.create(bill, this.billBotpConfig);
            this.getQueueGroup().addBackWriteOffInfo(autoGeneration);
        }
    }

    public static List<DynamicObject> getAutoBillObjs(List<AutoBillWriteOffGroup> groups) {
        HashMap<Object, DynamicObject> objMap = new HashMap<Object, DynamicObject>(16);
        for (AutoBillWriteOffGroup group : groups) {
            objMap.putAll(group.getAutoBill());
        }
        return new ArrayList<DynamicObject>(objMap.values());
    }
}

