/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll.QueueElement;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll.QueueElementGroup;

public class MultiQueuePoller<T> {
    private List<QueueElement<T>> mainQueues = new ArrayList<QueueElement<T>>();
    private Queue<QueueElement<T>> assistQueue = new LinkedList<QueueElement<T>>();

    public List<QueueElementGroup<T>> pollQueue() {
        ArrayList<QueueElementGroup<T>> results = new ArrayList<QueueElementGroup<T>>(16);
        for (QueueElement<T> mainElement : this.mainQueues) {
            BigDecimal mainNumber = mainElement.getNumber();
            ArrayList assistElements = new ArrayList(16);
            while (BigDecimal.ZERO.compareTo(mainNumber) != 0 && !this.assistQueue.isEmpty()) {
                QueueElement<T> assistElement = this.assistQueue.peek();
                BigDecimal assistNumber = assistElement.getNumber();
                BigDecimal subtract = mainNumber.abs().subtract(assistNumber.abs());
                int compareResult = BigDecimal.ZERO.compareTo(subtract);
                if (compareResult == 0) {
                    assistElements.add(this.assistQueue.poll());
                    break;
                }
                if (compareResult < 0) {
                    mainNumber = mainNumber.subtract(assistNumber);
                    assistElements.add(this.assistQueue.poll());
                    continue;
                }
                assistElements.add(assistElement.cutDown(mainNumber));
                break;
            }
            results.add(new QueueElementGroup<T>(mainElement, assistElements));
        }
        return results;
    }

    public void addMainElement(T element, BigDecimal number) {
        this.mainQueues.add(new QueueElement<T>(element, number));
    }

    public void addAssistElement(T element, BigDecimal number) {
        this.assistQueue.add(new QueueElement<T>(element, number));
    }
}

