/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.kdtx;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.param.IWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.FlowWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualAutoWfReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.kdtxargs.WfParam;
import kd.mpscmm.mscommon.writeoff.common.util.OperationUtil;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.AbstractWriteOffExtPlugin;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.lang.TaskLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class KdtxWriteOffService {
    private static final Log logger = LogFactory.getLog(KdtxWriteOffService.class);
    private WriteOffExecuteContext executeContext;
    private List<String> businessInfos;
    private WriteOffTypeConfig wfType;
    private boolean isAsyn;
    private Map<String, List<Object>> billSaveSuccess = new HashMap<String, List<Object>>(16);
    private WriteOffNLogInfo writeOffLog;

    public KdtxWriteOffService(Set<String> businessInfos, WriteOffTypeConfig wfType, boolean isManualWriteOff, Map<String, List<Object>> billSaveSuccess, WriteOffExecuteContext executeContext) {
        this.businessInfos = new ArrayList<String>(businessInfos);
        this.wfType = wfType;
        this.isAsyn = !isManualWriteOff;
        this.billSaveSuccess = billSaveSuccess;
        this.executeContext = executeContext;
    }

    public void kdtxWriteOffRecord(WriteOffTypeConfig wfType, List<DynamicObject> recordList) {
        if (CollectionUtils.isEmpty(recordList)) {
            return;
        }
        DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
        List<Object> successIds = KdtxWriteOffService.saveRecord(records);
        WfParam commonParam = new WfParam();
        commonParam.setBillNumber(records[0].getDataEntityType().getName());
        String dbRouteKey = records[0].getDataEntityType().getDBRouteKey();
        commonParam.setDbRout(dbRouteKey);
        commonParam.setWfTypeId(wfType.getId());
        commonParam.setIds(successIds);
        long taskLogId = this.logWriteOffTask(TaskLang.generateRecord(), "WriteOffRecordService", "msmod_writeoff_generate_record", commonParam);
        commonParam.setLogId(taskLogId);
        commonParam.setIsWfMode(this.getIsMode());
        commonParam.setWfExtParams(wfType.getWfExtParams());
        try {
            ECServiceHelper.execute("msmod_writeoff", "msmod_writeoff_generate_record", "mpscmm", "mscommon", dbRouteKey, "WriteOffRecordService", this.businessInfos, commonParam, this.businessInfos.get(0), this.isAsyn);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
            throw new KDBizException(EngineLang.kdtxCallFail(e) + e.getMessage());
        }
    }

    private static List<Object> saveRecord(DynamicObject[] records) {
        KdtxWriteOffService.writeCollectInfo(records.length, 0L, records[0].getDataEntityType().getName(), Collections.emptyMap());
        DynamicObject[] dynamicObjectArray = null;
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])records);
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject record : records) {
            ids.add(record.getPkValue());
        }
        return ids;
    }

    private static void writeCollectInfo(int count, Long time, String formid, Map<String, String> var) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>(4);
        jsonObject.put("keyword", "POA-FEATURE-MONITOR");
        jsonObject.put("featureNumber", "MPSCMM002");
        jsonObject.put("count", count);
        jsonObject.put("time:", time);
        jsonObject.put("formid", formid);
        jsonObject.put("var", var);
        logger.info(SerializationUtils.toJsonString(jsonObject));
    }

    private String getIsMode() {
        IWriteOffReqParam reqParam = this.executeContext.getReqParam();
        if (reqParam instanceof FlowWriteOffReqParam) {
            return "1";
        }
        if (reqParam instanceof ManualAutoWfReqParam) {
            return "3";
        }
        if (reqParam instanceof ManualWriteOffReqParam) {
            return "2";
        }
        return "";
    }

    public void kdtxBackWriteBill(Map<String, Map<String, List<Object[]>>> map, Map<String, Set<Long>> snapIdMap, Map<Long, List<DynamicObject>> writeoffRecordMap) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        Map<String, List<Object>> recordSerMap = this.resolveRecordMap(writeoffRecordMap);
        for (Map.Entry<String, Map<String, List<Object[]>>> sqlBuilderEntry : map.entrySet()) {
            WfParam commonParam = new WfParam();
            String DBRout = sqlBuilderEntry.getKey();
            commonParam.setDbRout(DBRout);
            Map<String, List<Object[]>> value = sqlBuilderEntry.getValue();
            commonParam.setParam(value);
            Set<Long> snapIds = snapIdMap.remove(DBRout);
            commonParam.setSnapShootIds(snapIds);
            commonParam.setRecordMap(recordSerMap);
            commonParam.setWfTypeId(this.wfType.getId());
            long taskLogId = this.logWriteOffTask(TaskLang.writeBack(DBRout), "BackWriteService", "msmod_writeoff_writeback", commonParam);
            commonParam.setLogId(taskLogId);
            commonParam.setWfExtParams(this.wfType.getWfExtParams());
            try {
                ECServiceHelper.execute("msmod_writeoff", "msmod_writeoff_writeback", "mpscmm", "mscommon", DBRout, "BackWriteService", Collections.emptyList(), commonParam, this.businessInfos.get(0), this.isAsyn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void kdtxWfPlugin(List<DynamicObject> records, List<Map<String, Object>> recordKdtxParams) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<IKdtxWfPlugin> iKdtxWfPlugins = WfPluginExtFactory.kdtxWfPlugin(this.wfType.getId(), this.wfType.getWfExtParams());
        for (IKdtxWfPlugin plugin : iKdtxWfPlugins) {
            if (plugin instanceof AbstractWriteOffExtPlugin) {
                AbstractWriteOffExtPlugin extPlugin = (AbstractWriteOffExtPlugin)((Object)plugin);
                extPlugin.setExecuteContext(this.executeContext);
                extPlugin.setWftConfig(this.wfType);
            }
            String pluginName = plugin.getClass().getSimpleName();
            boolean breakPlugin = this.executeContext.getWfParam().isBreakPlugin(this.wfType.getId(), pluginName, "kdtxWfPlugin");
            if (breakPlugin) {
                logger.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u63d2\u4ef6\u3010%s\u3011\u65b9\u6cd5\u3010%s\u3011\u8fdb\u884c\u7194\u65ad\uff01", this.wfType.getName(), pluginName, "kdtxWfPlugin"));
                continue;
            }
            Map<String, Object> kdtxWfPluginParam = plugin.getKdtxWfPluginParam(recordKdtxParams);
            WfParam commonParam = new WfParam();
            commonParam.setBillNumber(records.get(0).getDataEntityType().getName());
            commonParam.setValue(plugin.getClass().getName());
            commonParam.setWfTypeId(this.wfType.getId());
            List<Object> ids = records.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
            commonParam.setIds(ids);
            long taskLogId = this.logWriteOffTask(TaskLang.executePlugin(plugin.getClass()), "WriteOffPluginService", "msmod_writeoff_plugin", commonParam);
            commonParam.setLogId(taskLogId);
            commonParam.setKdtxWfPluginParam(kdtxWfPluginParam);
            commonParam.setWfExtParams(this.wfType.getWfExtParams());
            try {
                ECServiceHelper.execute("msmod_writeoff", "msmod_writeoff_plugin", "mpscmm", "mscommon", "WriteOffPluginService", Collections.emptyList(), this.businessInfos.get(0), (Param)commonParam, this.isAsyn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    private Map<String, List<Object>> resolveRecordMap(Map<Long, List<DynamicObject>> recordMap) {
        HashMap<String, List<Object>> recordSerMap = new HashMap<String, List<Object>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
            Long wfTypeId = entry.getKey();
            List<DynamicObject> recordList = entry.getValue();
            if (recordList.isEmpty()) continue;
            DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
            List idList = recordList.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
            String key = wfTypeId + "#" + records[0].getDataEntityType().getName();
            recordSerMap.put(key, idList);
        }
        return recordSerMap;
    }

    public void autoGenerateBillService(Map<String, List<DynamicObject>> autoBillMap) {
        if (MapUtils.isEmpty(autoBillMap)) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> autoBillEntry : autoBillMap.entrySet()) {
            List<DynamicObject> autoBillEntryValue = autoBillEntry.getValue();
            DynamicObject[] autoList = autoBillEntryValue.toArray(new DynamicObject[autoBillEntryValue.size()]);
            List<Object> successIds = this.saveBill(autoList, Boolean.TRUE);
            WfParam commonParam = new WfParam();
            String billType = autoBillEntry.getKey();
            commonParam.setBillNumber(billType);
            commonParam.setWfTypeId(this.wfType.getId());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            commonParam.setDbRout(dbRouteKey);
            commonParam.setIds(successIds);
            long taskLogId = this.logWriteOffTask(TaskLang.autoGenerateBill(dataEntityType.getAlias()), "AutoGenerateBillService", "msmod_writeoff_autobill_generate", commonParam);
            commonParam.setLogId(taskLogId);
            commonParam.setWfExtParams(this.wfType.getWfExtParams());
            try {
                ECServiceHelper.execute("msmod_writeoff", "msmod_writeoff_autobill_generate", "mpscmm", "mscommon", dbRouteKey, "AutoGenerateBillService", Collections.emptyList(), commonParam, this.businessInfos.get(0), this.isAsyn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    private List<Object> saveBill(DynamicObject[] autoList, Boolean isAutoBill) {
        try (TXHandle tx = TX.notSupported();){
            Map<Object, String> map = this.getBillNos(autoList, isAutoBill);
            OperationResult result = OperationUtil.saveBillOp(autoList);
            if (result == null) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            String billType = autoList[0].getDataEntityType().getName();
            List successPkIds = result.getSuccessPkIds();
            if (CollectionUtils.isNotEmpty((Collection)successPkIds)) {
                this.billSaveSuccess.putIfAbsent(billType, new ArrayList(8));
                this.billSaveSuccess.get(billType).addAll(successPkIds);
            }
            if (!result.isSuccess()) {
                StringBuilder erroInfo = OperationUtil.getErroInfo(result);
                logger.error("auto bill fail ,errormessage :" + erroInfo);
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u4fdd\u5b58\u81ea\u52a8\u751f\u6210\u5355\u636e\u5931\u8d25\u3002", (String)"WfSnapShootHolder_7", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            this.updateBillNo(autoList, map, isAutoBill);
            List list = successPkIds;
            return list;
        }
    }

    private void updateBillNo(DynamicObject[] autoBills, Map<Object, String> map, Boolean isAutoBill) {
        if (!isAutoBill.booleanValue()) {
            return;
        }
        for (DynamicObject bill : autoBills) {
            bill.set("billno", (Object)map.get(bill.getPkValue()));
        }
        SaveServiceHelper.update((DynamicObject[])autoBills);
    }

    private Map<Object, String> getBillNos(DynamicObject[] autoBills, Boolean isAutoBill) {
        if (!isAutoBill.booleanValue()) {
            return Collections.emptyMap();
        }
        HashMap<Object, String> map = new HashMap<Object, String>(16);
        for (DynamicObject bill : autoBills) {
            String billno = bill.getString("billno");
            map.put(bill.getPkValue(), billno);
        }
        return map;
    }

    public void setWriteOffLog(WriteOffNLogInfo writeOffLog) {
        this.writeOffLog = writeOffLog;
    }

    private long logWriteOffTask(String taskName, String taskClass, String branchcode, Object commonParam) {
        if (this.writeOffLog != null) {
            String reqParam = null;
            if (this.executeContext.getWfParam().isLogKdtxParam()) {
                reqParam = JSONObject.toJSONString((Object)commonParam);
            }
            return this.writeOffLog.addTaskEntry(taskName, taskClass, branchcode, this.businessInfos.get(0), reqParam);
        }
        return 0L;
    }
}

