/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.match;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;

public class BillDataSource {
    private static final Log logger = LogFactory.getLog(BillDataSource.class);
    private BillFieldInfoManager fieldInfos = null;

    public BillDataSource(BillFieldInfoManager fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public DynamicObjectCollection queryBillData(String entity, String entryKey, QFilter filter) {
        return this.queryBillData(entity, entryKey, filter.toArray());
    }

    public DynamicObjectCollection queryBillData(String entity, String entryKey, QFilter[] filter) {
        String buildSelectField = this.fieldInfos.buildSelectField(entity, entryKey);
        logger.info("\u67e5\u8be2\u5355\u636e" + entity + "\uff0c\u5b57\u6bb5\u4fe1\u606f\uff1a" + buildSelectField);
        DynamicObjectCollection result = QueryServiceHelper.query((String)entity, (String)buildSelectField, (QFilter[])filter);
        List<String> itemClassInfo = this.fieldInfos.getItemClassInfo(entity, entryKey);
        if (!itemClassInfo.isEmpty()) {
            logger.info("\u67e5\u8be2\u5355\u636e" + entity + "\u6570\u636e\uff0c\u52a0\u8f7d\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u4e2d\u4f9b\u5e94\u5546\u3001\u5ba2\u6237\u6570\u636e\uff1a" + itemClassInfo);
            HashSet<Object> ids = new HashSet<Object>(16);
            for (DynamicObject row : result) {
                for (String itemClassProp : itemClassInfo) {
                    ids.add(row.get(itemClassProp));
                }
            }
            HashMap<Object, Object> idToMasterId = new HashMap<Object, Object>(16);
            idToMasterId.putAll(this.loadMasterInfo("bd_supplier", ids));
            idToMasterId.putAll(this.loadMasterInfo("bd_customer", ids));
            for (DynamicObject row : result) {
                for (String itemClassProp : itemClassInfo) {
                    Object masterid = idToMasterId.get(row.get(itemClassProp));
                    if (masterid == null) continue;
                    row.set(itemClassProp, masterid);
                }
            }
        }
        return result;
    }

    private Map<Object, Object> loadMasterInfo(String entity, Set<Object> ids) {
        HashMap<Object, Object> idToMasteriD = new HashMap<Object, Object>(16);
        Map datas = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,masterid", (QFilter[])new QFilter("id", "in", ids).toArray());
        for (DynamicObject data : datas.values()) {
            idToMasteriD.put(data.get("id"), data.get("masterid"));
        }
        return idToMasteriD;
    }
}

