/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.HintDataInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;

public class HintData {
    public static final Log log = LogFactory.getLog(HintDataMatcher.class);
    private String matchBillAlias;
    private Boolean loadSnapShoot = false;
    private Map<String, List<HintDataInfo>> matchDatas = new HashMap<String, List<HintDataInfo>>(16);
    private Map<Long, List<HintDataInfo>> idToDatas = new HashMap<Long, List<HintDataInfo>>(16);
    private List<MatchConditionConfig> hintFieldConfigs = new ArrayList<MatchConditionConfig>(16);
    private String tackInfo = null;
    private Map<Long, Set<Long>> botpLinkInfo = null;
    private List<WriteOffMatchConditionInfo> conditionInfos = new ArrayList<WriteOffMatchConditionInfo>(16);

    public boolean isAlreadyGetIds() {
        return this.loadSnapShoot;
    }

    public Set<Object> getHintDataIds() {
        HashSet<Object> ids = new HashSet<Object>(16);
        for (List<HintDataInfo> datas : this.matchDatas.values()) {
            for (HintDataInfo data : datas) {
                ids.add(data.getData().get("id"));
            }
        }
        this.loadSnapShoot = true;
        return ids;
    }

    public Set<Long> getLinkInfo(List<WriteOffObject> objs) {
        if (this.botpLinkInfo == null) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        for (WriteOffObject obj : objs) {
            Set<Long> set = this.botpLinkInfo.get(obj.getWriteOffObjectPk());
            if (set == null) continue;
            ids.addAll(set);
        }
        return ids;
    }

    public List<WriteOffMatchConditionInfo> getConditionInfos() {
        return this.conditionInfos;
    }

    public List<DynamicObject> getMatchedBillByBotpLink(String mainFieldEntryId, String bosExpression, Set<Long> linkInfo) {
        HashSet<String> hintKeys = new HashSet<String>(16);
        for (Long linkEntryId : linkInfo) {
            hintKeys.add(linkEntryId + "@");
        }
        ArrayList<HintDataInfo> datas = new ArrayList<HintDataInfo>(16);
        for (String hintkey : hintKeys) {
            List<HintDataInfo> mdatas = this.matchDatas.get(hintkey);
            if (mdatas == null) continue;
            datas.addAll(mdatas);
        }
        return this.getMatchDatas(bosExpression, datas);
    }

    public List<DynamicObject> getMatchedBillByHintKey(String mainFieldEntryId, String bosExpression, List<WriteOffObject> list) {
        if (this.hintFieldConfigs == null) {
            log.error("\u6838\u9500\u5e73\u53f0hint\u5339\u914d\u65e0hint\u5b57\u6bb5");
            return Collections.emptyList();
        }
        Set<String> hintKeys = this.buildHintKeys(list);
        ArrayList<HintDataInfo> datas = new ArrayList<HintDataInfo>(16);
        for (String hintkey : hintKeys) {
            List<HintDataInfo> mdatas = this.matchDatas.get(hintkey);
            if (mdatas == null) continue;
            datas.addAll(mdatas);
        }
        return this.getMatchDatas(bosExpression, datas);
    }

    private Set<String> buildHintKeys(List<WriteOffObject> list) {
        HashSet<String> hintKeys = new HashSet<String>(16);
        for (WriteOffObject objs : list) {
            StringBuilder str = new StringBuilder();
            for (MatchConditionConfig hintField : this.hintFieldConfigs) {
                Object value = objs.getValue(hintField.getSrcValueKey());
                if (hintField.getEmptyEqual().booleanValue() && hintField.checkEmptyValue(value)) {
                    str.append("empty");
                } else {
                    str.append(value);
                }
                str.append("@");
            }
            hintKeys.add(str.toString());
        }
        return hintKeys;
    }

    public List<DynamicObject> getMatchedBillByIdHint(String mainFieldEntryId, String bosExpression, Set<Object> ids) {
        ArrayList<HintDataInfo> datas = new ArrayList<HintDataInfo>(16);
        for (Object id : ids) {
            List<HintDataInfo> idDataInfo = this.idToDatas.get(id);
            if (idDataInfo == null) continue;
            datas.addAll(idDataInfo);
        }
        return this.getMatchDatas(bosExpression, datas);
    }

    private List<DynamicObject> getMatchDatas(String bosExpression, List<HintDataInfo> datas) {
        BOSExpression expression = new BOSExpression(bosExpression);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (datas != null) {
            for (HintDataInfo data : datas) {
                Set vars = expression.getVars();
                Map<String, Object> dataMaps = data.getValueMap(vars);
                Boolean isMatch = (Boolean)FormulaEngine.execExcelFormula((Expr)expression.getExpr(), dataMaps);
                if (!isMatch.booleanValue()) continue;
                result.add(data.getData());
            }
        }
        return result;
    }

    public void addBotpMatchData(List<DynamicObject> hintQueryResults, List<QFilter> hintQueryFilters, Map<Long, Set<Long>> srcToTgtList, String trackInfo, WriteOffBillConfig tgtBillConf, List<MatchConditionConfig> hintFields) {
        this.addDataInfo(hintQueryResults, tgtBillConf, hintFields);
        this.botpLinkInfo = srcToTgtList;
        this.tackInfo = trackInfo;
        this.conditionInfos = Collections.singletonList(new WriteOffMatchConditionInfo(NounLang.botpLink(), "=", String.valueOf(hintQueryFilters)));
    }

    public void addMatchData(List<DynamicObject> hintQueryResults, List<QFilter> hintQueryFilters, WriteOffBillConfig tgtBillConf, List<MatchConditionConfig> hintConfigs) {
        this.addDataInfo(hintQueryResults, tgtBillConf, hintConfigs);
        this.conditionInfos = Collections.singletonList(new WriteOffMatchConditionInfo(NounLang.hintQuery(), "=", String.valueOf(hintQueryFilters)));
    }

    private void addDataInfo(List<DynamicObject> hintQueryResults, WriteOffBillConfig tgtBillConf, List<MatchConditionConfig> hintConfigs) {
        ILocaleString billName = tgtBillConf.getObj().getDynamicObject("wfbillalias").getLocaleString("wfbill.name");
        this.matchBillAlias = billName.getLocaleValue();
        for (DynamicObject queryResult : hintQueryResults) {
            StringBuilder str = new StringBuilder();
            for (MatchConditionConfig field : hintConfigs) {
                Object value = queryResult.get(field.getTgtValueKey());
                if (field.getEmptyEqual().booleanValue() && field.checkEmptyValue(value)) {
                    str.append("empty");
                } else {
                    str.append(value);
                }
                str.append("@");
            }
            HintDataInfo hintDataInfo = new HintDataInfo(this.matchBillAlias, queryResult);
            MapUtils.mapGetListValue(this.idToDatas, queryResult.getLong("id")).add(hintDataInfo);
            MapUtils.mapGetListValue(this.matchDatas, str.toString()).add(hintDataInfo);
        }
        this.hintFieldConfigs = hintConfigs;
    }

    public boolean isNoMatchData() {
        return this.matchDatas.isEmpty();
    }

    public String getTackInfo() {
        return this.tackInfo;
    }

    public Map<Long, List<HintDataInfo>> getIdToDatas() {
        return this.idToDatas;
    }

    public Map<String, List<HintDataInfo>> getMatchDatas() {
        return this.matchDatas;
    }
}

