/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class HintDataInfo {
    public static final Log log = LogFactory.getLog(HintDataInfo.class);
    private final String billAlias;
    private final DynamicObject data;
    private Map<String, Object> cacheValue = new HashMap<String, Object>(16);

    public HintDataInfo(String billAlias, DynamicObject data) {
        this.billAlias = billAlias;
        this.data = data;
    }

    public Map<String, Object> getValueMap(Collection<String> vars) {
        boolean isInit = this.cacheValue.isEmpty();
        for (String var : vars) {
            if (!isInit && this.cacheValue.containsKey(var)) continue;
            this.cacheMapValue(this.billAlias, var);
        }
        return this.cacheValue;
    }

    private void cacheMapValue(String billAlias, String var) {
        DynamicProperty property;
        Object value;
        try {
            value = this.data.get(var);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(EngineLang.getHintBillFieldFail(billAlias, var));
        }
        if (value == null && (property = ((DynamicObjectType)this.data.getDataEntityType()).getProperty(var)) == null) {
            throw new KDBizException(var + " not exist!");
        }
        this.cacheValue.put(var, value);
    }

    public DynamicObject getData() {
        return this.data;
    }
}

