/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.RecordMapping;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.CollectionUtils;

public class WFRecordManager {
    private List<WriteOffRecordMapper> writeoffRecordMappers = new ArrayList<WriteOffRecordMapper>(16);

    public void addRecord(WriteOffRecordMapper writeOffRecordMapper) {
        this.writeoffRecordMappers.add(writeOffRecordMapper);
    }

    public Map<String, Map<String, List<Object[]>>> getGenerateWriteBackSql() {
        HashMap<String, Map<String, List<Object[]>>> sqlListMap = new HashMap<String, Map<String, List<Object[]>>>(8);
        for (WriteOffRecordMapper recordMapper : this.writeoffRecordMappers) {
            Map<String, Map<String, List<Object[]>>> wfWriteBackSql = recordMapper.getWfWriteBackSql();
            MapUtils.add(sqlListMap, wfWriteBackSql);
        }
        return sqlListMap;
    }

    public List<Map<String, Object>> getRecordKdtxParams(boolean isManualWriteOff) {
        ArrayList<Map<String, Object>> recordKdtxParams = new ArrayList<Map<String, Object>>(16);
        for (WriteOffRecordMapper recordMapper : this.writeoffRecordMappers) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            DynamicObject recordBill = recordMapper.getRecordBill();
            param.put("record", recordBill);
            HashMap<Long, WriteOffObjectBase> map = new HashMap<Long, WriteOffObjectBase>(16);
            List<RecordMapping> recordMappings = recordMapper.getRecordMappings();
            for (RecordMapping rm : recordMappings) {
                WriteOffObjectBase writeOffObject = rm.getWriteOffObject();
                map.put((Long)writeOffObject.getPkValue(), writeOffObject);
            }
            param.put("writeoffObjects", map);
            param.put("ismanual", isManualWriteOff);
            recordKdtxParams.add(param);
        }
        return recordKdtxParams;
    }

    public List<DynamicObject> getRecordObjs() {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(16);
        for (WriteOffRecordMapper recordMapper : this.writeoffRecordMappers) {
            objs.add(recordMapper.getRecordBill());
        }
        return objs;
    }

    public void updateRecordsRelation(WriteOffTypeConfig typeConfig, Map<String, Integer> seqMap) {
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != typeConfig.getWfRecordTemplateEnum() || CollectionUtils.isEmpty(this.writeoffRecordMappers)) {
            return;
        }
        String recordBillType = typeConfig.getRecordNum();
        HashMap orgToKeyToRecords = new HashMap(16);
        for (WriteOffRecordMapper writeOffRecordMapper : this.writeoffRecordMappers) {
            DynamicObject record = writeOffRecordMapper.getRecordBill();
            StringBuilder builder = new StringBuilder();
            DynamicObject org = record.getDynamicObject("org");
            String orgIdStr = org == null ? null : String.valueOf(org.getPkValue());
            builder.append(recordBillType).append(orgIdStr);
            DynamicObject billType = record.getDynamicObject("billtype");
            Long billId = record.getLong("billid");
            String number = billType == null ? "" : billType.getString("number");
            builder.append(number).append(billId);
            DynamicObjectCollection entryList = record.getDynamicObjectCollection("entry");
            if (CollectionUtils.isNotEmpty((Collection)entryList)) {
                DynamicObject billTypeEntry = ((DynamicObject)entryList.get(0)).getDynamicObject("e_billtype");
                Long billIdEntry = ((DynamicObject)entryList.get(0)).getLong("e_billid");
                builder.append(billTypeEntry.getString("number")).append(billIdEntry);
            }
            String key = builder.toString();
            Integer seq = seqMap.get(builder.toString());
            if (seq == null) {
                Map keyToRecords = MapUtils.mapGetMapValue(orgToKeyToRecords, orgIdStr);
                MapUtils.mapGetListValue(keyToRecords, key).add(record);
                continue;
            }
            record.set("verifyseq", (Object)seq);
        }
        if (!orgToKeyToRecords.isEmpty()) {
            for (Map.Entry entry : orgToKeyToRecords.entrySet()) {
                String orgIdStr = (String)entry.getKey();
                Map keyToRecords = (Map)entry.getValue();
                List<Integer> batchGetArApSeq = WriteSeqHelper.batchGetArApSeq(recordBillType, orgIdStr, keyToRecords.size());
                Iterator<Integer> seqIterator = batchGetArApSeq.iterator();
                for (Map.Entry keyToRecordEntry : keyToRecords.entrySet()) {
                    String key = (String)keyToRecordEntry.getKey();
                    if (!seqIterator.hasNext()) {
                        // empty if block
                    }
                    Integer arApSeq = seqIterator.next();
                    seqMap.put(key, arApSeq);
                    for (DynamicObject record : (List)keyToRecordEntry.getValue()) {
                        record.set("verifyseq", (Object)arApSeq);
                    }
                }
            }
        }
    }

    public List<WriteOffRecordMapper> getWriteoffRecordMappers() {
        return this.writeoffRecordMappers;
    }

    public boolean isEmpty() {
        return this.writeoffRecordMappers.isEmpty();
    }
}

