/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnFunctionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.IWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.ConditionHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public abstract class AbstractWriteOffRecordStrategy
implements IWriteOffRecordStrategy {
    private static final String CUR_DATA = "curdata";
    private WriteOffTypeConfig typeConfig;
    private WriteOffExecuteContext executeContext;
    private SchemeContextConfig schemeContextConfig;

    @Override
    public WriteOffRecordMapper generate(WriteOffTypeConfig typeConfig, List<IWriteOffQueue> writeOffQueues, String writeDetail) {
        String recordBillType = typeConfig.getRecordNum();
        String recordEntryType = typeConfig.getRecordEntryType();
        DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)recordBillType);
        WriteOffRecordMapper recordMapping = this.generateRecordEntries(recordEntryType, recordBill, writeOffQueues);
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != typeConfig.getWfRecordTemplateEnum()) {
            this.setBillHeadColumns(recordBill);
        }
        DynamicObjectUtil.setBillId(recordBill, "entry");
        if (StringUtils.isEmpty((String)writeDetail)) {
            writeDetail = JSONObject.toJSONString((Object)new BackWriteOffDetail());
        }
        recordBill.set("headwfinfo_tag", (Object)writeDetail);
        String seq = this.buidSeq(recordBillType, recordBill, typeConfig.getWfRecordTemplateEnum());
        recordBill.set("wfnumber", (Object)seq);
        recordMapping.setRecordBill(recordBill);
        WriteOffPluginProxy iWriteOffPluginProxy = this.getExecuteContext().getPluginFactory().createWriteOffPluginProxy(typeConfig);
        iWriteOffPluginProxy.setSchemeContextConfig(this.schemeContextConfig);
        iWriteOffPluginProxy.beforeWfRecordGenerate(recordMapping);
        return recordMapping;
    }

    private String buidSeq(String recordBillType, DynamicObject recordBill, WriteoffTemplateTypeEnum templateTypeEnum) {
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == templateTypeEnum) {
            return String.valueOf(recordBill.getPkValue());
        }
        String seq = WriteSeqHelper.getSeq(recordBillType);
        if (StringUtils.isEmpty((String)seq)) {
            seq = String.valueOf(recordBill.getPkValue());
        }
        return seq;
    }

    abstract WriteOffRecordMapper generateRecordEntries(String var1, DynamicObject var2, List<IWriteOffQueue> var3);

    protected final void initWriteOffObject(WriteOffObjectBase wfobj, DynamicObject recordObj, String billIdField, String wfObjectIdField, String billEntityField, String billNoField) {
        Object billPkValue = wfobj.getWfBillPk();
        recordObj.set(billIdField, billPkValue);
        Object entryPkValue = wfobj.getPkValue();
        recordObj.set(wfObjectIdField, entryPkValue);
        DynamicObject bosEntity = wfobj.getWFBillEntityObj();
        recordObj.set(billEntityField, (Object)bosEntity);
        String billNo = wfobj.getWfBillBillNo();
        recordObj.set(billNoField, (Object)billNo);
    }

    protected void setEntryColumns(WriteOffObjectBase writeOffObject, DynamicObject entry) {
        if (writeOffObject == null) {
            return;
        }
        WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
        List<RecordColumnConfig> recordColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordEntryColumnConfigs();
        this.setEntryColumn(writeOffObject, entry, recordColumnConfigs);
    }

    protected void setBillHeadMappingColumns(WriteOffObjectBase writeOffObject, DynamicObject recordBill) {
        if (writeOffObject != null) {
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
            List<RecordColumnConfig> recordHeadColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordHeadColumnConfigs();
            for (RecordColumnConfig columnConfig : recordHeadColumnConfigs) {
                String targetColumn = columnConfig.getTargetColumn();
                String sourceColumn = columnConfig.getSourceColumn();
                if ("1".equals(columnConfig.getSelectValue())) {
                    this.setByExpression(writeOffObject, recordBill, targetColumn, columnConfig);
                    continue;
                }
                BillFieldInfoManager billFieldInfo = this.getExecuteContext().getBillFieldInfo();
                Object value = billFieldInfo.getObjWithTransDO(writeOffObject, sourceColumn);
                recordBill.set(targetColumn, value);
            }
        }
    }

    protected final void setEntryColumn(WriteOffObjectBase writeOffObject, DynamicObject recordEntry, List<RecordColumnConfig> recordColumnConfigs) {
        for (RecordColumnConfig recordColumnConfig : recordColumnConfigs) {
            String targetColumn = recordColumnConfig.getTargetColumn().split("\\.")[1];
            String sourceColumn = recordColumnConfig.getSourceColumn();
            if ("1".equals(recordColumnConfig.getSelectValue())) {
                this.setByExpression(writeOffObject, recordEntry, targetColumn, recordColumnConfig);
                continue;
            }
            boolean isLastWhole = this.getSchemeContextConfig().isLastWhole();
            if (writeOffObject.getWriteOffValues().containsKey(sourceColumn)) {
                BigDecimal bigDecimal = writeOffObject.getWriteOffValues().get(sourceColumn);
                recordEntry.set(targetColumn, (Object)bigDecimal);
                continue;
            }
            if ("e_verifyqty".equals(targetColumn) && isLastWhole) {
                recordEntry.set(targetColumn, (Object)writeOffObject.getWriteOffNumber());
                continue;
            }
            BillFieldInfoManager billFieldInfo = this.getExecuteContext().getBillFieldInfo();
            Object value = billFieldInfo.getObjWithTransDO(writeOffObject, sourceColumn);
            recordEntry.set(targetColumn, value);
        }
    }

    protected void setByExpression(WriteOffObjectBase writeOffObject, DynamicObject entry, String targetColumn, RecordColumnConfig recordColumnConfig) {
        AmountProp amountProp;
        String controlPropName;
        DynamicObject amount;
        RecordColumnFunctionConfig fucntionConfig = recordColumnConfig.getFucntionConfig();
        BOSExpression function = fucntionConfig.getBosExpression();
        Expr expr = fucntionConfig.getExpr();
        HashMap<String, BigDecimal> exprParams = new HashMap<String, BigDecimal>(16);
        BigDecimal writeOffNumber = writeOffObject.getWriteOffNumber();
        exprParams.put(CUR_DATA, writeOffNumber);
        HashMap<String, BigDecimal> wfNumberParam = new HashMap<String, BigDecimal>(writeOffObject.getWriteOffValues());
        wfNumberParam.putAll(writeOffObject.getWriteOffValues());
        wfNumberParam.put(writeOffObject.getPrimaryColumn(), writeOffNumber);
        for (Map.Entry<String, String> paramNameEntry : fucntionConfig.getParamFullKey().entrySet()) {
            String paramColumn = paramNameEntry.getKey();
            String paramColumnFullKey = paramNameEntry.getValue();
            Object result = wfNumberParam.get(paramColumnFullKey);
            if (result == null) {
                result = writeOffObject.getValue(paramColumn);
            }
            exprParams.put(paramColumn, (BigDecimal)result);
        }
        exprParams.putAll(wfNumberParam);
        BOSExpressionContext expContext = new BOSExpressionContext(null);
        BOSUDFunction[] udFunctions = ConditionHelper.createUdFunctions(function, (ExpressionContext)expContext);
        Object result = FormulaEngine.execExcelFormula((Expr)expr, exprParams, (UDFunction[])udFunctions);
        if (!(result instanceof BigDecimal)) {
            entry.set(targetColumn, result);
            return;
        }
        BigDecimal resultBig = (BigDecimal)result;
        Integer precision = 10;
        Integer preciSionAccount = 1;
        RowDataModel rowDataModel = CommonUtils.getBillEntry(entry);
        IDataEntityProperty property = recordColumnConfig.getTgtProp();
        if (property instanceof QtyProp) {
            QtyProp qtyProp = (QtyProp)property;
            String relatedUnit = qtyProp.getControlPropName();
            DynamicObject unit = (DynamicObject)rowDataModel.getValue(relatedUnit);
            if (unit != null) {
                precision = unit.getInt("precision");
                preciSionAccount = unit.getInt("precisionaccount");
            }
        } else if (property instanceof AmountProp && (amount = (DynamicObject)rowDataModel.getValue(controlPropName = (amountProp = (AmountProp)property).getControlPropName())) != null) {
            precision = amount.getInt("amtprecision");
        }
        BigDecimal newAssistValue = BigDecimal.ZERO;
        newAssistValue = preciSionAccount == 1 ? resultBig.setScale((int)precision, RoundingMode.HALF_UP) : (preciSionAccount == 2 ? resultBig.setScale((int)precision, RoundingMode.DOWN) : (preciSionAccount == 3 ? resultBig.setScale((int)precision, RoundingMode.UP) : resultBig.setScale((int)precision, RoundingMode.UP)));
        entry.set(targetColumn, (Object)newAssistValue);
    }

    private void setBillHeadColumns(DynamicObject recordBill) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        recordBill.set("wfseq", (Object)this.executeContext.getSeq());
        recordBill.set("createtime", (Object)this.schemeContextConfig.getWriteOffDate());
        recordBill.set("createdate", (Object)new Date());
        recordBill.set("creator", (Object)currentUserId);
        recordBill.set("writeofftypeid", (Object)this.typeConfig.getObj());
        recordBill.set("wfscheme", (Object)this.schemeContextConfig.getSchemeId());
        recordBill.set("billstatus", (Object)"C");
    }

    protected final RecordMappingConfig getBillWfMapping(WriteOffBillConfig writeOffBillConfig) {
        RecordMappingConfig configById = this.executeContext.getConfigManager().getMappingConfigById(writeOffBillConfig.getWfMappingId());
        if (configById == null) {
            throw new KDBizException(EngineLang.wfMappingFail(writeOffBillConfig.getWfMappingNumber()));
        }
        return configById;
    }

    protected final WriteOffBillConfig getBillConfig(WriteOffObjectBase writeOffObject) {
        return this.getTypeConfig().getBillConfigsById((Long)writeOffObject.getWfBillEntity().getPkValue());
    }

    protected final WriteOffTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public void setTypeConfig(WriteOffTypeConfig typeConfig) {
        this.typeConfig = typeConfig;
    }

    protected final WriteOffExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    public void setExecuteContext(WriteOffExecuteContext executeContext) {
        this.executeContext = executeContext;
    }

    protected final SchemeContextConfig getSchemeContextConfig() {
        return this.schemeContextConfig;
    }

    public void setSchemeContextConfig(SchemeContextConfig schemeContextConfig) {
        this.schemeContextConfig = schemeContextConfig;
    }
}

