/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;

public class DataTable {
    private final String[] dimKeys;
    private final Map<Long, Object[]> dataInfo = new LinkedHashMap<Long, Object[]>(16);

    private DataTable(String[] dimKeys) {
        this.dimKeys = dimKeys;
    }

    public static DataTable create(String ... dimKeys) {
        return new DataTable(dimKeys);
    }

    public void addData(Long lineId, Map<String, Object> valeuMap) {
        Object[] data = this.dataInfo.get(lineId);
        if (data == null) {
            data = new Object[this.dimKeys.length];
            this.dataInfo.put(lineId, data);
        }
        for (Map.Entry<String, Object> valueMapEntry : valeuMap.entrySet()) {
            int dimIndex = this.getDimIndex(valueMapEntry.getKey());
            if (dimIndex == -1) continue;
            data[dimIndex] = this.specialDeal(valueMapEntry.getValue());
        }
    }

    private Object specialDeal(Object data) {
        if (data instanceof DynamicObject) {
            return MatcherUtil.getDynamicOjbectId((DynamicObject)data);
        }
        return data;
    }

    public void addData(Long lineId, String dimKey, Object value) {
        this.addData(lineId, Collections.singletonMap(dimKey, value));
    }

    public Object getData(Long lineId, String key) {
        Object[] line = this.dataInfo.get(lineId);
        int dimIndex = this.getDimIndex(key);
        if (line == null || dimIndex == -1) {
            return null;
        }
        Object data = line[dimIndex];
        return data;
    }

    public List<Object> getDimValues(String key, BiConsumer<Object, List<Object>> valueMapFunc) {
        int dimIndex = this.getDimIndex(key);
        if (dimIndex == -1) {
            return Collections.emptyList();
        }
        ArrayList<Object> allValues = new ArrayList<Object>(this.dataInfo.size());
        for (Object[] dataLine : this.dataInfo.values()) {
            Object data = dataLine[dimIndex];
            if (valueMapFunc != null) {
                valueMapFunc.accept(data, allValues);
                continue;
            }
            allValues.add(data);
        }
        return allValues;
    }

    public List<Object> getDimValues(String key) {
        return this.getDimValues(key, null);
    }

    public Map<String, Object> getLineValue(Long lineId) {
        Object[] dataLine = this.dataInfo.get(lineId);
        if (dataLine == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> lineMap = new HashMap<String, Object>(this.dimKeys.length);
        for (int i = 0; i < this.dimKeys.length; ++i) {
            String dimkey = this.dimKeys[i];
            Object data = dataLine[i];
            lineMap.put(dimkey, data);
        }
        return lineMap;
    }

    private int getDimIndex(String field) {
        for (int i = 0; i < this.dimKeys.length; ++i) {
            if (!field.equals(this.dimKeys[i])) continue;
            return i;
        }
        return -1;
    }

    public String[] getDimKeys() {
        return this.dimKeys;
    }

    public Map<Long, Object[]> getDataInfo() {
        return this.dataInfo;
    }

    public String toString() {
        return SerializationUtils.toJsonString(this.dataInfo);
    }
}

