/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffBillGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class WriteOffManualGroup
extends WriteOffBillGroup {
    private SchemeConfig schemeConfig;
    private List<IWFFilter> filter;
    private int maxHandleBillSize = 5000;
    private BillDataSource billDataSource;
    private Map<Object, BigDecimal> curMainFieldValueMap = null;

    public static WriteOffManualGroup build(WriteOffTypeConfig typeConfig, WriteOffBillConfig billConfig, SchemeConfig schemeConfig, BillDataSource billDataSource) {
        WriteOffManualGroup writeOffGroup = new WriteOffManualGroup(typeConfig, billConfig);
        writeOffGroup.setSchemeConfig(schemeConfig);
        writeOffGroup.setBillDataSource(billDataSource);
        return writeOffGroup;
    }

    public WriteOffManualGroup(WriteOffTypeConfig typeConfig, WriteOffBillConfig billTypeConfig) {
        super(typeConfig, billTypeConfig);
    }

    public SchemeConfig getSchemeConfig() {
        return this.schemeConfig;
    }

    private void setSchemeConfig(SchemeConfig schemeConfig) {
        this.schemeConfig = schemeConfig;
    }

    public List<IWFFilter> getFilter() {
        return this.filter;
    }

    public void setFilter(List<IWFFilter> billFilter, int maxHandleSize) {
        this.filter = billFilter;
        this.maxHandleBillSize = maxHandleSize;
    }

    public void initWriteOffObject(Boolean isSingle) {
        WriteOffBillConfig billTypeConfig = this.getBillTypeConfig();
        if (!this.getWriteOffObjects().isEmpty() || billTypeConfig.getWriteOffColumnConfig() == null) {
            return;
        }
        String entityName = billTypeConfig.getBillType();
        String wfCalcFieldIdName = billTypeConfig.getWfCalcFieldIdName();
        String selectField = "id" + ("id".equals(wfCalcFieldIdName) ? "" : "," + wfCalcFieldIdName);
        HashSet<Object> ids = new HashSet<Object>(128);
        HashSet<Object> wfMainKey = new HashSet<Object>(128);
        try (DataSet idDataSet = QueryServiceHelper.queryDataSet((String)"manualGroup", (String)entityName, (String)selectField, (QFilter[])IWFFilter.toQFilters(this.filter), (String)"");){
            for (Row row : idDataSet) {
                ids.add(row.get("id"));
                wfMainKey.add(row.get(wfCalcFieldIdName));
            }
        }
        if (wfMainKey.isEmpty() && !isSingle.booleanValue()) {
            throw new KDBizException(EngineLang.mainBillNotExist());
        }
        if (wfMainKey.size() >= this.maxHandleBillSize) {
            throw new KDBizException(EngineLang.overMaxHandleBillSize(this.maxHandleBillSize));
        }
        WFSnapshotContext snapshotContext = new WFSnapshotContext(this.getTypeConfig());
        snapshotContext.loadSnapShootMap(new ArrayList<Object>(ids), entityName);
        QFilter queryFilter = new QFilter("id", "in", ids);
        queryFilter.and(wfCalcFieldIdName, "in", wfMainKey);
        DynamicObjectCollection billDynamics = this.billDataSource.queryBillData(entityName, this.getBillTypeConfig().getMainFieldEntry(), queryFilter);
        ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>(16);
        for (DynamicObject billDynamic : billDynamics) {
            List<WriteOffObject> writeOffObjectList = WriteOffGroupHelper.buildWriteOffObjects(this.getTypeConfig(), billTypeConfig, billDynamic, snapshotContext);
            for (WriteOffObject writeOffObject : writeOffObjectList) {
                if (!wfMainKey.contains(writeOffObject.getWriteOffObjectPk()) || writeOffObject.isCurWriteOffZero() || writeOffObject.isWfComplete() || writeOffObject.getWriteOffNumber().compareTo(BigDecimal.ZERO) == 0) continue;
                if (this.curMainFieldValueMap != null) {
                    Object pk = writeOffObject.getWriteOffObjectBase().getPkValue();
                    BigDecimal curMainFieldValue = this.curMainFieldValueMap.get(pk);
                    if (curMainFieldValue == null || BigDecimal.ZERO.compareTo(curMainFieldValue) == 0) continue;
                    WriteOffObjectManager.setManualInitLogicWriteOffNumber(writeOffObject.getWriteOffObjectBase(), curMainFieldValue);
                    writeOffObjects.add(writeOffObject);
                    continue;
                }
                if (!billTypeConfig.checkHighCondtion(writeOffObject)) continue;
                writeOffObjects.add(writeOffObject);
            }
        }
        this.getWriteOffObjects().clear();
        this.getWriteOffObjects().addAll(writeOffObjects);
    }

    public Map<Object, BigDecimal> getCurMainFieldValueMap() {
        return this.curMainFieldValueMap;
    }

    public void setCurMainFieldValueMap(Map<Object, BigDecimal> curMainFieldValueMap) {
        this.curMainFieldValueMap = curMainFieldValueMap;
    }

    public void setBillDataSource(BillDataSource billDataSource) {
        this.billDataSource = billDataSource;
    }
}

