/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.inspection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class SaloutBillVerifyInspectPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -6250134934540836083L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billentry.id");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> billentryIds = new HashSet<Long>(16);
        while (args.hasNext()) {
            Row billIEntrynfo = args.next();
            Long billid = billIEntrynfo.getLong("id");
            Long billentryid = billIEntrynfo.getLong("billentry.id");
            billIds.add(billid);
            billentryIds.add(billentryid);
        }
        return this.check(billIds, billentryIds);
    }

    private List<OperateErrorInfo> check(Set<Long> billIds, Set<Long> entryIds) {
        String billentity = "im_saloutbill";
        DataSet billInfos = this.buildBillDataSet(entryIds, billentity);
        DataSet recordInfos = this.buildSalWfRecordDataSet(billIds, entryIds);
        DataSet resultDataSet = billInfos.leftJoin(recordInfos).on("billentry.id", "billentryid").select(billInfos.getRowMeta().getFieldNames(), new String[]{"verifyqty", "verifybaseqty"}).finish();
        resultDataSet = resultDataSet.filter("billverifyqty <> verifyqty");
        ArrayList<OperateErrorInfo> erroInfos = new ArrayList<OperateErrorInfo>(16);
        for (Row row : resultDataSet) {
            BigDecimal wfQty = row.getBigDecimal("billverifyqty");
            BigDecimal verifyqty = row.getBigDecimal("verifyqty");
            String erroInfo = null;
            if (verifyqty == null) {
                if (BigDecimal.ZERO.compareTo(wfQty) == 0) continue;
                erroInfo = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u7684\u201c\u5df2\u6838\u9500\u6570\u91cf\u201d\u4e3a{1}\u3001\u201c\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u201d\u4e3a{2}\uff0c\u7cfb\u7edf\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u6838\u9500\u8bb0\u5f55\u3002", (String)"MSCOMMON-B-615844", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{row.get("seq"), row.get("billverifyqty"), row.get("billverifybaseqty"), row.get("verifyqty"), row.get("verifybaseqty")});
            } else {
                erroInfo = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u5df2\u6838\u9500\u6570\u91cf\u201d\u4e3a{1}\u3001\u201c\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u201d\u4e3a{2}\uff0c\u6838\u9500\u8bb0\u5f55\u5bf9\u5e94\u201c\u6838\u9500\u6570\u91cf\u201d\u4e3a{3}\u3001\u201c\u6838\u9500\u57fa\u672c\u6570\u91cf\u201d\u4e3a{4}\u3002", (String)"MSCOMMON-B-355307", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{row.get("seq"), row.get("billverifyqty"), row.get("billverifybaseqty"), row.get("verifyqty"), row.get("verifybaseqty")});
            }
            erroInfos.add(this.getExpMsg(((Object)((Object)this)).getClass().getSimpleName(), erroInfo, row.get("id"), row.get("billentry.id"), row.getString("billno")));
        }
        return erroInfos;
    }

    private DataSet buildBillDataSet(Set<Long> entryIds, String billentity) {
        return QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryBillData", (String)billentity, (String)"id,billno,billentry.id, billentry.seq as seq, billentry.verifyqty as billverifyqty, billentry.verifybaseqty as billverifybaseqty,billentry.unverifyqty as billunverifyqty,billentry.unverifybaseqty as billunverifybaseqty", (QFilter[])new QFilter("billentry.id", "in", entryIds).toArray(), null);
    }

    private DataSet buildSalWfRecordDataSet(Set<Long> billIds, Set<Long> entryIds) {
        String recordEntity = "cal_salwfrecord";
        String billIdKey = "billid";
        String entryIdKey = "billentryid";
        DataSet recordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryRecordData", (String)recordEntity, (String)"id as wfrecordid, billentryid as entryid, verifyqty as verifyqty, verifybaseqty as verifybaseqty", (QFilter[])new QFilter(entryIdKey, "in", entryIds).and(billIdKey, "in", billIds).toArray(), null);
        DataSet subRecordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.querySubRecordData", (String)recordEntity, (String)"id as wfrecordid, entry.e_billentryid as entryid , entry.e_verifyqty as verifyqty, entry.e_verifybaseqty as verifybaseqty", (QFilter[])new QFilter("entry.e_billentryid", "in", entryIds).and("entry.e_billid", "in", billIds).toArray(), null);
        recordInfos = recordInfos.union(subRecordInfos);
        return recordInfos.groupBy(new String[]{"entryid"}).sum("verifyqty").sum("verifybaseqty").finish().select("entryid as billentryid, verifyqty, verifybaseqty");
    }

    public List<FixLogInfo> fixMainDataSet(DataSet args) {
        return super.fixMainDataSet(args);
    }
}

