/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.inspection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import org.apache.commons.collections.CollectionUtils;

public class WfErrorLogInspectPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -5308506681717058274L;
    public static final Log logger = LogFactory.getLog(WfErrorLogInspectPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "srcbillentity", "srcbillid_tag", "operate", "wfseq", "errortype", "wfmode");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        logger.info("\u5f00\u59cb\u5de1\u68c0");
        List operateErrorInfos = super.exeInspectUnitExtPlugin(args);
        ArrayList<Object> successIds = new ArrayList<Object>(16);
        HashSet<String> logs = new HashSet<String>(16);
        while (args.hasNext()) {
            Row log = args.next();
            String srcBillEntity = log.getString("srcbillentity");
            String billId = log.getString("srcbillid_tag");
            String operate = log.getString("operate");
            String wfseq = log.getString("wfseq");
            String errortype = log.getString("errortype");
            String wfmode = log.getString("wfmode");
            String logId = log.getString("id");
            String[] ids = billId.split(",");
            if (!"F".equals(wfmode) || StringUtils.isEmpty((CharSequence)errortype)) continue;
            ArrayList<Object> idList = new ArrayList<Object>(16);
            for (String id : ids) {
                String key = id + operate;
                if (!logs.add(key)) continue;
                idList.add(Long.valueOf(id));
            }
            this.doStartWriteOff(operateErrorInfos, successIds, srcBillEntity, operate, wfseq, logId, idList);
        }
        if (CollectionUtils.isEmpty(successIds)) {
            return operateErrorInfos;
        }
        String sql = "update t_msmod_wfnlog set ferrortype = 'R' where fid in (" + WfErrorLogInspectPlugin.collectionToStr(successIds) + ")";
        DB.execute((DBRoute)new DBRoute("scm"), (String)sql);
        return operateErrorInfos;
    }

    private void doStartWriteOff(List<OperateErrorInfo> operateErrorInfos, List<Object> successIds, String srcBillEntity, String operate, String wfseq, String logId, List<Object> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startWriteOff", (Object[])new Object[]{idList, srcBillEntity, operate});
                successIds.add(logId);
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u91cd\u8bd5\u6838\u9500\u5931\u8d25", (Throwable)e);
                txHandle.markRollback();
                operateErrorInfos.add(this.getExpMsg(((Object)((Object)this)).getClass().getSimpleName(), e.getMessage(), logId, logId, wfseq));
            }
        }
    }

    private static String collectionToStr(Collection<Object> list) {
        StringBuilder str = new StringBuilder();
        for (Object object : list) {
            str.append('\'');
            str.append(object);
            str.append('\'');
            str.append(',');
        }
        String string = str.toString();
        return string.substring(0, string.length() - 1);
    }
}

