/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.sort.WriteOffComparator;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.IQueueSortable;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffObjectQueue
implements IQueueSortable {
    private LinkedList<WriteOffObjectBase> candidates = new LinkedList();
    private List<BillSortConfig> sortConfigs;
    private SchemeContextConfig schemeContextConfig;
    private WriteOffBillConfig billConfig;

    public WriteOffObjectQueue() {
    }

    public WriteOffObjectQueue(List<BillSortConfig> sortConfigs, SchemeContextConfig schemeContextConfig, WriteOffBillConfig billConfig) {
        this.sortConfigs = sortConfigs;
        this.schemeContextConfig = schemeContextConfig;
        this.billConfig = billConfig;
    }

    @Override
    public boolean isEmpty() {
        return this.candidates.isEmpty();
    }

    @Override
    public void sort() {
        List sortList = null;
        if (this.candidates.size() > 0) {
            String billTypeKey = this.billConfig.getBillAlias();
            sortList = this.sortConfigs.stream().filter(n -> n.getSortBillTypeKey().equals(billTypeKey)).collect(Collectors.toList());
        }
        if (sortList != null && sortList.size() > 0) {
            Comparator<WriteOffObjectBase> writeOffComparator = new WriteOffComparator((BillSortConfig)sortList.get(0));
            for (int i = 1; i < sortList.size(); ++i) {
                writeOffComparator = writeOffComparator.thenComparing(new WriteOffComparator((BillSortConfig)sortList.get(i)));
            }
            this.candidates.sort(writeOffComparator);
        }
    }

    @Override
    public int size() {
        return this.candidates.size();
    }

    @Override
    public BigDecimal getSumWriteOffNumber() {
        BigDecimal sum = BigDecimal.ZERO;
        for (WriteOffObjectBase candidate : this.candidates) {
            if (candidate.getWhole().booleanValue() && this.schemeContextConfig.isWhole()) {
                return BigDecimal.valueOf(Integer.MAX_VALUE);
            }
            sum = sum.add(WriteOffObjectManager.getLogicWriteOffNumber(candidate));
        }
        return sum;
    }

    @Override
    public void add(WriteOffObjectBase writeOffObject) {
        this.candidates.add(writeOffObject);
    }

    @Override
    public void addAll(Collection<? extends WriteOffObjectBase> writeOffObjects) {
        this.candidates.addAll(writeOffObjects);
    }

    @Override
    public synchronized void update(WriteOffObjectBase writeOffObject) {
        int index = this.candidates.indexOf(writeOffObject);
        this.candidates.remove(writeOffObject);
        this.candidates.add(index, writeOffObject);
    }

    @Override
    public WriteOffObjectBase peek() {
        return this.candidates.peek();
    }

    @Override
    public WriteOffObjectBase poll() {
        WriteOffObjectBase candidate = this.candidates.poll();
        if (candidate != null && candidate.getWriteOffObject() != null) {
            candidate.setWfComplete(true);
        }
        return candidate;
    }

    @Override
    public List<WriteOffObjectBase> pollAll() {
        ArrayList<WriteOffObjectBase> objects = new ArrayList<WriteOffObjectBase>(16);
        while (this.size() > 0) {
            WriteOffObjectBase planWriteOffObject = this.poll();
            objects.add(planWriteOffObject);
            planWriteOffObject.setWfComplete(true);
        }
        return objects;
    }

    @Override
    public List<WriteOffObjectBase> peekAll() {
        return this.candidates;
    }

    @Override
    public WriteOffObjectBase peekRedObject() {
        for (WriteOffObjectBase candidate : this.candidates) {
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(BigDecimal.ZERO) >= 0) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public WriteOffObjectBase pollRedObject() {
        int index;
        WriteOffObjectBase writeOffObject = null;
        for (index = 0; index < this.candidates.size(); ++index) {
            WriteOffObjectBase candidate = this.candidates.get(index);
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(BigDecimal.ZERO) >= 0) continue;
            writeOffObject = candidate;
            break;
        }
        if (writeOffObject != null) {
            this.candidates.remove(index);
        }
        return writeOffObject;
    }

    @Override
    public WriteOffObjectBase peekBlueObject() {
        for (WriteOffObjectBase candidate : this.candidates) {
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(BigDecimal.ZERO) <= 0) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public WriteOffObjectBase pollBlueObject() {
        int index;
        WriteOffObjectBase writeOffObject = null;
        for (index = 0; index < this.candidates.size(); ++index) {
            WriteOffObjectBase candidate = this.candidates.get(index);
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(BigDecimal.ZERO) <= 0) continue;
            writeOffObject = candidate;
            break;
        }
        if (writeOffObject != null) {
            this.candidates.remove(index);
        }
        return writeOffObject;
    }

    @Override
    public WriteOffObjectBase peekEquals(BigDecimal value) {
        for (WriteOffObjectBase candidate : this.candidates) {
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(value) != 0) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public WriteOffObjectBase pollEquals(BigDecimal value) {
        int index;
        WriteOffObjectBase writeOffObject = null;
        for (index = 0; index < this.candidates.size(); ++index) {
            WriteOffObjectBase candidate = this.candidates.get(index);
            if (WriteOffObjectManager.getLogicWriteOffNumber(candidate).compareTo(value) != 0) continue;
            writeOffObject = candidate;
            break;
        }
        if (writeOffObject != null) {
            this.candidates.remove(index);
        }
        return writeOffObject;
    }

    @Override
    public IWriteOffQueue pollQueue(boolean isWhole, BigDecimal needWriteOffNumber) {
        if (isWhole) {
            return this.pollQueueAll();
        }
        return this.pollQueue(needWriteOffNumber);
    }

    @Override
    public void pollQueueByCount(IWriteOffQueue writeOffQueue, BigDecimal minWriteOffNumber) {
        if (this.size() > 0) {
            WriteOffObjectBase writeOffObject = this.peek();
            BigDecimal queueHeadWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject);
            int compare = minWriteOffNumber.abs().compareTo(queueHeadWriteOffNumber.abs());
            if (compare == 0) {
                WriteOffObjectBase planWriteOffObject = this.poll();
                planWriteOffObject.setWfComplete(true);
                writeOffQueue.add(planWriteOffObject);
            } else if (compare < 0) {
                WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
                BigDecimal returnWriteOffNumber = queueHeadWriteOffNumber.subtract(minWriteOffNumber);
                WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, minWriteOffNumber);
                writeOffQueue.add(planWriteOffObject);
                WriteOffObjectManager.setLogicWriteOffNumberNotAss(writeOffObject, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
                this.update(writeOffObject);
            }
        }
    }

    public IWriteOffQueue pollQueue(BigDecimal needWriteOffNumber) {
        WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), this.schemeContextConfig, null);
        BigDecimal sumPolledNumber = BigDecimal.ZERO;
        while (this.size() > 0) {
            WriteOffObjectBase writeOffObject = this.peek();
            BigDecimal allowWriteOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject);
            if (sumPolledNumber.add(allowWriteOffNumber).abs().compareTo(needWriteOffNumber.abs()) <= 0) {
                WriteOffObjectBase planWriteOffObject = this.poll();
                writeOffQueue.add(planWriteOffObject);
                sumPolledNumber = sumPolledNumber.add(allowWriteOffNumber);
                planWriteOffObject.setWfComplete(true);
                continue;
            }
            if (sumPolledNumber.abs().compareTo(needWriteOffNumber.abs()) == 0) break;
            BigDecimal planWriteOffNumber = needWriteOffNumber.subtract(sumPolledNumber);
            BigDecimal returnWriteOffNumber = allowWriteOffNumber.subtract(planWriteOffNumber);
            WriteOffObjectBase planWriteOffObject = writeOffObject.clone();
            WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
            writeOffQueue.add(planWriteOffObject);
            WriteOffObjectManager.setLogicWriteOffNumberNotAss(writeOffObject, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
            this.update(writeOffObject);
            break;
        }
        return writeOffQueue;
    }

    private IWriteOffQueue pollQueueAll() {
        WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), this.schemeContextConfig, null);
        while (this.size() > 0) {
            WriteOffObjectBase planWriteOffObject = this.poll();
            writeOffQueue.add(planWriteOffObject);
            planWriteOffObject.setWfComplete(true);
        }
        return writeOffQueue;
    }

    @Override
    public void sortByWhole() {
        this.candidates.sort(Comparator.comparing(WriteOffObjectBase::getWhole));
    }

    @Override
    public void lastWholeAdd(WriteOffObjectBase writeOffObjectBase) {
        WriteOffObjectBase queueWriteOffObject = this.peek();
        if (queueWriteOffObject != null && queueWriteOffObject.getPkValue().equals(writeOffObjectBase.getPkValue())) {
            BigDecimal countWriteOffNumber = writeOffObjectBase.getWriteOffNumber().add(queueWriteOffObject.getWriteOffNumber());
            writeOffObjectBase.setWriteOffNumber(countWriteOffNumber);
            this.poll();
        }
        this.candidates.add(0, writeOffObjectBase);
    }

    @Override
    public void manualLastWholeQueue(boolean isMain) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            WriteOffObjectBase writeOffObject = this.candidates.poll();
            if (isMain || i == size - 1) {
                writeOffObject.setWhole(true);
            } else {
                writeOffObject.setWhole(false);
            }
            this.candidates.add(size - 1, writeOffObject);
        }
    }

    @Override
    public IWriteOffQueue deepClone() {
        IWriteOffQueue writeOffQueue = this.simpleClone();
        for (WriteOffObjectBase writeOffObjectBase : this.candidates) {
            writeOffQueue.add(writeOffObjectBase.clone());
        }
        return writeOffQueue;
    }

    @Override
    public IWriteOffQueue simpleClone() {
        WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue(this.sortConfigs, this.schemeContextConfig, this.billConfig);
        return writeOffQueue;
    }

    public String toString() {
        ArrayList<String> strs = new ArrayList<String>();
        for (WriteOffObjectBase wfObjectBase : this.candidates) {
            strs.add(String.format("%s#%s#%s", wfObjectBase.getWFBillEntityType().getAlias(), wfObjectBase.getPkValue(), wfObjectBase.getWriteOffNumber()));
        }
        return String.join((CharSequence)",", strs);
    }
}

