/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.BotpGenerator;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AuotBillGenResult;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AutoBillWriteOffGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AutoGenBillObj;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.AbstractMergeSplitHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.IAutoBillHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.SplitByWriteOffQueueHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.common.util.BotpLinkHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public abstract class AbstractNewWriteOffStrategy
extends AbstractWriteOffStrategy {
    @Override
    public void batchExecute(SchemeContextConfig schemeContextConfig, List<WriteOffQueueGroup> allCandidateQueues) {
        WriteOffTypeConfig typeConfig = this.getTypeConfig();
        logger.info("\u6838\u9500\u7c7b\u522b\u3010" + typeConfig.getName() + "\u3011\u5f00\u59cb\u6267\u884c" + this.getClass().getSimpleName() + "\u6838\u9500\u7b56\u7565\u903b\u8f91\u3002");
        ArrayList<WriteOffQueueGroup> allQueues = new ArrayList<WriteOffQueueGroup>(16);
        for (WriteOffQueueGroup queueGroup : allCandidateQueues) {
            List<IWriteOffQueue> writeOffQueues;
            List<IWriteOffQueue> candidateQueues = queueGroup.getCandidateQueues();
            if (this.isCompleted(candidateQueues) || CollectionUtils.isEmpty(writeOffQueues = this.pickWriteOffObjects(schemeContextConfig, candidateQueues))) continue;
            List<WriteOffQueueGroup> writeOffQueueGroups = this.excuteRecordGroup(schemeContextConfig, writeOffQueues);
            allQueues.addAll(writeOffQueueGroups);
        }
        if (allQueues.isEmpty()) {
            logger.info("\u6838\u9500\u7c7b\u522b\u3010" + typeConfig.getName() + "\u3011\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u3002");
            return;
        }
        if (typeConfig.isNeedGenerate()) {
            this.generateBill(allQueues);
        }
        ArrayList<WriteOffRecordMapper> records = new ArrayList<WriteOffRecordMapper>(16);
        for (WriteOffQueueGroup writeOffQueueGroup : allQueues) {
            WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueueGroup, schemeContextConfig);
            records.add(recordBill);
        }
        this.handleRecords(schemeContextConfig, records);
        logger.info("\u6838\u9500\u7c7b\u522b\u3010" + typeConfig.getName() + "\u3011\u7ed3\u675f\u6267\u884c\u6838\u9500\u7b56\u7565\u903b\u8f91\u3002");
    }

    private List<WriteOffQueueGroup> excuteRecordGroup(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> writeOffQueues) {
        List<List<IWriteOffQueue>> wfRecordGroup = this.wfRecordGroup(schemeContextConfig, writeOffQueues);
        ArrayList<WriteOffQueueGroup> recordGroupedQueues = new ArrayList<WriteOffQueueGroup>(16);
        for (List<IWriteOffQueue> recordGrouped : wfRecordGroup) {
            WriteOffQueueGroup recordGroupedQueue = new WriteOffQueueGroup(null);
            recordGroupedQueue.createFromList(recordGrouped);
            recordGroupedQueues.add(recordGroupedQueue);
        }
        return recordGroupedQueues;
    }

    private void generateBill(List<WriteOffQueueGroup> allQueues) {
        HashMap wfBillIdToQueues = new HashMap(8);
        for (WriteOffQueueGroup writeOffQueueGroup : allQueues) {
            for (IWriteOffQueue writeOffQueue : writeOffQueueGroup.getCandidateQueues()) {
                if (writeOffQueue.isEmpty()) continue;
                List<WriteOffObjectBase> writeOffObjects = writeOffQueue.peekAll();
                Long wfBillEntityId = (Long)writeOffObjects.get(0).getWfBillEntity().getPkValue();
                MapUtils.mapGetListValue(wfBillIdToQueues, wfBillEntityId).addAll(writeOffObjects);
            }
        }
        for (Map.Entry entry : wfBillIdToQueues.entrySet()) {
            Long wfBillEntityId = (Long)entry.getKey();
            WriteOffBillConfig writeOffBillConfig = this.getTypeConfig().getBillConfigsById(wfBillEntityId);
            List<BillBotpConfig> billBotpConfigs = writeOffBillConfig.getBillBotpConfigs();
            if (billBotpConfigs.isEmpty()) continue;
            if (billBotpConfigs.size() != 1) {
                throw new KDBizException("botp config only support one!");
            }
            BillBotpConfig billBotpConfig = billBotpConfigs.get(0);
            List objs = (List)entry.getValue();
            BotpGenerator generator = BotpGenerator.create(this.getTypeConfig(), billBotpConfig);
            AuotBillGenResult autoBillResult = generator.generateAutoWriteOffObjects(objs);
            if (!autoBillResult.isSuccess()) {
                throw new KDBizException(autoBillResult.getFailMessage());
            }
            this.handleGenerateBills(allQueues, billBotpConfig, autoBillResult);
        }
    }

    private void handleGenerateBills(List<WriteOffQueueGroup> allQueues, BillBotpConfig billBotpConfig, AuotBillGenResult autoBillResult) {
        List<AutoBillWriteOffGroup> autoBillGroups = this.buildAutoBillWriteOffGroups(allQueues, billBotpConfig, autoBillResult);
        List<DynamicObject> bills = AutoBillWriteOffGroup.getAutoBillObjs(autoBillGroups);
        this.getSnapShootHolder().getAutoBillContext().addAutoBillObjs(bills);
        for (AutoBillWriteOffGroup queueGroup : autoBillGroups) {
            queueGroup.setAutoBillWBDetail();
        }
        if (billBotpConfig.getNeedGenerate().booleanValue()) {
            HashMap<Object, WriteOffObject> autoObjects = new HashMap<Object, WriteOffObject>(16);
            for (DynamicObject bill : bills) {
                List<WriteOffObject> autoWriteOffObjects = WriteOffGroupHelper.buildAutoWriteOffObjects(this.getTypeConfig(), billBotpConfig.getTgtBillConfig(), bill);
                for (WriteOffObject writeOffObject : autoWriteOffObjects) {
                    autoObjects.put(writeOffObject.getWriteOffObjectPk(), writeOffObject);
                }
            }
            for (AutoBillWriteOffGroup queueGroup : autoBillGroups) {
                ArrayList<WriteOffObject> autoWfObjs = new ArrayList<WriteOffObject>(16);
                for (AutoGenBillObj autoGenBillObj : queueGroup.getGenObjs()) {
                    Object pkValue = autoGenBillObj.getObj().getPkValue();
                    autoWfObjs.add((WriteOffObject)autoObjects.get(pkValue));
                }
                queueGroup.getQueueGroup().addAutoWriteOffQueue(autoWfObjs);
            }
        }
    }

    private List<AutoBillWriteOffGroup> buildAutoBillWriteOffGroups(List<WriteOffQueueGroup> allQueues, BillBotpConfig billBotpConfig, AuotBillGenResult autoBillResult) {
        ConvertRuleElement cre = ConvertRuleCache.loadRule((String)billBotpConfig.getBotpRule());
        String targetEntryKey = cre.getLinkEntityPolicy().getTargetEntryKey();
        List<DynamicObject> bills = autoBillResult.getGenBills();
        HashMap<Object, DynamicObject> idToObjMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject bill : bills) {
            idToObjMap.put(bill.getPkValue(), bill);
            if (!StringUtils.isNotEmpty((CharSequence)targetEntryKey)) continue;
            DynamicObjectCollection entires = bill.getDynamicObjectCollection(targetEntryKey);
            for (DynamicObject entry : entires) {
                idToObjMap.put(entry.getPkValue(), entry);
            }
        }
        Map<Object, Set<Object>> srclinkInfo = BotpLinkHelper.getSrcLinkInfo(bills, cre);
        List<AutoBillWriteOffGroup> autoBillGroups = new ArrayList<AutoBillWriteOffGroup>(16);
        for (WriteOffQueueGroup queueGroup : allQueues) {
            AutoBillWriteOffGroup autoBillGroup = new AutoBillWriteOffGroup(queueGroup, billBotpConfig, targetEntryKey);
            for (IWriteOffQueue queue : queueGroup.getCandidateQueues()) {
                for (WriteOffObjectBase wfObj : queue.peekAll()) {
                    Set<Object> targetIds = srclinkInfo.get(wfObj.getPkValue());
                    if (targetIds == null) continue;
                    for (Object targetId : targetIds) {
                        DynamicObject genEntry = (DynamicObject)idToObjMap.get(targetId);
                        autoBillGroup.addAutoBillObj(genEntry);
                    }
                }
            }
            autoBillGroups.add(autoBillGroup);
        }
        TraceSpan trace = Tracer.create((String)"AbstractNewWriteOffStrategy", (String)"IAutoBillHandler");
        Object object = null;
        try {
            for (IAutoBillHandler handler : this.getAutoBillHandlers()) {
                if (handler instanceof AbstractMergeSplitHandler) {
                    ((AbstractMergeSplitHandler)handler).setCre(cre);
                }
                autoBillGroups = handler.execute(autoBillGroups);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (trace != null) {
                if (object != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    trace.close();
                }
            }
        }
        return autoBillGroups;
    }

    protected List<IAutoBillHandler> getAutoBillHandlers() {
        ArrayList<IAutoBillHandler> handlers = new ArrayList<IAutoBillHandler>(3);
        if (!this.getTypeConfig().isMergeAutoBill()) {
            handlers.add(new SplitByWriteOffQueueHandler());
        }
        return handlers;
    }
}

