/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordGroupColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordGroupConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.WriteOffBillGenerator;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractTemplateWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.billgenerate.AutoGeneratorParam;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WfRecordGroupHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.AutoBill;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public abstract class AbstractWriteOffStrategy
extends AbstractTemplateWriteOffStrategy {
    @Override
    public void batchExecute(SchemeContextConfig schemeContextConfig, List<WriteOffQueueGroup> allCandidateQueues) {
        logger.info("\u6838\u9500\u7c7b\u522b\u3010" + this.getTypeConfig().getName() + "\u3011\u5f00\u59cb\u6267\u884c" + this.getClass().getSimpleName() + "\u6838\u9500\u7b56\u7565\u903b\u8f91\u3002");
        ArrayList<WriteOffRecordMapper> records = new ArrayList<WriteOffRecordMapper>(16);
        block0: for (WriteOffQueueGroup queueGroup : allCandidateQueues) {
            List<IWriteOffQueue> candidateQueues = queueGroup.getCandidateQueues();
            while (!this.isCompleted(candidateQueues)) {
                schemeContextConfig.setHasExcuteLastWhole(false);
                List<IWriteOffQueue> writeOffQueues = this.pickWriteOffObjects(schemeContextConfig, candidateQueues);
                if (CollectionUtils.isEmpty(writeOffQueues)) continue block0;
                List<List<IWriteOffQueue>> writeOffQueueGroups = this.wfRecordGroup(schemeContextConfig, writeOffQueues);
                for (List<IWriteOffQueue> writeOffQueueList : writeOffQueueGroups) {
                    String wbDetail = null;
                    if (this.getTypeConfig().isNeedGenerate()) {
                        List<GeneratorBillWf> generateBills = this.generateBill(writeOffQueueList);
                        this.getSnapShootHolder().addAutoBill(generateBills);
                        this.getExecuteContext().getPluginFactory().createWriteOffPluginProxy(this.getTypeConfig()).generateBillDeal(writeOffQueueList, generateBills);
                        Map<String, List<WriteOffObjectBase>> writeOffObjectMap = this.buildAutoBillWFObjects(this.getTypeConfig(), generateBills);
                        writeOffObjectMap.values().forEach(writeOffObjects -> {
                            WriteOffObjectQueue writeOffQueue = new WriteOffObjectQueue();
                            writeOffQueue.addAll((Collection<? extends WriteOffObjectBase>)writeOffObjects);
                            writeOffQueueList.add(writeOffQueue);
                        });
                        wbDetail = this.buildWriteDetail(generateBills);
                    }
                    WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueueList, wbDetail, schemeContextConfig);
                    records.add(recordBill);
                }
            }
        }
        this.handleRecords(schemeContextConfig, records);
        logger.info("\u6838\u9500\u7c7b\u522b\u3010" + this.getTypeConfig().getName() + "\u3011\u7ed3\u675f\u6267\u884c" + this.getClass().getSimpleName() + "\u6838\u9500\u7b56\u7565\u903b\u8f91\u3002");
    }

    protected List<List<IWriteOffQueue>> wfRecordGroup(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> writeOffQueues) {
        List<List<IWriteOffQueue>> writeOffQueueGroups = WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == this.getTypeConfig().getWfRecordTemplateEnum() ? (schemeContextConfig.hasExcuteLastWhole() ? WfRecordGroupHelper.buildLastWholeMainAsstQueues(writeOffQueues, this.getTypeConfig()) : WfRecordGroupHelper.buildMainAsstQueues(writeOffQueues, schemeContextConfig, this.getTypeConfig())) : this.groupByRecord(writeOffQueues, schemeContextConfig);
        return writeOffQueueGroups;
    }

    public abstract boolean isCompleted(List<IWriteOffQueue> var1);

    public abstract List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig var1, List<IWriteOffQueue> var2);

    protected List<List<IWriteOffQueue>> groupByRecord(List<IWriteOffQueue> writeOffQueueList, SchemeContextConfig schemeContextConfig) {
        RecordGroupConfig recordGroupConfig = this.getExecuteContext().getConfigManager().getRecordGroupConfigById(this.getTypeConfig().getId());
        if (recordGroupConfig == null) {
            return Collections.singletonList(writeOffQueueList);
        }
        recordGroupConfig.bindRecordSrcFiedConfigs(this.getExecuteContext().getConfigManager(), this.getTypeConfig().getId());
        IWriteOffQueue mainQueue = this.getWriteOffQueue(writeOffQueueList, recordGroupConfig);
        if (mainQueue == null) {
            return Collections.singletonList(writeOffQueueList);
        }
        Map<String, List<String>> result = this.getWfQueueMapping(writeOffQueueList);
        List<IWriteOffQueue> groupedWriteOffQueues = this.groupByBillColumn(mainQueue, recordGroupConfig, schemeContextConfig);
        if (groupedWriteOffQueues.size() == 1) {
            return Collections.singletonList(writeOffQueueList);
        }
        ArrayList<List<IWriteOffQueue>> writeOffQueueGroups = new ArrayList<List<IWriteOffQueue>>(writeOffQueueList.size());
        for (IWriteOffQueue groupedQueue : groupedWriteOffQueues) {
            ArrayList<IWriteOffQueue> newQueue = new ArrayList<IWriteOffQueue>(16);
            newQueue.add(groupedQueue);
            for (IWriteOffQueue writeOffQueue : writeOffQueueList) {
                if (writeOffQueue == mainQueue) continue;
                IWriteOffQueue writeOffQueueNew = this.groupByRecordGroupQueus(writeOffQueue, groupedQueue, schemeContextConfig, result);
                newQueue.add(writeOffQueueNew);
            }
            writeOffQueueGroups.add(newQueue);
        }
        return writeOffQueueGroups;
    }

    private List<IWriteOffQueue> groupByBillColumn(IWriteOffQueue writeOffQueue, RecordGroupConfig recordGroupConfig, SchemeContextConfig schemeContextConfig) {
        List<RecordGroupColumnConfig> recordGroupColumnConfigs = recordGroupConfig.getRecordGroupColumnConfigs();
        LinkedHashMap<String, WriteOffObjectQueue> groupMap = new LinkedHashMap<String, WriteOffObjectQueue>(16);
        List<WriteOffObjectBase> objectList = writeOffQueue.peekAll();
        for (WriteOffObjectBase writeOffObject : objectList) {
            StringBuilder key = new StringBuilder();
            for (RecordGroupColumnConfig columnConfig : recordGroupColumnConfigs) {
                Object value;
                if (StringUtils.isEmpty((Object)columnConfig.getSrcField())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u5b57\u6bb5:%1$s(%2$s)\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6e90\u5355\u5b57\u6bb5\uff0c\u8bf7\u5148\u5728\u901a\u7528\u6620\u5c04\u4e2d\u914d\u7f6e\u3002", (String)"AbstractWriteOffStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), columnConfig.getRecordFieldName(), columnConfig.getName()));
                }
                if ("wf$$qty".equals(columnConfig.getSrcField())) {
                    value = writeOffObject.getWriteOffNumber();
                } else if ("wf$$billType".equals(columnConfig.getSrcField())) {
                    Object writeOffBillPk = writeOffObject.getWfBillEntity().getPkValue();
                    WriteOffBillConfig writeOffBillConfig = this.getTypeConfig().getBillConfigsById((Long)writeOffBillPk);
                    value = writeOffBillConfig.getBillType();
                } else {
                    value = writeOffObject.getValue(columnConfig.getSrcField());
                }
                key.append(value);
            }
            if (!groupMap.containsKey(key.toString())) {
                groupMap.put(key.toString(), new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), schemeContextConfig, null));
            }
            ((IWriteOffQueue)groupMap.get(key.toString())).add(writeOffObject);
        }
        ArrayList<IWriteOffQueue> writeOffQueues = new ArrayList<IWriteOffQueue>(12);
        Set set = groupMap.entrySet();
        for (Map.Entry entry : set) {
            writeOffQueues.add((IWriteOffQueue)entry.getValue());
        }
        return writeOffQueues;
    }

    protected IWriteOffQueue groupByRecordGroupQueus(IWriteOffQueue srcWriteOffQueue, IWriteOffQueue writeOffQueue, SchemeContextConfig schemeContextConfig, Map<String, List<String>> map) {
        if (schemeContextConfig.isWhole() || schemeContextConfig.isLastWhole()) {
            String key = writeOffQueue.peek().getPkValue().toString() + "_" + writeOffQueue.peek().getWriteOffNumber().toString();
            return this.pickWfObject(srcWriteOffQueue, map, key, schemeContextConfig);
        }
        return this.groupByRecordGroupQueus(srcWriteOffQueue, writeOffQueue);
    }

    protected IWriteOffQueue groupByRecordGroupQueus(IWriteOffQueue srcWriteOffQueue, IWriteOffQueue writeOffQueue) {
        BigDecimal writeOffNumber = writeOffQueue.getSumWriteOffNumber();
        IWriteOffQueue writeOffQueueNew = srcWriteOffQueue.pollQueue(false, writeOffNumber);
        return writeOffQueueNew;
    }

    private IWriteOffQueue pickWfObject(IWriteOffQueue writeOffQueue, Map<String, List<String>> map, String key, SchemeContextConfig schemeContextConfig) {
        WriteOffObjectQueue resultWriteOffQueue = new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), schemeContextConfig, null);
        List<String> valueList = map.get(key);
        for (int size = writeOffQueue.size(); size > 0; --size) {
            WriteOffObjectBase writeOffObjectBase = writeOffQueue.poll();
            String assistValue = writeOffObjectBase.getPkValue().toString() + "_" + writeOffObjectBase.getWriteOffNumber().toString();
            if (valueList.contains(assistValue)) {
                resultWriteOffQueue.add(writeOffObjectBase);
                valueList.remove(assistValue);
                continue;
            }
            writeOffQueue.add(writeOffObjectBase);
        }
        return resultWriteOffQueue;
    }

    private IWriteOffQueue getWriteOffQueue(List<IWriteOffQueue> writeOffQueueList, RecordGroupConfig recordGroupConfig) {
        String groupBillType = recordGroupConfig.getGroupBillType();
        for (IWriteOffQueue writeOffQueue : writeOffQueueList) {
            if (writeOffQueue.isEmpty()) continue;
            DynamicObject wfBillEntity = writeOffQueue.peek().getWfBillEntity();
            String billAlias = this.getTypeConfig().getBillConfigsById((Long)wfBillEntity.getPkValue()).getBillAlias();
            if (!groupBillType.equals(billAlias)) continue;
            return writeOffQueue;
        }
        return null;
    }

    @Deprecated
    private List<GeneratorBillWf> generateBill(List<IWriteOffQueue> writeOffQueues) {
        ArrayList<GeneratorBillWf> bills = new ArrayList<GeneratorBillWf>(12);
        WriteOffBillGenerator generator = new WriteOffBillGenerator();
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            if (writeOffQueue.isEmpty()) continue;
            List<WriteOffObjectBase> writeOffObjects = writeOffQueue.peekAll();
            Long wfBillEntityId = (Long)writeOffObjects.get(0).getWfBillEntity().getPkValue();
            WriteOffBillConfig writeOffBillConfig = this.getTypeConfig().getBillConfigsById(wfBillEntityId);
            List<BillBotpConfig> billBotpConfigs = writeOffBillConfig.getBillBotpConfigs();
            GeneratorBillWf generateBills = new GeneratorBillWf();
            for (BillBotpConfig botp : billBotpConfigs) {
                AutoGeneratorParam param = new AutoGeneratorParam();
                param.setBotp(botp);
                param.setTypeConfig(this.getTypeConfig());
                param.setWriteOffObjects(writeOffObjects);
                AutoBill autoBill = generator.generate(param);
                if (autoBill == null) continue;
                generateBills.add(autoBill);
            }
            bills.add(generateBills);
        }
        generator.check();
        return bills;
    }

    protected final Map<String, List<WriteOffObjectBase>> buildAutoBillWFObjects(WriteOffTypeConfig typeConfig, List<GeneratorBillWf> generateBills) {
        HashMap<String, List<WriteOffObjectBase>> writeOffObjectMap = new HashMap<String, List<WriteOffObjectBase>>(16);
        List<WriteOffBillConfig> billConfigs = typeConfig.getBillConfigs();
        for (GeneratorBillWf wf : generateBills) {
            List<AutoBill> autoBillList = wf.getAutoBillList();
            for (AutoBill autoBill : autoBillList) {
                if (!autoBill.getNeedGenerate().booleanValue()) continue;
                List<DynamicObject> autoBill1List = autoBill.getAutoBill();
                WriteOffBillConfig writeOffBillConfig = billConfigs.stream().filter(n -> n.getBillAlias().equals(autoBill.getBillTypeKey())).findFirst().orElse(null);
                String mainFieldEntry = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass().mainFieldEntry();
                autoBill.setEntryKey(mainFieldEntry);
                List<WriteOffObjectBase> writeOffObjects = this.getAutoObjects(typeConfig, autoBill1List, writeOffBillConfig);
                List objectList = (List)writeOffObjectMap.get(autoBill.getBillTypeKey());
                if (objectList != null) {
                    ((List)writeOffObjectMap.get(autoBill.getBillTypeKey())).addAll(writeOffObjects);
                    continue;
                }
                writeOffObjectMap.put(autoBill.getBillTypeKey(), writeOffObjects);
            }
        }
        return writeOffObjectMap;
    }

    private String buildWriteDetail(List<GeneratorBillWf> generateBills) {
        BackWriteOffDetail detail = new BackWriteOffDetail();
        for (GeneratorBillWf generateBill : generateBills) {
            List<AutoBill> autoBillList = generateBill.getAutoBillList();
            for (AutoBill autoBill : autoBillList) {
                List<DynamicObject> objects = autoBill.getAutoBill();
                if (objects == null) continue;
                Boolean delete = autoBill.getDelete();
                String filterString = autoBill.getFilterString();
                String botpRule = autoBill.getBotpRule();
                for (DynamicObject object : objects) {
                    BackWriteOffDetail.AutoGeneration autoGeneration = new BackWriteOffDetail.AutoGeneration();
                    String name = object.getDataEntityType().getName();
                    autoGeneration.setBillId((Long)object.getPkValue());
                    autoGeneration.setBillType(name);
                    String billNo = ((BillEntityType)object.getDataEntityType()).getBillNo();
                    autoGeneration.setBillNo(object.getString(billNo));
                    autoGeneration.setDelete(delete);
                    autoGeneration.setFilterString(filterString);
                    autoGeneration.setBotpRule(botpRule);
                    detail.addAutoBill(autoGeneration);
                }
            }
        }
        return JSONObject.toJSONString((Object)detail);
    }

    private List<WriteOffObjectBase> getAutoObjects(WriteOffTypeConfig typeConfig, List<DynamicObject> autoBill1List, WriteOffBillConfig writeOffBillConfig) {
        ArrayList<WriteOffObjectBase> writeOffObjects = new ArrayList<WriteOffObjectBase>(16);
        Map<String, DynamicObject> autoBillHeadMapping = this.getSnapShootHolder().getAutoBillHeadMapping();
        boolean mergeAutoBill = this.getSnapShootHolder().isMergeAutoBill();
        for (DynamicObject autoBillObj : autoBill1List) {
            String billKey = CommonUtils.getWfBillKey(writeOffBillConfig.getBillType(), autoBillObj.getPkValue());
            DynamicObject bill = autoBillHeadMapping.get(billKey);
            List<WriteOffObject> writeOffObjectList = WriteOffGroupHelper.buildAutoWriteOffObjects(typeConfig, writeOffBillConfig, autoBillObj);
            for (WriteOffObject wfObj : writeOffObjectList) {
                WriteOffObjectBase writeOffObjectBase = wfObj.getWriteOffObjectBase();
                if (mergeAutoBill) {
                    writeOffObjectBase.setMergeAutoBill(bill);
                }
                writeOffObjects.add(writeOffObjectBase);
            }
        }
        return writeOffObjects;
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return null;
    }

    private Map<String, List<String>> getWfQueueMapping(List<IWriteOffQueue> writeOffQueueList) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        int size = writeOffQueueList.size();
        int queueSize = writeOffQueueList.get(0).size();
        List<WriteOffObjectBase> mainWriteOffObjectList = writeOffQueueList.get(0).peekAll();
        for (int j = 0; j < queueSize; ++j) {
            String mainWfObjKey = mainWriteOffObjectList.get(j).getPkValue().toString() + "_" + mainWriteOffObjectList.get(j).getWriteOffNumber();
            for (int i = 1; i < size; ++i) {
                List assistWfObjStr = result.getOrDefault(mainWfObjKey, new ArrayList(16));
                List<WriteOffObjectBase> assistWriteOffObjectList = writeOffQueueList.get(i).peekAll();
                int assistWriteOffQueueSize = assistWriteOffObjectList.size();
                if (assistWriteOffQueueSize > j) {
                    assistWfObjStr.add(assistWriteOffObjectList.get(j).getPkValue().toString() + "_" + assistWriteOffObjectList.get(j).getWriteOffNumber().toString());
                }
                if (j == queueSize - 1 && j < assistWriteOffQueueSize - 1) {
                    this.dealAssistWfObj(assistWfObjStr, assistWriteOffObjectList, j + 1);
                }
                result.put(mainWfObjKey, assistWfObjStr);
            }
        }
        return result;
    }

    private void dealAssistWfObj(List<String> assistWfObjList, List<WriteOffObjectBase> assistWriteOffObjectList, int index) {
        while (index < assistWriteOffObjectList.size()) {
            WriteOffObjectBase writeOffObjectBase = assistWriteOffObjectList.get(index);
            assistWfObjList.add(writeOffObjectBase.getPkValue().toString() + "_" + writeOffObjectBase.getWriteOffNumber().toString());
            ++index;
        }
    }
}

