/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WfRecordGroupHelper;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffQueueList;

public class SequenceWriteOffStrategy
extends AbstractWriteOffStrategy {
    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            if (!writeOffQueue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        String writeOffExecuteType;
        WriteOffQueueList selectedQueues = new WriteOffQueueList();
        switch (writeOffExecuteType = this.getWriteOffExecuteType(schemeContextConfig, candidateQueues)) {
            case "manualOrAutoLastWfAll": {
                this.doManualLastWhole(candidateQueues, selectedQueues, schemeContextConfig);
                break;
            }
            case "flowLastWf": {
                this.doLastWhole(candidateQueues, selectedQueues, schemeContextConfig);
                break;
            }
            case "flowOrAutoWf": {
                this.doWholeWriteOff(candidateQueues, selectedQueues, schemeContextConfig);
                break;
            }
            default: {
                this.otherWriteOff(candidateQueues, selectedQueues, schemeContextConfig);
            }
        }
        selectedQueues.setWriteOffExecuteType(writeOffExecuteType);
        return selectedQueues;
    }

    @Override
    protected List<List<IWriteOffQueue>> wfRecordGroup(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> writeOffQueues) {
        List<List<IWriteOffQueue>> writeOffQueueGroups = WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == this.getTypeConfig().getWfRecordTemplateEnum() ? (schemeContextConfig.hasExcuteLastWhole() ? WfRecordGroupHelper.buildLastWholeMainAsstQueues(writeOffQueues, this.getTypeConfig()) : (writeOffQueues instanceof WriteOffQueueList && "otherWf".equals(((WriteOffQueueList)writeOffQueues).getWriteOffExecuteType()) ? WfRecordGroupHelper.buildMainAsstQueues(writeOffQueues, schemeContextConfig, this.getTypeConfig(), true) : WfRecordGroupHelper.buildMainAsstQueues(writeOffQueues, schemeContextConfig, this.getTypeConfig()))) : this.groupByRecord(writeOffQueues, schemeContextConfig);
        return writeOffQueueGroups;
    }

    private String getWriteOffExecuteType(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        IWriteOffQueue writeOffObjectQueues = candidateQueues.get(0);
        WriteOffObjectBase mainWriteOffObject = writeOffObjectQueues.peek();
        boolean isLastWhole = schemeContextConfig.isLastWhole();
        String writeOffType = schemeContextConfig.getWfMode();
        boolean isWhole = schemeContextConfig.isWhole();
        if (isLastWhole) {
            if ("2".equals(writeOffType) || "3".equals(writeOffType)) {
                return "manualOrAutoLastWfAll";
            }
            if (mainWriteOffObject.getWhole().booleanValue() && "1".equals(writeOffType)) {
                return "flowLastWf";
            }
        } else if (isWhole && (this.queueIsWhole(candidateQueues) || "2".equals(writeOffType))) {
            return "flowOrAutoWf";
        }
        return "otherWf";
    }

    private void queueSort(boolean isWhole, List<IWriteOffQueue> candidateQueues) {
        if (isWhole) {
            for (IWriteOffQueue writeOffQueue : candidateQueues) {
                writeOffQueue.sortByWhole();
            }
        }
    }

    private boolean queueIsWhole(List<IWriteOffQueue> writeOffQueues) {
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            List<WriteOffObjectBase> writeOffObjectBases = writeOffQueue.peekAll();
            for (WriteOffObjectBase writeOffObject : writeOffObjectBases) {
                boolean flag = writeOffObject.getWhole();
                if (!flag) continue;
                return true;
            }
        }
        return false;
    }

    private BigDecimal countWriteOffNumber(List<IWriteOffQueue> candidateQueues) {
        BigDecimal sumWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            BigDecimal thisSumWriteOffNumber = writeOffQueue.getSumWriteOffNumber();
            if (thisSumWriteOffNumber.abs().compareTo(sumWriteOffNumber.abs()) >= 0) continue;
            sumWriteOffNumber = thisSumWriteOffNumber;
        }
        return sumWriteOffNumber;
    }

    private void doManualLastWhole(List<IWriteOffQueue> candidateQueues, List<IWriteOffQueue> selectedQueues, SchemeContextConfig schemeContextConfig) {
        for (int i = 0; i < candidateQueues.size(); ++i) {
            IWriteOffQueue writeOffQueue = candidateQueues.get(i);
            writeOffQueue.manualLastWholeQueue(i == 0);
        }
        this.doLastWhole(candidateQueues, selectedQueues, schemeContextConfig);
    }

    private void doLastWhole(List<IWriteOffQueue> candidateQueues, List<IWriteOffQueue> selectedQueues, SchemeContextConfig schemeContextConfig) {
        int queueSize = candidateQueues.size();
        IWriteOffQueue[] writeOffQueueArr = new IWriteOffQueue[queueSize];
        boolean finished = false;
        while (!finished) {
            Map<String, Object> map = this.getMinWriteOffNumberAndIsWhole(candidateQueues);
            boolean isWhole = (Boolean)map.get("isWhole");
            if (isWhole) {
                for (int i = 0; i < queueSize; ++i) {
                    IWriteOffQueue candidateQueue = candidateQueues.get(i);
                    IWriteOffQueue writeOffQueue = writeOffQueueArr[i] == null ? new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), schemeContextConfig, null) : writeOffQueueArr[i];
                    WriteOffObjectBase writeOffObject = candidateQueue.poll();
                    if (writeOffObject != null) {
                        writeOffObject.setWfComplete(true);
                        writeOffQueue.add(writeOffObject);
                    }
                    writeOffQueueArr[i] = writeOffQueue;
                }
                schemeContextConfig.setHasExcuteLastWhole(true);
                finished = true;
                continue;
            }
            BigDecimal minWriteOffNumber = (BigDecimal)map.get("writeOffNumber");
            for (int i = 0; i < queueSize; ++i) {
                IWriteOffQueue candidateQueue = candidateQueues.get(i);
                IWriteOffQueue writeOffQueue = writeOffQueueArr[i] == null ? new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), schemeContextConfig, null) : writeOffQueueArr[i];
                candidateQueue.pollQueueByCount(writeOffQueue, minWriteOffNumber);
                writeOffQueueArr[i] = writeOffQueue;
            }
            finished = this.isCompleted(candidateQueues);
        }
        for (IWriteOffQueue writeOffQueue : writeOffQueueArr) {
            selectedQueues.add(writeOffQueue);
        }
    }

    private void doWholeWriteOff(List<IWriteOffQueue> candidateQueues, List<IWriteOffQueue> selectedQueues, SchemeContextConfig schemeContextConfig) {
        int queueSize = candidateQueues.size();
        IWriteOffQueue[] writeOffQueueArr = new IWriteOffQueue[queueSize];
        boolean finished = false;
        while (!finished) {
            IWriteOffQueue mainQueue = candidateQueues.get(0);
            WriteOffObjectBase fristMainWriteOffObj = mainQueue.peek();
            boolean mainWhole = fristMainWriteOffObj.getWhole();
            BigDecimal mainWriteOffCount = fristMainWriteOffObj.getWriteOffNumber();
            BigDecimal minWriteOffCount = (BigDecimal)this.getMinWriteOffNumberAndIsWhole(candidateQueues).get("writeOffNumber");
            boolean isWhole = mainWriteOffCount.abs().compareTo(minWriteOffCount.abs()) <= 0 && mainWhole || !mainWhole && this.assistQueueFristIsWhole(candidateQueues) || this.assitQueueOnlyOne(candidateQueues) && mainWhole || "2".equals(schemeContextConfig.getWfMode());
            for (int i = 0; i < queueSize; ++i) {
                IWriteOffQueue writeOffQueue;
                IWriteOffQueue candidateQueue = candidateQueues.get(i);
                IWriteOffQueue iWriteOffQueue = writeOffQueue = writeOffQueueArr[i] == null ? new WriteOffObjectQueue(new ArrayList<BillSortConfig>(1), schemeContextConfig, null) : writeOffQueueArr[i];
                if (isWhole) {
                    writeOffQueue.add(candidateQueue.poll());
                } else {
                    candidateQueue.pollQueueByCount(writeOffQueue, minWriteOffCount);
                }
                writeOffQueueArr[i] = writeOffQueue;
            }
            finished = isWhole ? true : this.isCompleted(candidateQueues);
        }
        for (IWriteOffQueue writeOffQueue : writeOffQueueArr) {
            selectedQueues.add(writeOffQueue);
        }
    }

    private void otherWriteOff(List<IWriteOffQueue> candidateQueues, List<IWriteOffQueue> selectedQueues, SchemeContextConfig schemeContextConfig) {
        this.queueSort(false, candidateQueues);
        BigDecimal needWriteOffNumber = this.countWriteOffNumber(candidateQueues);
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            IWriteOffQueue writeOffQueue = candidateQueue.pollQueue(false, needWriteOffNumber);
            selectedQueues.add(writeOffQueue);
        }
    }

    private boolean assistQueueFristIsWhole(List<IWriteOffQueue> candidateQueues) {
        int size = candidateQueues.size();
        for (int i = 1; i < size; ++i) {
            IWriteOffQueue candidateQueue = candidateQueues.get(i);
            boolean isWhole = candidateQueue.peek().getWhole();
            if (isWhole) continue;
            return false;
        }
        return true;
    }

    private boolean assitQueueOnlyOne(List<IWriteOffQueue> candidateQueues) {
        int size = candidateQueues.size();
        for (int i = 1; i < size; ++i) {
            IWriteOffQueue candidateQueue = candidateQueues.get(i);
            if (candidateQueue.size() == 1) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> getMinWriteOffNumberAndIsWhole(List<IWriteOffQueue> candidateQueues) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        BigDecimal minWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        boolean isWhole = true;
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            WriteOffObjectBase writeOffObject = writeOffQueue.peek();
            if (writeOffObject == null) continue;
            boolean bl = isWhole = isWhole && writeOffObject.getWhole() != false;
            BigDecimal writeOffNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObject);
            if (writeOffNumber.abs().compareTo(minWriteOffNumber.abs()) >= 0) continue;
            minWriteOffNumber = writeOffNumber;
        }
        map.put("isWhole", isWhole);
        map.put("writeOffNumber", minWriteOffNumber);
        return map;
    }
}

