/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.param.impl;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.common.helper.ConditionHelper;

public class EntityConditionParam {
    private static final String SPIT_CHAR = "&@&";
    private final String entity;
    private final String srcEntityKey;
    private final Map<String, String> condtionInfo;

    EntityConditionParam(String entityParamKey, Map<String, String> condtionInfo) {
        this.srcEntityKey = entityParamKey;
        this.entity = entityParamKey.split(SPIT_CHAR)[0];
        this.condtionInfo = condtionInfo;
    }

    public String getSrcEntityKey() {
        return this.srcEntityKey;
    }

    public String getEntity() {
        return this.entity;
    }

    public Map<String, String> getCondtionInfo() {
        return this.condtionInfo;
    }

    public QFilter getBillFilter() {
        String pageFilter = this.condtionInfo.get("pageFilter");
        QFilter billFilter = QFilter.fromSerializedString((String)pageFilter);
        String wfTypeFilter = this.condtionInfo.get("wfTypeFilter");
        String wfTypeCFilter = this.condtionInfo.get("wfTypeCFilter");
        if (StringUtils.isEmpty((String)wfTypeFilter) && StringUtils.isEmpty((String)wfTypeCFilter)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u4e0d\u80fd\u542f\u7528\u81ea\u52a8\u6838\u9500\u3002", (String)"ManualWorkflowWriteOffEngine_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        CRCondition condition = null;
        if (!StringUtils.isEmpty((String)wfTypeFilter)) {
            condition = (CRCondition)SerializationUtils.fromJsonString((String)wfTypeFilter, CRCondition.class);
            QFilter wftFilter = ConditionHelper.getQFiltersFromConditon(this.entity, condition);
            billFilter.and(wftFilter);
        }
        CRCondition cCondition = null;
        if (!StringUtils.isEmpty((String)wfTypeCFilter)) {
            cCondition = (CRCondition)SerializationUtils.fromJsonString((String)wfTypeCFilter, CRCondition.class);
            QFilter wftFilter = ConditionHelper.getQFiltersFromConditon(this.entity, cCondition);
            billFilter.and(wftFilter);
        }
        return billFilter;
    }
}

