/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.unwf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfKdtxParamHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.unwf.AbstractUnWriteOffEngine;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.BillSelectFieldLoadHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffServerHelper;
import kd.mpscmm.mscommon.writeoff.common.lock.MutexLockUtils;
import kd.mpscmm.mscommon.writeoff.common.log.UnWriteOffLog;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowBackWriteOffEngine
extends AbstractUnWriteOffEngine {
    private final DynamicObject[] billEntities;
    private final String operationKey;

    public FlowBackWriteOffEngine(DynamicObject[] billEntities, String operationKey) {
        this.billEntities = billEntities;
        this.operationKey = operationKey;
    }

    @Override
    protected UnWriteOffLog initUnWFLog() {
        UnWriteOffLog unWriteOffLog = new UnWriteOffLog();
        UnWriteOffLogHelper.fillHeadLog(unWriteOffLog, this.getSeq(), this.operationKey, "F");
        IDataEntityType entityType = this.billEntities[0].getDataEntityType();
        UnWriteOffLogHelper.addSrcBillInfo(unWriteOffLog, this.billEntities, ((BillEntityType)entityType).getBillNo());
        return unWriteOffLog;
    }

    @Override
    protected void execute() {
        IDataEntityType entityType = this.billEntities[0].getDataEntityType();
        List<WriteOffTypeConfig> typeConfigs = this.getGetWfTypes(entityType, this.operationKey);
        List<Object> billIds = Stream.of(this.billEntities).map(item -> item.get("id")).collect(Collectors.toList());
        UnWfPluginExtFactory unWfPluginExtFactory = new UnWfPluginExtFactory();
        unWfPluginExtFactory.setWriteOffParamManager(this.getWriteOffParamManager());
        HashMap recordEntityToWFTypes = new HashMap(16);
        Set<Object> orgIdSet = WriteOffServerHelper.getWFPlanOrgSet(this.billEntities);
        for (int i = typeConfigs.size() - 1; i >= 0; --i) {
            String recordBillType;
            Long orgId;
            boolean isWfPlan;
            WriteOffTypeConfig typeConfig = typeConfigs.get(i);
            if (WriteOffServerHelper.getAllWFPlanType().contains(typeConfig.getId()) && !orgIdSet.contains(0L) && !(isWfPlan = WriteOffServerHelper.isWriteOffPlan(orgIdSet, orgId = Long.valueOf(this.billEntities[0].getDynamicObject("org").getLong("id")))) || StringUtils.isBlank((CharSequence)(recordBillType = typeConfig.getRecordNum()))) continue;
            MapUtils.mapGetListValue(recordEntityToWFTypes, recordBillType).add(typeConfig);
        }
        if (recordEntityToWFTypes.isEmpty()) {
            logger.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u9500\u7c7b\u522b\uff0c\u65e0\u6cd5\u8fdb\u884c\u6d41\u7a0b\u53cd\u6838\u9500\u3002");
            return;
        }
        Map<String, Set<String>> customBillFieldMap = BillSelectFieldLoadHelper.loadFields(new ArrayList<String>(recordEntityToWFTypes.keySet()));
        for (Map.Entry recordEntityToWFTypesEntry : recordEntityToWFTypes.entrySet()) {
            long start = System.currentTimeMillis();
            List wfTypeConfigs = (List)recordEntityToWFTypesEntry.getValue();
            ArrayList<Long> wfTypeIds = new ArrayList<Long>(16);
            for (WriteOffTypeConfig wfTypeConfig : wfTypeConfigs) {
                wfTypeIds.add(wfTypeConfig.getId());
            }
            String recordEntity = (String)recordEntityToWFTypesEntry.getKey();
            WriteOffTypeConfig writeOffTypeConfig = (WriteOffTypeConfig)wfTypeConfigs.get(0);
            WriteoffTemplateTypeEnum wfRecordTemplateEnum = writeOffTypeConfig.getWfRecordTemplateEnum();
            List<Object> wfRecordIds = null;
            if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfRecordTemplateEnum) {
                wfRecordIds = FlowBackWriteOffEngine.queryLeftRightWfRecordIds(recordEntity, wfTypeIds, billIds);
            } else if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfRecordTemplateEnum) {
                wfRecordIds = FlowBackWriteOffEngine.queryUpDownWfRecordIds(recordEntity, wfTypeIds, billIds);
            } else if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfRecordTemplateEnum) {
                wfRecordIds = this.queryMainAssistWfRecordIds(recordEntity, wfTypeIds, billIds);
            }
            QFilter recordFilter = new QFilter("id", "in", wfRecordIds);
            UnWriteOffLogHelper.addMatchCondition(this.getUnWriteOffLog(), recordEntity, recordFilter.toString(), CollectionUtils.isNotEmpty(wfRecordIds));
            if (wfRecordIds == null || wfRecordIds.isEmpty()) continue;
            String selectProperties = this.getSelectFields(customBillFieldMap, wfTypeConfigs, recordEntity, wfRecordTemplateEnum);
            Collection<DynamicObject> recordEntities = this.loadRecordsFromDB(recordEntity, selectProperties, recordFilter);
            BackWfKdtxParamHolder holder = this.createHolder(wfRecordTemplateEnum);
            holder.setSelectFields(selectProperties);
            this.handleUnWfKDTXHolder(holder, recordEntities, wfRecordTemplateEnum);
            Set<String> wfSeqLockSet = this.buildLockByWfSeq(recordEntity, recordEntities);
            holder.setWfRecordSeqLocks(wfSeqLockSet);
            if (CollectionUtils.isNotEmpty(wfSeqLockSet)) {
                try {
                    MutexLockUtils.doLock(wfSeqLockSet, true);
                }
                catch (Exception e) {
                    String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u53cd\u6838\u9500\u540e\u53f0\u4e8b\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FlowBackWriteOffEngine_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                    throw new KDBizException(errMsg);
                }
            }
            holder.doKdtx();
            long end = System.currentTimeMillis();
            logger.info("{}:\u6d41\u7a0b\u53cd\u6838\u9500\u8017\u65f6 {} ms", (Object)String.valueOf(wfTypeIds), (Object)(end - start));
        }
    }

    private Set<String> buildLockByWfSeq(String recordType, Collection<DynamicObject> recordEntities) {
        HashSet<String> lockSet = new HashSet<String>(4);
        for (DynamicObject recordEntity : recordEntities) {
            String wfSeq = recordEntity.getString("wfseq");
            lockSet.add(StringUtils.joinWith((String)"&&", (Object[])new Object[]{recordType, wfSeq, "isNotReEntry"}));
        }
        return lockSet;
    }

    protected final List<WriteOffTypeConfig> getGetWfTypes(IDataEntityType entityType, String operationKey) {
        List<Long> wfTypeList = this.getWfTypeList(operationKey, entityType.getName());
        if (wfTypeList.isEmpty()) {
            logger.info("\u6838\u9500\u7c7b\u522b\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        return this.getTypeConfig(wfTypeList);
    }

    private List<Long> getWfTypeList(String operationKey, String reqbillEntity) {
        QFilter billFilter = new QFilter("msmod_scheme_bill.writeoffbill.wfbill", "=", (Object)reqbillEntity);
        billFilter.and("writeofftype.writeofftype", "=", (Object)"A");
        Map schemeSetObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_schemeset", (QFilter[])billFilter.toArray());
        ArrayList<Long> wfTypeIdList = new ArrayList<Long>(8);
        for (DynamicObject schemeObj : schemeSetObjs.values()) {
            boolean isContainOp = false;
            DynamicObjectCollection schemeBills = schemeObj.getDynamicObjectCollection("msmod_scheme_bill");
            for (DynamicObject schemeBill : schemeBills) {
                String op = schemeBill.getString("rewriteoffop");
                DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
                String billEntity = writeOffBill.getDynamicObject("wfbill").getString("number");
                String[] ops = op.split(",");
                HashSet<String> opSet = new HashSet<String>(Arrays.asList(ops));
                if (!reqbillEntity.equals(billEntity) || !opSet.contains(operationKey)) continue;
                isContainOp = true;
            }
            if (!isContainOp) continue;
            Long wfTypeId = (Long)schemeObj.getDynamicObject("writeofftype").getPkValue();
            wfTypeIdList.add(wfTypeId);
        }
        return wfTypeIdList;
    }

    protected static List<Object> queryLeftRightWfRecordIds(String recordBillType, List<Long> wfTypeIds, List<Object> billIds) {
        QFilter qFilter = new QFilter("entry.billid", "in", billIds);
        qFilter.or("entry.assbillid", "in", billIds);
        qFilter.and("writeofftypeid", "in", wfTypeIds);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.toArray(), null, (int)-1);
        return ids;
    }

    protected static List<Object> queryUpDownWfRecordIds(String recordBillType, List<Long> wfTypeIds, List<Object> billIds) {
        QFilter qFilter = new QFilter("entry.billid", "in", billIds);
        qFilter.and("writeofftypeid", "in", wfTypeIds);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.toArray(), null, (int)-1);
        return ids;
    }

    protected List<Object> queryMainAssistWfRecordIds(String recordBillType, List<Long> wfTypeIds, List<Object> billIds) {
        QFilter qFilterType = new QFilter("writeofftypeid", "in", wfTypeIds);
        ArrayList<Object> ids = new ArrayList<Object>(billIds.size());
        QFilter qFilter = new QFilter("billid", "in", billIds);
        List idsById = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.and(qFilterType).toArray(), null, (int)-1);
        ids.addAll(idsById);
        QFilter qFilterEntryId = new QFilter("entry.e_billid", "in", billIds);
        List idsByEntryId = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilterEntryId.and(qFilterType).toArray(), null, (int)-1);
        ids.addAll(idsByEntryId);
        return ids;
    }

    protected final DynamicObject[] getBillEntities() {
        return this.billEntities;
    }

    protected final String getOperationKey() {
        return this.operationKey;
    }
}

