/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;

public class EntityParseHelper {
    public static Map<String, IDataEntityProperty> findPropertys(EntityType mainType, String fullPropName) {
        LinkedHashMap<String, IDataEntityProperty> props = new LinkedHashMap<String, IDataEntityProperty>(16);
        if (!mainType.getName().equalsIgnoreCase(fullPropName) && !"billhead".equalsIgnoreCase(fullPropName)) {
            Object prop = null;
            String[] keys = fullPropName.split("\\.");
            ArrayList<String> unknowKeys = new ArrayList<String>(10);
            for (int i = 0; i < keys.length; ++i) {
                unknowKeys.add(keys[i]);
            }
            String key = keys[0];
            int nextKeyIndex = 1;
            if (keys.length == 1) {
                prop = mainType.findProperty(key);
                if (prop != null) {
                    props.put(key, (IDataEntityProperty)prop);
                } else {
                    props.put(key, null);
                }
                unknowKeys.clear();
            } else if (keys.length > 1) {
                prop = mainType.findProperty(key);
                if (prop == null) {
                    props.put(fullPropName, null);
                    unknowKeys.clear();
                } else {
                    props.put(key, (IDataEntityProperty)prop);
                    unknowKeys.remove(0);
                    String keyTemp = keys[nextKeyIndex];
                    if (prop instanceof EntryProp) {
                        prop = mainType.findProperty(keyTemp);
                        if (prop == null) {
                            prop = mainType.findProperty(key + "." + keyTemp);
                        }
                        ++nextKeyIndex;
                        if (prop != null) {
                            props.put(keyTemp, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                    if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                        keyTemp = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        BasedataProp bdPropTemp = (BasedataProp)prop;
                        MainEntityType baseEntityType1 = (MainEntityType)bdPropTemp.getComplexType();
                        if ((prop = baseEntityType1.getPrimaryKey().getName().equals(keyTemp) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(keyTemp)) != null) {
                            props.put(keyTemp, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                        if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                            String keyStr = keys[nextKeyIndex];
                            ++nextKeyIndex;
                            BasedataProp bdPropTmp = (BasedataProp)prop;
                            MainEntityType baseEntityTypeTmp = (MainEntityType)bdPropTmp.getComplexType();
                            if ((prop = baseEntityTypeTmp.getPrimaryKey().getName().equals(keyStr) ? baseEntityTypeTmp.getPrimaryKey() : baseEntityTypeTmp.findProperty(keyStr)) != null) {
                                props.put(keyStr, (IDataEntityProperty)prop);
                                unknowKeys.remove(0);
                            }
                        }
                    }
                }
            }
            if (unknowKeys.size() > 0) {
                props.put(StringUtils.join(unknowKeys, (String)"."), null);
            }
            return props;
        }
        props.put(fullPropName, (IDataEntityProperty)mainType.getPrimaryKey());
        return props;
    }

    public static TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = EntityParseHelper.buildFldTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>(16);
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet(16);
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String proKeyPrefix = "";
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            if (entityType instanceof EntryType && entityType.getParent() instanceof MainEntityType) {
                entityNodeId = "billentrykey";
            } else if (entityType instanceof SubEntryType && entityType.getParent() instanceof EntryType) {
                entityNodeId = "billsubentrykey";
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>(10);
            if (parameter.isIncludePKField()) {
                EntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            if (parameter.getMatchedProperty() instanceof EntryProp) {
                TreeNode seqNode;
                nodes.add(entityNode);
                DynamicProperty seqProp = entityType.getProperty("seq");
                if (seqProp != null && (seqNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                    seqNode.setText(CommonUtils.strConnect(entityType.getDisplayName().toString(), ResManager.loadKDString((String)".\u5e8f\u53f7", (String)"EntityParseHelper_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0])));
                    entityFldNodes.add(seqNode);
                }
                nodes.addAll(entityFldNodes);
                continue;
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = EntityParseHelper.buildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, proKeyPrefix, parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = EntityParseHelper.buildFldTreeNode(property, null, null, entityNode, proKeyPrefix, parameter.isDynamicText());
                }
                String proName = property.getName();
                BasedataProp bdProp = (BasedataProp)property;
                MainEntityType bdType = (MainEntityType)bdProp.getComplexType();
                List<TreeNode> refNodes = EntityParseHelper.buildBDFldRefPropNodes(bdType, parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, proName, parameter.isDynamicText());
                if (refNodes.size() <= 0) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static List<TreeNode> buildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>(10);
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefixTmp;
            BasedataProp bdPropTmp;
            MainEntityType bdTypeTmp;
            List<TreeNode> refNodesTmp;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = EntityParseHelper.buildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = EntityParseHelper.buildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodesTmp = EntityParseHelper.buildBDFldRefPropNodes(bdTypeTmp = (MainEntityType)(bdPropTmp = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefixTmp = property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodesTmp);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    static TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = EntityParseHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(CommonUtils.strConnect(entityType.getDisplayName().toString(), ResManager.loadKDString((String)".\u5185\u7801", (String)"EntityParseHelper_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0])));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(CommonUtils.strConnect(entityType.getDisplayName().toString(), ResManager.loadKDString((String)".\u5185\u7801", (String)"EntityParseHelper_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0])));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                seqNode.setText(CommonUtils.strConnect(entityType.getDisplayName().toString(), ResManager.loadKDString((String)".\u5e8f\u53f7", (String)"EntityParseHelper_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0])));
                entityFldNodes.add(seqNode);
            }
        }
    }

    static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    public static boolean isLeftRightRecord(String recordTypeName) {
        MainEntityType dataEntityType;
        String inheritPath = EntityMetadataCache.getDataEntityType((String)recordTypeName).getInheritPath();
        return inheritPath != null && ("msmod_leftrighwfrecordtpl".equals((dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)inheritPath)).getName()) || "msmod_leftrtamounttpl".equals(dataEntityType.getName()));
    }

    public static MainEntityType getInheritEntity(String entity) {
        String inheritPath = EntityMetadataCache.getDataEntityType((String)entity).getInheritPath();
        if (inheritPath != null) {
            return EntityMetadataCache.getDataEntityTypeById((String)inheritPath);
        }
        return null;
    }
}

