/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.cols.DefaultSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.PropertyDataType;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;
    private static final Class<?>[] superClass = new Class[]{AmountProp.class, IntegerProp.class, QtyProp.class, TextProp.class, DateTimeProp.class};

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(this.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    private String getMsgMetaHelperError() {
        return ResManager.loadKDString((String)"MetaHelper:\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaHelper_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this(null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this(null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON(String buildTree, PropertyDataType ... showDataTypes) {
        return SerializationUtils.toJsonString((Object)this.buildTree(buildTree, showDataTypes));
    }

    public String buildTree2JSON(PropertyDataType ... showDataTypes) {
        return SerializationUtils.toJsonString((Object)this.buildTree(showDataTypes));
    }

    public String buildTree2JSON(List<String> filterFileds, PropertyDataType ... showDataTypes) {
        List<String> strings = this.buildFilterField(filterFileds);
        return SerializationUtils.toJsonString((Object)this.buildTreeFilteField(strings, showDataTypes));
    }

    public String buildTreeJSON(IDataEntityProperty ... otherPros) {
        return SerializationUtils.toJsonString((Object)this.build2Tree(otherPros));
    }

    private List<String> buildFilterField(List<String> filterFields) {
        ArrayList<String> list = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(filterFields)) {
            for (String field : filterFields) {
                if (field == null) continue;
                String[] fields = field.split("\\.");
                if (fields.length > 1) {
                    String endField = fields[fields.length - 1];
                    list.add(endField);
                    continue;
                }
                list.add(field);
            }
        }
        return list;
    }

    public TreeNode build2Tree(IDataEntityProperty ... otherPros) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            if (otherPros.length != 0) {
                boolean isShow = false;
                for (IDataEntityProperty otherPro : otherPros) {
                    if (!MetaHelper.compareDataType(pro, otherPro)) continue;
                    isShow = true;
                    break;
                }
                if (!isShow) continue;
            }
            if ((parent = pro.getParent()) instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    public TreeNode buildTreeFilteField(List<String> filterFileds, PropertyDataType ... showDataTypes) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            if (!CollectionUtils.isEmpty(filterFileds) && filterFileds.contains(pro.getName())) continue;
            if (showDataTypes.length != 0) {
                boolean isShow = false;
                String proDataType = MetaHelper.getProDataType(pro);
                for (PropertyDataType dataTypeEnum : showDataTypes) {
                    String dataType = dataTypeEnum.getDataType();
                    if (!dataType.equals(proDataType)) continue;
                    isShow = true;
                    break;
                }
                if (!isShow) continue;
            }
            if ((parent = pro.getParent()) instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    public TreeNode buildTree(String entryKey, PropertyDataType ... showDataTypes) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            if (showDataTypes.length != 0) {
                boolean isShow = false;
                String proDataType = MetaHelper.getProDataType(pro);
                for (PropertyDataType dataTypeEnum : showDataTypes) {
                    String dataType = dataTypeEnum.getDataType();
                    if (!dataType.equals(proDataType)) continue;
                    isShow = true;
                    break;
                }
                if (!isShow) continue;
            }
            parent = pro.getParent();
            String name = parent.getName();
            if (entryKey != null && !name.equals(entryKey)) continue;
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    public TreeNode buildTree(PropertyDataType ... showDataTypes) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            if (showDataTypes.length != 0) {
                boolean isShow = false;
                String proDataType = MetaHelper.getProDataType(pro);
                for (PropertyDataType dataTypeEnum : showDataTypes) {
                    String dataType = dataTypeEnum.getDataType();
                    if (!dataType.equals(proDataType)) continue;
                    isShow = true;
                    break;
                }
                if (!isShow) continue;
            }
            if ((parent = pro.getParent()) instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }

    public static boolean compareDataType(IDataEntityProperty property, IDataEntityProperty otherProperty) {
        if (property instanceof ItemClassProp) {
            return otherProperty instanceof ItemClassProp;
        }
        if (property instanceof MaterielProp) {
            return otherProperty instanceof MaterielProp;
        }
        if (property instanceof FlexProp) {
            return otherProperty instanceof FlexProp;
        }
        if (property instanceof BasedataProp) {
            boolean isBaseDataType = otherProperty instanceof BasedataProp;
            if (!isBaseDataType) {
                return false;
            }
            BasedataProp pro = (BasedataProp)property;
            String baseEntityId = pro.getBaseEntityId();
            BasedataProp otherProp = (BasedataProp)otherProperty;
            String otherEntityId = otherProp.getBaseEntityId();
            return baseEntityId.equals(otherEntityId);
        }
        if (MetaHelper.isSameSuperClass(property, otherProperty, superClass)) {
            return true;
        }
        return property.getClass().equals(otherProperty.getClass());
    }

    private static boolean isSameSuperClass(Object sourceProp, Object targetProp, Class<?> ... classes) {
        Class<?> targetClass = targetProp.getClass();
        Class<?> sourceClass = sourceProp.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(targetClass) || !clazz.isAssignableFrom(sourceClass)) continue;
            return true;
        }
        return false;
    }

    public static String getProDataType(IDataEntityProperty property) {
        if (property instanceof BooleanProp) {
            return "boolean";
        }
        if (property instanceof LargeTextProp) {
            return ((LargeTextProp)property).getClientType();
        }
        if (property instanceof TextProp) {
            return "simpleText";
        }
        if (property instanceof AmountProp) {
            return "amount";
        }
        if (property instanceof BigIntProp) {
            return "long";
        }
        if (property instanceof IntegerProp) {
            return "int";
        }
        if (property instanceof QtyProp) {
            return "qty";
        }
        if (property instanceof DecimalProp) {
            return "othernumber";
        }
        if (property instanceof DateProp) {
            return ((DateProp)property).getFilterControlType();
        }
        if (property instanceof MaterielProp) {
            return "material";
        }
        if (property instanceof OrgProp) {
            return ((OrgProp)property).getFilterControlType();
        }
        if (property instanceof UserProp) {
            return ((UserProp)property).getFilterControlType();
        }
        if (property instanceof ItemClassProp) {
            return "multibasedata";
        }
        if (property instanceof ComboProp) {
            return ((ComboProp)property).getFilterControlType();
        }
        if (property instanceof FlexProp) {
            return "flex";
        }
        if (property instanceof BasedataProp) {
            return "otherbasedata";
        }
        return "unknown";
    }
}

